// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.resourcemanager.authorization.fluent.DirectoryRolesDirectoryRolesClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryRole;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesDirectoryRoleExpand;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesDirectoryRoleOrderby;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesDirectoryRoleSelect;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryRoleInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DirectoryRolesDirectoryRolesClient. */
public final class DirectoryRolesDirectoryRolesClientImpl implements DirectoryRolesDirectoryRolesClient {
    private final ClientLogger logger = new ClientLogger(DirectoryRolesDirectoryRolesClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final DirectoryRolesDirectoryRolesService service;

    /** The service client containing this operation class. */
    private final MicrosoftGraphClientImpl client;

    /**
     * Initializes an instance of DirectoryRolesDirectoryRolesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    DirectoryRolesDirectoryRolesClientImpl(MicrosoftGraphClientImpl client) {
        this.service =
            RestProxy
                .create(
                    DirectoryRolesDirectoryRolesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MicrosoftGraphClientDirectoryRolesDirectoryRoles to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MicrosoftGraphClient")
    private interface DirectoryRolesDirectoryRolesService {
        @Headers({"Content-Type: application/json"})
        @Get("/directoryRoles")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryRole>> listDirectoryRole(
            @HostParam("$host") String endpoint,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/directoryRoles")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDirectoryRoleInner>> createDirectoryRole(
            @HostParam("$host") String endpoint,
            @BodyParam("application/json") MicrosoftGraphDirectoryRoleInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/directoryRoles/{directoryRole-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDirectoryRoleInner>> getDirectoryRole(
            @HostParam("$host") String endpoint,
            @PathParam("directoryRole-id") String directoryRoleId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/directoryRoles/{directoryRole-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateDirectoryRole(
            @HostParam("$host") String endpoint,
            @PathParam("directoryRole-id") String directoryRoleId,
            @BodyParam("application/json") MicrosoftGraphDirectoryRoleInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/directoryRoles/{directoryRole-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteDirectoryRole(
            @HostParam("$host") String endpoint,
            @PathParam("directoryRole-id") String directoryRoleId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryRole>> listMore(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Get entities from directoryRoles.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryRoleInner>> listDirectoryRoleSinglePageAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryRolesDirectoryRoleOrderby> orderby,
        List<DirectoryRolesDirectoryRoleSelect> select,
        List<DirectoryRolesDirectoryRoleExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listDirectoryRole(
                            this.client.getEndpoint(),
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphDirectoryRoleInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get entities from directoryRoles.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryRoleInner>> listDirectoryRoleSinglePageAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryRolesDirectoryRoleOrderby> orderby,
        List<DirectoryRolesDirectoryRoleSelect> select,
        List<DirectoryRolesDirectoryRoleExpand> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listDirectoryRole(
                this.client.getEndpoint(),
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get entities from directoryRoles.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryRoleInner> listDirectoryRoleAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryRolesDirectoryRoleOrderby> orderby,
        List<DirectoryRolesDirectoryRoleSelect> select,
        List<DirectoryRolesDirectoryRoleExpand> expand) {
        return new PagedFlux<>(
            () -> listDirectoryRoleSinglePageAsync(top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get entities from directoryRoles.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryRoleInner> listDirectoryRoleAsync() {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DirectoryRolesDirectoryRoleOrderby> orderby = null;
        final List<DirectoryRolesDirectoryRoleSelect> select = null;
        final List<DirectoryRolesDirectoryRoleExpand> expand = null;
        return new PagedFlux<>(
            () -> listDirectoryRoleSinglePageAsync(top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get entities from directoryRoles.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryRoleInner> listDirectoryRoleAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryRolesDirectoryRoleOrderby> orderby,
        List<DirectoryRolesDirectoryRoleSelect> select,
        List<DirectoryRolesDirectoryRoleExpand> expand,
        Context context) {
        return new PagedFlux<>(
            () -> listDirectoryRoleSinglePageAsync(top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listMoreSinglePageAsync(nextLink, context));
    }

    /**
     * Get entities from directoryRoles.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryRoleInner> listDirectoryRole() {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DirectoryRolesDirectoryRoleOrderby> orderby = null;
        final List<DirectoryRolesDirectoryRoleSelect> select = null;
        final List<DirectoryRolesDirectoryRoleExpand> expand = null;
        return new PagedIterable<>(listDirectoryRoleAsync(top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get entities from directoryRoles.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryRoleInner> listDirectoryRole(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryRolesDirectoryRoleOrderby> orderby,
        List<DirectoryRolesDirectoryRoleSelect> select,
        List<DirectoryRolesDirectoryRoleExpand> expand,
        Context context) {
        return new PagedIterable<>(
            listDirectoryRoleAsync(top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Add new entity to directoryRoles.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryRoleInner>> createDirectoryRoleWithResponseAsync(
        MicrosoftGraphDirectoryRoleInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createDirectoryRole(this.client.getEndpoint(), body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Add new entity to directoryRoles.
     *
     * @param body New entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryRoleInner>> createDirectoryRoleWithResponseAsync(
        MicrosoftGraphDirectoryRoleInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createDirectoryRole(this.client.getEndpoint(), body, accept, context);
    }

    /**
     * Add new entity to directoryRoles.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryRoleInner> createDirectoryRoleAsync(MicrosoftGraphDirectoryRoleInner body) {
        return createDirectoryRoleWithResponseAsync(body)
            .flatMap(
                (Response<MicrosoftGraphDirectoryRoleInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Add new entity to directoryRoles.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDirectoryRoleInner createDirectoryRole(MicrosoftGraphDirectoryRoleInner body) {
        return createDirectoryRoleAsync(body).block();
    }

    /**
     * Add new entity to directoryRoles.
     *
     * @param body New entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryRoleInner> createDirectoryRoleWithResponse(
        MicrosoftGraphDirectoryRoleInner body, Context context) {
        return createDirectoryRoleWithResponseAsync(body, context).block();
    }

    /**
     * Get entity from directoryRoles by key.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from directoryRoles by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryRoleInner>> getDirectoryRoleWithResponseAsync(
        String directoryRoleId,
        List<DirectoryRolesDirectoryRoleSelect> select,
        List<DirectoryRolesDirectoryRoleExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getDirectoryRole(
                            this.client.getEndpoint(),
                            directoryRoleId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get entity from directoryRoles by key.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from directoryRoles by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryRoleInner>> getDirectoryRoleWithResponseAsync(
        String directoryRoleId,
        List<DirectoryRolesDirectoryRoleSelect> select,
        List<DirectoryRolesDirectoryRoleExpand> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getDirectoryRole(
                this.client.getEndpoint(), directoryRoleId, selectConverted, expandConverted, accept, context);
    }

    /**
     * Get entity from directoryRoles by key.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from directoryRoles by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryRoleInner> getDirectoryRoleAsync(
        String directoryRoleId,
        List<DirectoryRolesDirectoryRoleSelect> select,
        List<DirectoryRolesDirectoryRoleExpand> expand) {
        return getDirectoryRoleWithResponseAsync(directoryRoleId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphDirectoryRoleInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get entity from directoryRoles by key.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from directoryRoles by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryRoleInner> getDirectoryRoleAsync(String directoryRoleId) {
        final List<DirectoryRolesDirectoryRoleSelect> select = null;
        final List<DirectoryRolesDirectoryRoleExpand> expand = null;
        return getDirectoryRoleWithResponseAsync(directoryRoleId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphDirectoryRoleInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get entity from directoryRoles by key.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from directoryRoles by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDirectoryRoleInner getDirectoryRole(String directoryRoleId) {
        final List<DirectoryRolesDirectoryRoleSelect> select = null;
        final List<DirectoryRolesDirectoryRoleExpand> expand = null;
        return getDirectoryRoleAsync(directoryRoleId, select, expand).block();
    }

    /**
     * Get entity from directoryRoles by key.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from directoryRoles by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryRoleInner> getDirectoryRoleWithResponse(
        String directoryRoleId,
        List<DirectoryRolesDirectoryRoleSelect> select,
        List<DirectoryRolesDirectoryRoleExpand> expand,
        Context context) {
        return getDirectoryRoleWithResponseAsync(directoryRoleId, select, expand, context).block();
    }

    /**
     * Update entity in directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateDirectoryRoleWithResponseAsync(
        String directoryRoleId, MicrosoftGraphDirectoryRoleInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.updateDirectoryRole(this.client.getEndpoint(), directoryRoleId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update entity in directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body New property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateDirectoryRoleWithResponseAsync(
        String directoryRoleId, MicrosoftGraphDirectoryRoleInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateDirectoryRole(this.client.getEndpoint(), directoryRoleId, body, accept, context);
    }

    /**
     * Update entity in directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateDirectoryRoleAsync(String directoryRoleId, MicrosoftGraphDirectoryRoleInner body) {
        return updateDirectoryRoleWithResponseAsync(directoryRoleId, body)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update entity in directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateDirectoryRole(String directoryRoleId, MicrosoftGraphDirectoryRoleInner body) {
        updateDirectoryRoleAsync(directoryRoleId, body).block();
    }

    /**
     * Update entity in directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body New property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateDirectoryRoleWithResponse(
        String directoryRoleId, MicrosoftGraphDirectoryRoleInner body, Context context) {
        return updateDirectoryRoleWithResponseAsync(directoryRoleId, body, context).block();
    }

    /**
     * Delete entity from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDirectoryRoleWithResponseAsync(String directoryRoleId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.deleteDirectoryRole(this.client.getEndpoint(), directoryRoleId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete entity from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteDirectoryRoleWithResponseAsync(
        String directoryRoleId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteDirectoryRole(this.client.getEndpoint(), directoryRoleId, ifMatch, accept, context);
    }

    /**
     * Delete entity from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteDirectoryRoleAsync(String directoryRoleId, String ifMatch) {
        return deleteDirectoryRoleWithResponseAsync(directoryRoleId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete entity from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteDirectoryRoleAsync(String directoryRoleId) {
        final String ifMatch = null;
        return deleteDirectoryRoleWithResponseAsync(directoryRoleId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete entity from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteDirectoryRole(String directoryRoleId) {
        final String ifMatch = null;
        deleteDirectoryRoleAsync(directoryRoleId, ifMatch).block();
    }

    /**
     * Delete entity from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteDirectoryRoleWithResponse(String directoryRoleId, String ifMatch, Context context) {
        return deleteDirectoryRoleWithResponseAsync(directoryRoleId, ifMatch, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryRole.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryRoleInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listMore(nextLink, context))
            .<PagedResponse<MicrosoftGraphDirectoryRoleInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryRole.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryRoleInner>> listMoreSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listMore(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }
}
