// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.resourcemanager.authorization.fluent.DomainsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject9;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDomainDnsRecord;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDomainDnsRecord0;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject8;
import com.azure.resourcemanager.authorization.fluent.models.DomainsForceDeleteRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DomainsOrderby;
import com.azure.resourcemanager.authorization.fluent.models.DomainsSelect;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDomainDnsRecordInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDomainInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DomainsClient. */
public final class DomainsClientImpl implements DomainsClient {
    private final ClientLogger logger = new ClientLogger(DomainsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final DomainsService service;

    /** The service client containing this operation class. */
    private final MicrosoftGraphClientImpl client;

    /**
     * Initializes an instance of DomainsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    DomainsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = RestProxy.create(DomainsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MicrosoftGraphClientDomains to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MicrosoftGraphClient")
    private interface DomainsService {
        @Headers({"Content-Type: application/json"})
        @Get("/domains/{domain-id}/domainNameReferences")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject9>> listDomainNameReferences(
            @HostParam("$host") String endpoint,
            @PathParam("domain-id") String domainId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/domains/{domain-id}/domainNameReferences/$ref")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject8>> listRefDomainNameReferences(
            @HostParam("$host") String endpoint,
            @PathParam("domain-id") String domainId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/domains/{domain-id}/domainNameReferences/$ref")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Map<String, Object>>> createRefDomainNameReferences(
            @HostParam("$host") String endpoint,
            @PathParam("domain-id") String domainId,
            @BodyParam("application/json") Map<String, Object> body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/domains/{domain-id}/microsoft.graph.forceDelete")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> forceDelete(
            @HostParam("$host") String endpoint,
            @PathParam("domain-id") String domainId,
            @BodyParam("application/json") DomainsForceDeleteRequestBody body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/domains/{domain-id}/microsoft.graph.verify")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDomainInner>> verify(
            @HostParam("$host") String endpoint,
            @PathParam("domain-id") String domainId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/domains/{domain-id}/serviceConfigurationRecords")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDomainDnsRecord>> listServiceConfigurationRecords(
            @HostParam("$host") String endpoint,
            @PathParam("domain-id") String domainId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/domains/{domain-id}/serviceConfigurationRecords")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDomainDnsRecordInner>> createServiceConfigurationRecords(
            @HostParam("$host") String endpoint,
            @PathParam("domain-id") String domainId,
            @BodyParam("application/json") MicrosoftGraphDomainDnsRecordInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/domains/{domain-id}/serviceConfigurationRecords/{domainDnsRecord-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDomainDnsRecordInner>> getServiceConfigurationRecords(
            @HostParam("$host") String endpoint,
            @PathParam("domain-id") String domainId,
            @PathParam("domainDnsRecord-id") String domainDnsRecordId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/domains/{domain-id}/serviceConfigurationRecords/{domainDnsRecord-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateServiceConfigurationRecords(
            @HostParam("$host") String endpoint,
            @PathParam("domain-id") String domainId,
            @PathParam("domainDnsRecord-id") String domainDnsRecordId,
            @BodyParam("application/json") MicrosoftGraphDomainDnsRecordInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/domains/{domain-id}/serviceConfigurationRecords/{domainDnsRecord-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteServiceConfigurationRecords(
            @HostParam("$host") String endpoint,
            @PathParam("domain-id") String domainId,
            @PathParam("domainDnsRecord-id") String domainDnsRecordId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/domains/{domain-id}/verificationDnsRecords")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDomainDnsRecord0>> listVerificationDnsRecords(
            @HostParam("$host") String endpoint,
            @PathParam("domain-id") String domainId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/domains/{domain-id}/verificationDnsRecords")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDomainDnsRecordInner>> createVerificationDnsRecords(
            @HostParam("$host") String endpoint,
            @PathParam("domain-id") String domainId,
            @BodyParam("application/json") MicrosoftGraphDomainDnsRecordInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/domains/{domain-id}/verificationDnsRecords/{domainDnsRecord-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDomainDnsRecordInner>> getVerificationDnsRecords(
            @HostParam("$host") String endpoint,
            @PathParam("domain-id") String domainId,
            @PathParam("domainDnsRecord-id") String domainDnsRecordId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/domains/{domain-id}/verificationDnsRecords/{domainDnsRecord-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateVerificationDnsRecords(
            @HostParam("$host") String endpoint,
            @PathParam("domain-id") String domainId,
            @PathParam("domainDnsRecord-id") String domainDnsRecordId,
            @BodyParam("application/json") MicrosoftGraphDomainDnsRecordInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/domains/{domain-id}/verificationDnsRecords/{domainDnsRecord-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteVerificationDnsRecords(
            @HostParam("$host") String endpoint,
            @PathParam("domain-id") String domainId,
            @PathParam("domainDnsRecord-id") String domainDnsRecordId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject9>> listMore(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject8>> listRefDomainNameReferencesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDomainDnsRecord>> listServiceConfigurationRecordsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDomainDnsRecord0>> listVerificationDnsRecordsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Get domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listDomainNameReferencesSinglePageAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listDomainNameReferences(
                            this.client.getEndpoint(),
                            domainId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listDomainNameReferencesSinglePageAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listDomainNameReferences(
                this.client.getEndpoint(),
                domainId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listDomainNameReferencesAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () ->
                listDomainNameReferencesSinglePageAsync(
                    domainId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listDomainNameReferencesAsync(String domainId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DomainsOrderby> orderby = null;
        final List<DomainsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () ->
                listDomainNameReferencesSinglePageAsync(
                    domainId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listDomainNameReferencesAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listDomainNameReferencesSinglePageAsync(
                    domainId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listMoreSinglePageAsync(nextLink, context));
    }

    /**
     * Get domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listDomainNameReferences(String domainId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DomainsOrderby> orderby = null;
        final List<DomainsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listDomainNameReferencesAsync(domainId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listDomainNameReferences(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listDomainNameReferencesAsync(
                domainId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Get ref of domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefDomainNameReferencesSinglePageAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listRefDomainNameReferences(
                            this.client.getEndpoint(),
                            domainId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            accept,
                            context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get ref of domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefDomainNameReferencesSinglePageAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listRefDomainNameReferences(
                this.client.getEndpoint(),
                domainId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get ref of domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefDomainNameReferencesAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby) {
        return new PagedFlux<>(
            () -> listRefDomainNameReferencesSinglePageAsync(domainId, top, skip, search, filter, count, orderby),
            nextLink -> listRefDomainNameReferencesNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefDomainNameReferencesAsync(String domainId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DomainsOrderby> orderby = null;
        return new PagedFlux<>(
            () -> listRefDomainNameReferencesSinglePageAsync(domainId, top, skip, search, filter, count, orderby),
            nextLink -> listRefDomainNameReferencesNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<String> listRefDomainNameReferencesAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        Context context) {
        return new PagedFlux<>(
            () ->
                listRefDomainNameReferencesSinglePageAsync(
                    domainId, top, skip, search, filter, count, orderby, context),
            nextLink -> listRefDomainNameReferencesNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get ref of domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefDomainNameReferences(String domainId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DomainsOrderby> orderby = null;
        return new PagedIterable<>(
            listRefDomainNameReferencesAsync(domainId, top, skip, search, filter, count, orderby));
    }

    /**
     * Get ref of domainNameReferences from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of domainNameReferences from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefDomainNameReferences(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        Context context) {
        return new PagedIterable<>(
            listRefDomainNameReferencesAsync(domainId, top, skip, search, filter, count, orderby, context));
    }

    /**
     * Create new navigation property ref to domainNameReferences for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefDomainNameReferencesWithResponseAsync(
        String domainId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.createRefDomainNameReferences(this.client.getEndpoint(), domainId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property ref to domainNameReferences for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefDomainNameReferencesWithResponseAsync(
        String domainId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createRefDomainNameReferences(this.client.getEndpoint(), domainId, body, accept, context);
    }

    /**
     * Create new navigation property ref to domainNameReferences for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefDomainNameReferencesAsync(String domainId, Map<String, Object> body) {
        return createRefDomainNameReferencesWithResponseAsync(domainId, body)
            .flatMap(
                (Response<Map<String, Object>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property ref to domainNameReferences for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Map<String, Object> createRefDomainNameReferences(String domainId, Map<String, Object> body) {
        return createRefDomainNameReferencesAsync(domainId, body).block();
    }

    /**
     * Create new navigation property ref to domainNameReferences for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefDomainNameReferencesWithResponse(
        String domainId, Map<String, Object> body, Context context) {
        return createRefDomainNameReferencesWithResponseAsync(domainId, body, context).block();
    }

    /**
     * Invoke action forceDelete.
     *
     * @param domainId key: id of domain.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> forceDeleteWithResponseAsync(String domainId, DomainsForceDeleteRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.forceDelete(this.client.getEndpoint(), domainId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action forceDelete.
     *
     * @param domainId key: id of domain.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> forceDeleteWithResponseAsync(
        String domainId, DomainsForceDeleteRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.forceDelete(this.client.getEndpoint(), domainId, body, accept, context);
    }

    /**
     * Invoke action forceDelete.
     *
     * @param domainId key: id of domain.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> forceDeleteAsync(String domainId, DomainsForceDeleteRequestBody body) {
        return forceDeleteWithResponseAsync(domainId, body).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Invoke action forceDelete.
     *
     * @param domainId key: id of domain.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void forceDelete(String domainId, DomainsForceDeleteRequestBody body) {
        forceDeleteAsync(domainId, body).block();
    }

    /**
     * Invoke action forceDelete.
     *
     * @param domainId key: id of domain.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> forceDeleteWithResponse(
        String domainId, DomainsForceDeleteRequestBody body, Context context) {
        return forceDeleteWithResponseAsync(domainId, body, context).block();
    }

    /**
     * Invoke action verify.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domain.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDomainInner>> verifyWithResponseAsync(String domainId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.verify(this.client.getEndpoint(), domainId, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action verify.
     *
     * @param domainId key: id of domain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domain.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDomainInner>> verifyWithResponseAsync(String domainId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.verify(this.client.getEndpoint(), domainId, accept, context);
    }

    /**
     * Invoke action verify.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domain.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDomainInner> verifyAsync(String domainId) {
        return verifyWithResponseAsync(domainId)
            .flatMap(
                (Response<MicrosoftGraphDomainInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action verify.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domain.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDomainInner verify(String domainId) {
        return verifyAsync(domainId).block();
    }

    /**
     * Invoke action verify.
     *
     * @param domainId key: id of domain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domain.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDomainInner> verifyWithResponse(String domainId, Context context) {
        return verifyWithResponseAsync(domainId, context).block();
    }

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDomainDnsRecordInner>> listServiceConfigurationRecordsSinglePageAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listServiceConfigurationRecords(
                            this.client.getEndpoint(),
                            domainId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphDomainDnsRecordInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDomainDnsRecordInner>> listServiceConfigurationRecordsSinglePageAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listServiceConfigurationRecords(
                this.client.getEndpoint(),
                domainId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDomainDnsRecordInner> listServiceConfigurationRecordsAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () ->
                listServiceConfigurationRecordsSinglePageAsync(
                    domainId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listServiceConfigurationRecordsNextSinglePageAsync(nextLink));
    }

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDomainDnsRecordInner> listServiceConfigurationRecordsAsync(String domainId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DomainsOrderby> orderby = null;
        final List<DomainsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () ->
                listServiceConfigurationRecordsSinglePageAsync(
                    domainId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listServiceConfigurationRecordsNextSinglePageAsync(nextLink));
    }

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDomainDnsRecordInner> listServiceConfigurationRecordsAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listServiceConfigurationRecordsSinglePageAsync(
                    domainId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listServiceConfigurationRecordsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDomainDnsRecordInner> listServiceConfigurationRecords(String domainId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DomainsOrderby> orderby = null;
        final List<DomainsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listServiceConfigurationRecordsAsync(domainId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDomainDnsRecordInner> listServiceConfigurationRecords(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listServiceConfigurationRecordsAsync(
                domainId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Create new navigation property to serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDomainDnsRecordInner>> createServiceConfigurationRecordsWithResponseAsync(
        String domainId, MicrosoftGraphDomainDnsRecordInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createServiceConfigurationRecords(this.client.getEndpoint(), domainId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property to serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDomainDnsRecordInner>> createServiceConfigurationRecordsWithResponseAsync(
        String domainId, MicrosoftGraphDomainDnsRecordInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createServiceConfigurationRecords(this.client.getEndpoint(), domainId, body, accept, context);
    }

    /**
     * Create new navigation property to serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDomainDnsRecordInner> createServiceConfigurationRecordsAsync(
        String domainId, MicrosoftGraphDomainDnsRecordInner body) {
        return createServiceConfigurationRecordsWithResponseAsync(domainId, body)
            .flatMap(
                (Response<MicrosoftGraphDomainDnsRecordInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property to serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDomainDnsRecordInner createServiceConfigurationRecords(
        String domainId, MicrosoftGraphDomainDnsRecordInner body) {
        return createServiceConfigurationRecordsAsync(domainId, body).block();
    }

    /**
     * Create new navigation property to serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDomainDnsRecordInner> createServiceConfigurationRecordsWithResponse(
        String domainId, MicrosoftGraphDomainDnsRecordInner body, Context context) {
        return createServiceConfigurationRecordsWithResponseAsync(domainId, body, context).block();
    }

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDomainDnsRecordInner>> getServiceConfigurationRecordsWithResponseAsync(
        String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getServiceConfigurationRecords(
                            this.client.getEndpoint(),
                            domainId,
                            domainDnsRecordId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDomainDnsRecordInner>> getServiceConfigurationRecordsWithResponseAsync(
        String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getServiceConfigurationRecords(
                this.client.getEndpoint(),
                domainId,
                domainDnsRecordId,
                selectConverted,
                expandConverted,
                accept,
                context);
    }

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDomainDnsRecordInner> getServiceConfigurationRecordsAsync(
        String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand) {
        return getServiceConfigurationRecordsWithResponseAsync(domainId, domainDnsRecordId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphDomainDnsRecordInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDomainDnsRecordInner> getServiceConfigurationRecordsAsync(
        String domainId, String domainDnsRecordId) {
        final List<DomainsSelect> select = null;
        final List<String> expand = null;
        return getServiceConfigurationRecordsWithResponseAsync(domainId, domainDnsRecordId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphDomainDnsRecordInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDomainDnsRecordInner getServiceConfigurationRecords(
        String domainId, String domainDnsRecordId) {
        final List<DomainsSelect> select = null;
        final List<String> expand = null;
        return getServiceConfigurationRecordsAsync(domainId, domainDnsRecordId, select, expand).block();
    }

    /**
     * Get serviceConfigurationRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return serviceConfigurationRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDomainDnsRecordInner> getServiceConfigurationRecordsWithResponse(
        String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand, Context context) {
        return getServiceConfigurationRecordsWithResponseAsync(domainId, domainDnsRecordId, select, expand, context)
            .block();
    }

    /**
     * Update the navigation property serviceConfigurationRecords in domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateServiceConfigurationRecordsWithResponseAsync(
        String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateServiceConfigurationRecords(
                            this.client.getEndpoint(), domainId, domainDnsRecordId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the navigation property serviceConfigurationRecords in domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateServiceConfigurationRecordsWithResponseAsync(
        String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .updateServiceConfigurationRecords(
                this.client.getEndpoint(), domainId, domainDnsRecordId, body, accept, context);
    }

    /**
     * Update the navigation property serviceConfigurationRecords in domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateServiceConfigurationRecordsAsync(
        String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body) {
        return updateServiceConfigurationRecordsWithResponseAsync(domainId, domainDnsRecordId, body)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the navigation property serviceConfigurationRecords in domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateServiceConfigurationRecords(
        String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body) {
        updateServiceConfigurationRecordsAsync(domainId, domainDnsRecordId, body).block();
    }

    /**
     * Update the navigation property serviceConfigurationRecords in domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateServiceConfigurationRecordsWithResponse(
        String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body, Context context) {
        return updateServiceConfigurationRecordsWithResponseAsync(domainId, domainDnsRecordId, body, context).block();
    }

    /**
     * Delete navigation property serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteServiceConfigurationRecordsWithResponseAsync(
        String domainId, String domainDnsRecordId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteServiceConfigurationRecords(
                            this.client.getEndpoint(), domainId, domainDnsRecordId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete navigation property serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteServiceConfigurationRecordsWithResponseAsync(
        String domainId, String domainDnsRecordId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .deleteServiceConfigurationRecords(
                this.client.getEndpoint(), domainId, domainDnsRecordId, ifMatch, accept, context);
    }

    /**
     * Delete navigation property serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteServiceConfigurationRecordsAsync(
        String domainId, String domainDnsRecordId, String ifMatch) {
        return deleteServiceConfigurationRecordsWithResponseAsync(domainId, domainDnsRecordId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteServiceConfigurationRecordsAsync(String domainId, String domainDnsRecordId) {
        final String ifMatch = null;
        return deleteServiceConfigurationRecordsWithResponseAsync(domainId, domainDnsRecordId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteServiceConfigurationRecords(String domainId, String domainDnsRecordId) {
        final String ifMatch = null;
        deleteServiceConfigurationRecordsAsync(domainId, domainDnsRecordId, ifMatch).block();
    }

    /**
     * Delete navigation property serviceConfigurationRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteServiceConfigurationRecordsWithResponse(
        String domainId, String domainDnsRecordId, String ifMatch, Context context) {
        return deleteServiceConfigurationRecordsWithResponseAsync(domainId, domainDnsRecordId, ifMatch, context)
            .block();
    }

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDomainDnsRecordInner>> listVerificationDnsRecordsSinglePageAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listVerificationDnsRecords(
                            this.client.getEndpoint(),
                            domainId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphDomainDnsRecordInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDomainDnsRecordInner>> listVerificationDnsRecordsSinglePageAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listVerificationDnsRecords(
                this.client.getEndpoint(),
                domainId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDomainDnsRecordInner> listVerificationDnsRecordsAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () ->
                listVerificationDnsRecordsSinglePageAsync(
                    domainId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listVerificationDnsRecordsNextSinglePageAsync(nextLink));
    }

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDomainDnsRecordInner> listVerificationDnsRecordsAsync(String domainId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DomainsOrderby> orderby = null;
        final List<DomainsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () ->
                listVerificationDnsRecordsSinglePageAsync(
                    domainId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listVerificationDnsRecordsNextSinglePageAsync(nextLink));
    }

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDomainDnsRecordInner> listVerificationDnsRecordsAsync(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listVerificationDnsRecordsSinglePageAsync(
                    domainId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listVerificationDnsRecordsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDomainDnsRecordInner> listVerificationDnsRecords(String domainId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<DomainsOrderby> orderby = null;
        final List<DomainsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listVerificationDnsRecordsAsync(domainId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDomainDnsRecordInner> listVerificationDnsRecords(
        String domainId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DomainsOrderby> orderby,
        List<DomainsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listVerificationDnsRecordsAsync(
                domainId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Create new navigation property to verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDomainDnsRecordInner>> createVerificationDnsRecordsWithResponseAsync(
        String domainId, MicrosoftGraphDomainDnsRecordInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.createVerificationDnsRecords(this.client.getEndpoint(), domainId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property to verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDomainDnsRecordInner>> createVerificationDnsRecordsWithResponseAsync(
        String domainId, MicrosoftGraphDomainDnsRecordInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createVerificationDnsRecords(this.client.getEndpoint(), domainId, body, accept, context);
    }

    /**
     * Create new navigation property to verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDomainDnsRecordInner> createVerificationDnsRecordsAsync(
        String domainId, MicrosoftGraphDomainDnsRecordInner body) {
        return createVerificationDnsRecordsWithResponseAsync(domainId, body)
            .flatMap(
                (Response<MicrosoftGraphDomainDnsRecordInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property to verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDomainDnsRecordInner createVerificationDnsRecords(
        String domainId, MicrosoftGraphDomainDnsRecordInner body) {
        return createVerificationDnsRecordsAsync(domainId, body).block();
    }

    /**
     * Create new navigation property to verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDomainDnsRecordInner> createVerificationDnsRecordsWithResponse(
        String domainId, MicrosoftGraphDomainDnsRecordInner body, Context context) {
        return createVerificationDnsRecordsWithResponseAsync(domainId, body, context).block();
    }

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDomainDnsRecordInner>> getVerificationDnsRecordsWithResponseAsync(
        String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getVerificationDnsRecords(
                            this.client.getEndpoint(),
                            domainId,
                            domainDnsRecordId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDomainDnsRecordInner>> getVerificationDnsRecordsWithResponseAsync(
        String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getVerificationDnsRecords(
                this.client.getEndpoint(),
                domainId,
                domainDnsRecordId,
                selectConverted,
                expandConverted,
                accept,
                context);
    }

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDomainDnsRecordInner> getVerificationDnsRecordsAsync(
        String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand) {
        return getVerificationDnsRecordsWithResponseAsync(domainId, domainDnsRecordId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphDomainDnsRecordInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDomainDnsRecordInner> getVerificationDnsRecordsAsync(
        String domainId, String domainDnsRecordId) {
        final List<DomainsSelect> select = null;
        final List<String> expand = null;
        return getVerificationDnsRecordsWithResponseAsync(domainId, domainDnsRecordId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphDomainDnsRecordInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDomainDnsRecordInner getVerificationDnsRecords(String domainId, String domainDnsRecordId) {
        final List<DomainsSelect> select = null;
        final List<String> expand = null;
        return getVerificationDnsRecordsAsync(domainId, domainDnsRecordId, select, expand).block();
    }

    /**
     * Get verificationDnsRecords from domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return verificationDnsRecords from domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDomainDnsRecordInner> getVerificationDnsRecordsWithResponse(
        String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand, Context context) {
        return getVerificationDnsRecordsWithResponseAsync(domainId, domainDnsRecordId, select, expand, context).block();
    }

    /**
     * Update the navigation property verificationDnsRecords in domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateVerificationDnsRecordsWithResponseAsync(
        String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateVerificationDnsRecords(
                            this.client.getEndpoint(), domainId, domainDnsRecordId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the navigation property verificationDnsRecords in domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateVerificationDnsRecordsWithResponseAsync(
        String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .updateVerificationDnsRecords(
                this.client.getEndpoint(), domainId, domainDnsRecordId, body, accept, context);
    }

    /**
     * Update the navigation property verificationDnsRecords in domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateVerificationDnsRecordsAsync(
        String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body) {
        return updateVerificationDnsRecordsWithResponseAsync(domainId, domainDnsRecordId, body)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the navigation property verificationDnsRecords in domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateVerificationDnsRecords(
        String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body) {
        updateVerificationDnsRecordsAsync(domainId, domainDnsRecordId, body).block();
    }

    /**
     * Update the navigation property verificationDnsRecords in domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateVerificationDnsRecordsWithResponse(
        String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body, Context context) {
        return updateVerificationDnsRecordsWithResponseAsync(domainId, domainDnsRecordId, body, context).block();
    }

    /**
     * Delete navigation property verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteVerificationDnsRecordsWithResponseAsync(
        String domainId, String domainDnsRecordId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteVerificationDnsRecords(
                            this.client.getEndpoint(), domainId, domainDnsRecordId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete navigation property verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteVerificationDnsRecordsWithResponseAsync(
        String domainId, String domainDnsRecordId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .deleteVerificationDnsRecords(
                this.client.getEndpoint(), domainId, domainDnsRecordId, ifMatch, accept, context);
    }

    /**
     * Delete navigation property verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteVerificationDnsRecordsAsync(String domainId, String domainDnsRecordId, String ifMatch) {
        return deleteVerificationDnsRecordsWithResponseAsync(domainId, domainDnsRecordId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteVerificationDnsRecordsAsync(String domainId, String domainDnsRecordId) {
        final String ifMatch = null;
        return deleteVerificationDnsRecordsWithResponseAsync(domainId, domainDnsRecordId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteVerificationDnsRecords(String domainId, String domainDnsRecordId) {
        final String ifMatch = null;
        deleteVerificationDnsRecordsAsync(domainId, domainDnsRecordId, ifMatch).block();
    }

    /**
     * Delete navigation property verificationDnsRecords for domains.
     *
     * @param domainId key: id of domain.
     * @param domainDnsRecordId key: id of domainDnsRecord.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteVerificationDnsRecordsWithResponse(
        String domainId, String domainDnsRecordId, String ifMatch, Context context) {
        return deleteVerificationDnsRecordsWithResponseAsync(domainId, domainDnsRecordId, ifMatch, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listMore(nextLink, context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMoreSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listMore(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefDomainNameReferencesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listRefDomainNameReferencesNext(nextLink, context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefDomainNameReferencesNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listRefDomainNameReferencesNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDomainDnsRecordInner>> listServiceConfigurationRecordsNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listServiceConfigurationRecordsNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphDomainDnsRecordInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDomainDnsRecordInner>> listServiceConfigurationRecordsNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listServiceConfigurationRecordsNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDomainDnsRecordInner>> listVerificationDnsRecordsNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listVerificationDnsRecordsNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphDomainDnsRecordInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of domainDnsRecord.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDomainDnsRecordInner>> listVerificationDnsRecordsNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listVerificationDnsRecordsNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }
}
