// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.resourcemanager.authorization.fluent.OrganizationOrganizationsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfOrganization;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOrganizationInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.fluent.models.OrganizationOrganizationExpand;
import com.azure.resourcemanager.authorization.fluent.models.OrganizationOrganizationOrderby;
import com.azure.resourcemanager.authorization.fluent.models.OrganizationOrganizationSelect;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in OrganizationOrganizationsClient. */
public final class OrganizationOrganizationsClientImpl implements OrganizationOrganizationsClient {
    private final ClientLogger logger = new ClientLogger(OrganizationOrganizationsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final OrganizationOrganizationsService service;

    /** The service client containing this operation class. */
    private final MicrosoftGraphClientImpl client;

    /**
     * Initializes an instance of OrganizationOrganizationsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    OrganizationOrganizationsClientImpl(MicrosoftGraphClientImpl client) {
        this.service =
            RestProxy
                .create(
                    OrganizationOrganizationsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MicrosoftGraphClientOrganizationOrganizations to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MicrosoftGraphClient")
    private interface OrganizationOrganizationsService {
        @Headers({"Content-Type: application/json"})
        @Get("/organization")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfOrganization>> listOrganization(
            @HostParam("$host") String endpoint,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/organization")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphOrganizationInner>> createOrganization(
            @HostParam("$host") String endpoint,
            @BodyParam("application/json") MicrosoftGraphOrganizationInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/organization/{organization-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphOrganizationInner>> getOrganization(
            @HostParam("$host") String endpoint,
            @PathParam("organization-id") String organizationId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/organization/{organization-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateOrganization(
            @HostParam("$host") String endpoint,
            @PathParam("organization-id") String organizationId,
            @BodyParam("application/json") MicrosoftGraphOrganizationInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/organization/{organization-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteOrganization(
            @HostParam("$host") String endpoint,
            @PathParam("organization-id") String organizationId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfOrganization>> listMore(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Get entities from organization.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from organization.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOrganizationInner>> listOrganizationSinglePageAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<OrganizationOrganizationOrderby> orderby,
        List<OrganizationOrganizationSelect> select,
        List<OrganizationOrganizationExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listOrganization(
                            this.client.getEndpoint(),
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphOrganizationInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get entities from organization.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from organization.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOrganizationInner>> listOrganizationSinglePageAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<OrganizationOrganizationOrderby> orderby,
        List<OrganizationOrganizationSelect> select,
        List<OrganizationOrganizationExpand> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listOrganization(
                this.client.getEndpoint(),
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get entities from organization.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from organization.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphOrganizationInner> listOrganizationAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<OrganizationOrganizationOrderby> orderby,
        List<OrganizationOrganizationSelect> select,
        List<OrganizationOrganizationExpand> expand) {
        return new PagedFlux<>(
            () -> listOrganizationSinglePageAsync(top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get entities from organization.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from organization.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphOrganizationInner> listOrganizationAsync() {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<OrganizationOrganizationOrderby> orderby = null;
        final List<OrganizationOrganizationSelect> select = null;
        final List<OrganizationOrganizationExpand> expand = null;
        return new PagedFlux<>(
            () -> listOrganizationSinglePageAsync(top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get entities from organization.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from organization.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphOrganizationInner> listOrganizationAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<OrganizationOrganizationOrderby> orderby,
        List<OrganizationOrganizationSelect> select,
        List<OrganizationOrganizationExpand> expand,
        Context context) {
        return new PagedFlux<>(
            () -> listOrganizationSinglePageAsync(top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listMoreSinglePageAsync(nextLink, context));
    }

    /**
     * Get entities from organization.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from organization.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphOrganizationInner> listOrganization() {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<OrganizationOrganizationOrderby> orderby = null;
        final List<OrganizationOrganizationSelect> select = null;
        final List<OrganizationOrganizationExpand> expand = null;
        return new PagedIterable<>(listOrganizationAsync(top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get entities from organization.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from organization.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphOrganizationInner> listOrganization(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<OrganizationOrganizationOrderby> orderby,
        List<OrganizationOrganizationSelect> select,
        List<OrganizationOrganizationExpand> expand,
        Context context) {
        return new PagedIterable<>(
            listOrganizationAsync(top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Add new entity to organization.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the organization resource represents an instance of global settings and resources which operate and are
     *     provisioned at the tenant-level.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphOrganizationInner>> createOrganizationWithResponseAsync(
        MicrosoftGraphOrganizationInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrganization(this.client.getEndpoint(), body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Add new entity to organization.
     *
     * @param body New entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the organization resource represents an instance of global settings and resources which operate and are
     *     provisioned at the tenant-level.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphOrganizationInner>> createOrganizationWithResponseAsync(
        MicrosoftGraphOrganizationInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrganization(this.client.getEndpoint(), body, accept, context);
    }

    /**
     * Add new entity to organization.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the organization resource represents an instance of global settings and resources which operate and are
     *     provisioned at the tenant-level.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphOrganizationInner> createOrganizationAsync(MicrosoftGraphOrganizationInner body) {
        return createOrganizationWithResponseAsync(body)
            .flatMap(
                (Response<MicrosoftGraphOrganizationInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Add new entity to organization.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the organization resource represents an instance of global settings and resources which operate and are
     *     provisioned at the tenant-level.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphOrganizationInner createOrganization(MicrosoftGraphOrganizationInner body) {
        return createOrganizationAsync(body).block();
    }

    /**
     * Add new entity to organization.
     *
     * @param body New entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the organization resource represents an instance of global settings and resources which operate and are
     *     provisioned at the tenant-level.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphOrganizationInner> createOrganizationWithResponse(
        MicrosoftGraphOrganizationInner body, Context context) {
        return createOrganizationWithResponseAsync(body, context).block();
    }

    /**
     * Get entity from organization by key.
     *
     * @param organizationId key: id of organization.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from organization by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphOrganizationInner>> getOrganizationWithResponseAsync(
        String organizationId,
        List<OrganizationOrganizationSelect> select,
        List<OrganizationOrganizationExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (organizationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter organizationId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getOrganization(
                            this.client.getEndpoint(),
                            organizationId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get entity from organization by key.
     *
     * @param organizationId key: id of organization.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from organization by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphOrganizationInner>> getOrganizationWithResponseAsync(
        String organizationId,
        List<OrganizationOrganizationSelect> select,
        List<OrganizationOrganizationExpand> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (organizationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter organizationId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getOrganization(
                this.client.getEndpoint(), organizationId, selectConverted, expandConverted, accept, context);
    }

    /**
     * Get entity from organization by key.
     *
     * @param organizationId key: id of organization.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from organization by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphOrganizationInner> getOrganizationAsync(
        String organizationId,
        List<OrganizationOrganizationSelect> select,
        List<OrganizationOrganizationExpand> expand) {
        return getOrganizationWithResponseAsync(organizationId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphOrganizationInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get entity from organization by key.
     *
     * @param organizationId key: id of organization.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from organization by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphOrganizationInner> getOrganizationAsync(String organizationId) {
        final List<OrganizationOrganizationSelect> select = null;
        final List<OrganizationOrganizationExpand> expand = null;
        return getOrganizationWithResponseAsync(organizationId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphOrganizationInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get entity from organization by key.
     *
     * @param organizationId key: id of organization.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from organization by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphOrganizationInner getOrganization(String organizationId) {
        final List<OrganizationOrganizationSelect> select = null;
        final List<OrganizationOrganizationExpand> expand = null;
        return getOrganizationAsync(organizationId, select, expand).block();
    }

    /**
     * Get entity from organization by key.
     *
     * @param organizationId key: id of organization.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from organization by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphOrganizationInner> getOrganizationWithResponse(
        String organizationId,
        List<OrganizationOrganizationSelect> select,
        List<OrganizationOrganizationExpand> expand,
        Context context) {
        return getOrganizationWithResponseAsync(organizationId, select, expand, context).block();
    }

    /**
     * Update entity in organization.
     *
     * @param organizationId key: id of organization.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateOrganizationWithResponseAsync(
        String organizationId, MicrosoftGraphOrganizationInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (organizationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter organizationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.updateOrganization(this.client.getEndpoint(), organizationId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update entity in organization.
     *
     * @param organizationId key: id of organization.
     * @param body New property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateOrganizationWithResponseAsync(
        String organizationId, MicrosoftGraphOrganizationInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (organizationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter organizationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateOrganization(this.client.getEndpoint(), organizationId, body, accept, context);
    }

    /**
     * Update entity in organization.
     *
     * @param organizationId key: id of organization.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateOrganizationAsync(String organizationId, MicrosoftGraphOrganizationInner body) {
        return updateOrganizationWithResponseAsync(organizationId, body).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update entity in organization.
     *
     * @param organizationId key: id of organization.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateOrganization(String organizationId, MicrosoftGraphOrganizationInner body) {
        updateOrganizationAsync(organizationId, body).block();
    }

    /**
     * Update entity in organization.
     *
     * @param organizationId key: id of organization.
     * @param body New property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateOrganizationWithResponse(
        String organizationId, MicrosoftGraphOrganizationInner body, Context context) {
        return updateOrganizationWithResponseAsync(organizationId, body, context).block();
    }

    /**
     * Delete entity from organization.
     *
     * @param organizationId key: id of organization.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteOrganizationWithResponseAsync(String organizationId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (organizationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter organizationId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.deleteOrganization(this.client.getEndpoint(), organizationId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete entity from organization.
     *
     * @param organizationId key: id of organization.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteOrganizationWithResponseAsync(
        String organizationId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (organizationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter organizationId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteOrganization(this.client.getEndpoint(), organizationId, ifMatch, accept, context);
    }

    /**
     * Delete entity from organization.
     *
     * @param organizationId key: id of organization.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteOrganizationAsync(String organizationId, String ifMatch) {
        return deleteOrganizationWithResponseAsync(organizationId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete entity from organization.
     *
     * @param organizationId key: id of organization.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteOrganizationAsync(String organizationId) {
        final String ifMatch = null;
        return deleteOrganizationWithResponseAsync(organizationId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete entity from organization.
     *
     * @param organizationId key: id of organization.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteOrganization(String organizationId) {
        final String ifMatch = null;
        deleteOrganizationAsync(organizationId, ifMatch).block();
    }

    /**
     * Delete entity from organization.
     *
     * @param organizationId key: id of organization.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteOrganizationWithResponse(String organizationId, String ifMatch, Context context) {
        return deleteOrganizationWithResponseAsync(organizationId, ifMatch, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of organization.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOrganizationInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listMore(nextLink, context))
            .<PagedResponse<MicrosoftGraphOrganizationInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of organization.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOrganizationInner>> listMoreSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listMore(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }
}
