// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.resourcemanager.authorization.fluent.UsersTodoListsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfExtension0;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfTodoTask;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTodoTaskInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.fluent.models.UsersTodoListsExpand;
import com.azure.resourcemanager.authorization.fluent.models.UsersTodoListsOrderby;
import com.azure.resourcemanager.authorization.fluent.models.UsersTodoListsSelect;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in UsersTodoListsClient. */
public final class UsersTodoListsClientImpl implements UsersTodoListsClient {
    private final ClientLogger logger = new ClientLogger(UsersTodoListsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final UsersTodoListsService service;

    /** The service client containing this operation class. */
    private final MicrosoftGraphClientImpl client;

    /**
     * Initializes an instance of UsersTodoListsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    UsersTodoListsClientImpl(MicrosoftGraphClientImpl client) {
        this.service =
            RestProxy.create(UsersTodoListsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MicrosoftGraphClientUsersTodoLists to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MicrosoftGraphClient")
    private interface UsersTodoListsService {
        @Headers({"Content-Type: application/json"})
        @Get("/users/{user-id}/todo/lists/{todoTaskList-id}/extensions")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfExtension0>> listExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/users/{user-id}/todo/lists/{todoTaskList-id}/extensions")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphExtensionInner>> createExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @BodyParam("application/json") MicrosoftGraphExtensionInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/users/{user-id}/todo/lists/{todoTaskList-id}/extensions/{extension-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphExtensionInner>> getExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @PathParam("extension-id") String extensionId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/users/{user-id}/todo/lists/{todoTaskList-id}/extensions/{extension-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @PathParam("extension-id") String extensionId,
            @BodyParam("application/json") MicrosoftGraphExtensionInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/users/{user-id}/todo/lists/{todoTaskList-id}/extensions/{extension-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteExtensions(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @PathParam("extension-id") String extensionId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/users/{user-id}/todo/lists/{todoTaskList-id}/tasks")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfTodoTask>> listTasks(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/users/{user-id}/todo/lists/{todoTaskList-id}/tasks")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphTodoTaskInner>> createTasks(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @BodyParam("application/json") MicrosoftGraphTodoTaskInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphTodoTaskInner>> getTasks(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @PathParam("todoTask-id") String todoTaskId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateTasks(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @PathParam("todoTask-id") String todoTaskId,
            @BodyParam("application/json") MicrosoftGraphTodoTaskInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteTasks(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @PathParam("todoTaskList-id") String todoTaskListId,
            @PathParam("todoTask-id") String todoTaskId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfExtension0>> listMore(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfTodoTask>> listTasksNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(
        String userId,
        String todoTaskListId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsOrderby> orderby,
        List<String> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listExtensions(
                            this.client.getEndpoint(),
                            userId,
                            todoTaskListId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphExtensionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(
        String userId,
        String todoTaskListId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsOrderby> orderby,
        List<String> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listExtensions(
                this.client.getEndpoint(),
                userId,
                todoTaskListId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(
        String userId,
        String todoTaskListId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsOrderby> orderby,
        List<String> select,
        List<String> expand) {
        return new PagedFlux<>(
            () ->
                listExtensionsSinglePageAsync(
                    userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String userId, String todoTaskListId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<UsersTodoListsOrderby> orderby = null;
        final List<String> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () ->
                listExtensionsSinglePageAsync(
                    userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(
        String userId,
        String todoTaskListId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsOrderby> orderby,
        List<String> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listExtensionsSinglePageAsync(
                    userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listMoreSinglePageAsync(nextLink, context));
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(String userId, String todoTaskListId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<UsersTodoListsOrderby> orderby = null;
        final List<String> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listExtensionsAsync(userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(
        String userId,
        String todoTaskListId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsOrderby> orderby,
        List<String> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listExtensionsAsync(
                userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Create new navigation property to extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(
        String userId, String todoTaskListId, MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.createExtensions(this.client.getEndpoint(), userId, todoTaskListId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property to extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(
        String userId, String todoTaskListId, MicrosoftGraphExtensionInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createExtensions(this.client.getEndpoint(), userId, todoTaskListId, body, accept, context);
    }

    /**
     * Create new navigation property to extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionInner> createExtensionsAsync(
        String userId, String todoTaskListId, MicrosoftGraphExtensionInner body) {
        return createExtensionsWithResponseAsync(userId, todoTaskListId, body)
            .flatMap(
                (Response<MicrosoftGraphExtensionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property to extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphExtensionInner createExtensions(
        String userId, String todoTaskListId, MicrosoftGraphExtensionInner body) {
        return createExtensionsAsync(userId, todoTaskListId, body).block();
    }

    /**
     * Create new navigation property to extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphExtensionInner> createExtensionsWithResponse(
        String userId, String todoTaskListId, MicrosoftGraphExtensionInner body, Context context) {
        return createExtensionsWithResponseAsync(userId, todoTaskListId, body, context).block();
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(
        String userId, String todoTaskListId, String extensionId, List<String> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getExtensions(
                            this.client.getEndpoint(),
                            userId,
                            todoTaskListId,
                            extensionId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(
        String userId,
        String todoTaskListId,
        String extensionId,
        List<String> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getExtensions(
                this.client.getEndpoint(),
                userId,
                todoTaskListId,
                extensionId,
                selectConverted,
                expandConverted,
                accept,
                context);
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(
        String userId, String todoTaskListId, String extensionId, List<String> select, List<String> expand) {
        return getExtensionsWithResponseAsync(userId, todoTaskListId, extensionId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphExtensionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(
        String userId, String todoTaskListId, String extensionId) {
        final List<String> select = null;
        final List<String> expand = null;
        return getExtensionsWithResponseAsync(userId, todoTaskListId, extensionId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphExtensionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphExtensionInner getExtensions(String userId, String todoTaskListId, String extensionId) {
        final List<String> select = null;
        final List<String> expand = null;
        return getExtensionsAsync(userId, todoTaskListId, extensionId, select, expand).block();
    }

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphExtensionInner> getExtensionsWithResponse(
        String userId,
        String todoTaskListId,
        String extensionId,
        List<String> select,
        List<String> expand,
        Context context) {
        return getExtensionsWithResponseAsync(userId, todoTaskListId, extensionId, select, expand, context).block();
    }

    /**
     * Update the navigation property extensions in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateExtensionsWithResponseAsync(
        String userId, String todoTaskListId, String extensionId, MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateExtensions(
                            this.client.getEndpoint(), userId, todoTaskListId, extensionId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the navigation property extensions in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateExtensionsWithResponseAsync(
        String userId, String todoTaskListId, String extensionId, MicrosoftGraphExtensionInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .updateExtensions(this.client.getEndpoint(), userId, todoTaskListId, extensionId, body, accept, context);
    }

    /**
     * Update the navigation property extensions in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateExtensionsAsync(
        String userId, String todoTaskListId, String extensionId, MicrosoftGraphExtensionInner body) {
        return updateExtensionsWithResponseAsync(userId, todoTaskListId, extensionId, body)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the navigation property extensions in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateExtensions(
        String userId, String todoTaskListId, String extensionId, MicrosoftGraphExtensionInner body) {
        updateExtensionsAsync(userId, todoTaskListId, extensionId, body).block();
    }

    /**
     * Update the navigation property extensions in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateExtensionsWithResponse(
        String userId, String todoTaskListId, String extensionId, MicrosoftGraphExtensionInner body, Context context) {
        return updateExtensionsWithResponseAsync(userId, todoTaskListId, extensionId, body, context).block();
    }

    /**
     * Delete navigation property extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteExtensionsWithResponseAsync(
        String userId, String todoTaskListId, String extensionId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteExtensions(
                            this.client.getEndpoint(), userId, todoTaskListId, extensionId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete navigation property extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteExtensionsWithResponseAsync(
        String userId, String todoTaskListId, String extensionId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .deleteExtensions(this.client.getEndpoint(), userId, todoTaskListId, extensionId, ifMatch, accept, context);
    }

    /**
     * Delete navigation property extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteExtensionsAsync(String userId, String todoTaskListId, String extensionId, String ifMatch) {
        return deleteExtensionsWithResponseAsync(userId, todoTaskListId, extensionId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteExtensionsAsync(String userId, String todoTaskListId, String extensionId) {
        final String ifMatch = null;
        return deleteExtensionsWithResponseAsync(userId, todoTaskListId, extensionId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteExtensions(String userId, String todoTaskListId, String extensionId) {
        final String ifMatch = null;
        deleteExtensionsAsync(userId, todoTaskListId, extensionId, ifMatch).block();
    }

    /**
     * Delete navigation property extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteExtensionsWithResponse(
        String userId, String todoTaskListId, String extensionId, String ifMatch, Context context) {
        return deleteExtensionsWithResponseAsync(userId, todoTaskListId, extensionId, ifMatch, context).block();
    }

    /**
     * Get tasks from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tasks from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphTodoTaskInner>> listTasksSinglePageAsync(
        String userId,
        String todoTaskListId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsOrderby> orderby,
        List<UsersTodoListsSelect> select,
        List<UsersTodoListsExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listTasks(
                            this.client.getEndpoint(),
                            userId,
                            todoTaskListId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphTodoTaskInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get tasks from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tasks from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphTodoTaskInner>> listTasksSinglePageAsync(
        String userId,
        String todoTaskListId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsOrderby> orderby,
        List<UsersTodoListsSelect> select,
        List<UsersTodoListsExpand> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listTasks(
                this.client.getEndpoint(),
                userId,
                todoTaskListId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get tasks from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tasks from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphTodoTaskInner> listTasksAsync(
        String userId,
        String todoTaskListId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsOrderby> orderby,
        List<UsersTodoListsSelect> select,
        List<UsersTodoListsExpand> expand) {
        return new PagedFlux<>(
            () ->
                listTasksSinglePageAsync(
                    userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listTasksNextSinglePageAsync(nextLink));
    }

    /**
     * Get tasks from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tasks from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphTodoTaskInner> listTasksAsync(String userId, String todoTaskListId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<UsersTodoListsOrderby> orderby = null;
        final List<UsersTodoListsSelect> select = null;
        final List<UsersTodoListsExpand> expand = null;
        return new PagedFlux<>(
            () ->
                listTasksSinglePageAsync(
                    userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listTasksNextSinglePageAsync(nextLink));
    }

    /**
     * Get tasks from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tasks from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphTodoTaskInner> listTasksAsync(
        String userId,
        String todoTaskListId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsOrderby> orderby,
        List<UsersTodoListsSelect> select,
        List<UsersTodoListsExpand> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listTasksSinglePageAsync(
                    userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listTasksNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get tasks from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tasks from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphTodoTaskInner> listTasks(String userId, String todoTaskListId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<UsersTodoListsOrderby> orderby = null;
        final List<UsersTodoListsSelect> select = null;
        final List<UsersTodoListsExpand> expand = null;
        return new PagedIterable<>(
            listTasksAsync(userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get tasks from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tasks from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphTodoTaskInner> listTasks(
        String userId,
        String todoTaskListId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsOrderby> orderby,
        List<UsersTodoListsSelect> select,
        List<UsersTodoListsExpand> expand,
        Context context) {
        return new PagedIterable<>(
            listTasksAsync(userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Create new navigation property to tasks for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return todoTask.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphTodoTaskInner>> createTasksWithResponseAsync(
        String userId, String todoTaskListId, MicrosoftGraphTodoTaskInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.createTasks(this.client.getEndpoint(), userId, todoTaskListId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property to tasks for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return todoTask.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphTodoTaskInner>> createTasksWithResponseAsync(
        String userId, String todoTaskListId, MicrosoftGraphTodoTaskInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createTasks(this.client.getEndpoint(), userId, todoTaskListId, body, accept, context);
    }

    /**
     * Create new navigation property to tasks for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return todoTask.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphTodoTaskInner> createTasksAsync(
        String userId, String todoTaskListId, MicrosoftGraphTodoTaskInner body) {
        return createTasksWithResponseAsync(userId, todoTaskListId, body)
            .flatMap(
                (Response<MicrosoftGraphTodoTaskInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property to tasks for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return todoTask.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphTodoTaskInner createTasks(
        String userId, String todoTaskListId, MicrosoftGraphTodoTaskInner body) {
        return createTasksAsync(userId, todoTaskListId, body).block();
    }

    /**
     * Create new navigation property to tasks for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return todoTask.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphTodoTaskInner> createTasksWithResponse(
        String userId, String todoTaskListId, MicrosoftGraphTodoTaskInner body, Context context) {
        return createTasksWithResponseAsync(userId, todoTaskListId, body, context).block();
    }

    /**
     * Get tasks from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tasks from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphTodoTaskInner>> getTasksWithResponseAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        List<UsersTodoListsSelect> select,
        List<UsersTodoListsExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getTasks(
                            this.client.getEndpoint(),
                            userId,
                            todoTaskListId,
                            todoTaskId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get tasks from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tasks from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphTodoTaskInner>> getTasksWithResponseAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        List<UsersTodoListsSelect> select,
        List<UsersTodoListsExpand> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getTasks(
                this.client.getEndpoint(),
                userId,
                todoTaskListId,
                todoTaskId,
                selectConverted,
                expandConverted,
                accept,
                context);
    }

    /**
     * Get tasks from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tasks from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphTodoTaskInner> getTasksAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        List<UsersTodoListsSelect> select,
        List<UsersTodoListsExpand> expand) {
        return getTasksWithResponseAsync(userId, todoTaskListId, todoTaskId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphTodoTaskInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get tasks from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tasks from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphTodoTaskInner> getTasksAsync(String userId, String todoTaskListId, String todoTaskId) {
        final List<UsersTodoListsSelect> select = null;
        final List<UsersTodoListsExpand> expand = null;
        return getTasksWithResponseAsync(userId, todoTaskListId, todoTaskId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphTodoTaskInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get tasks from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tasks from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphTodoTaskInner getTasks(String userId, String todoTaskListId, String todoTaskId) {
        final List<UsersTodoListsSelect> select = null;
        final List<UsersTodoListsExpand> expand = null;
        return getTasksAsync(userId, todoTaskListId, todoTaskId, select, expand).block();
    }

    /**
     * Get tasks from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tasks from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphTodoTaskInner> getTasksWithResponse(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        List<UsersTodoListsSelect> select,
        List<UsersTodoListsExpand> expand,
        Context context) {
        return getTasksWithResponseAsync(userId, todoTaskListId, todoTaskId, select, expand, context).block();
    }

    /**
     * Update the navigation property tasks in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateTasksWithResponseAsync(
        String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphTodoTaskInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateTasks(
                            this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the navigation property tasks in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateTasksWithResponseAsync(
        String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphTodoTaskInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .updateTasks(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, body, accept, context);
    }

    /**
     * Update the navigation property tasks in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateTasksAsync(
        String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphTodoTaskInner body) {
        return updateTasksWithResponseAsync(userId, todoTaskListId, todoTaskId, body)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the navigation property tasks in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateTasks(String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphTodoTaskInner body) {
        updateTasksAsync(userId, todoTaskListId, todoTaskId, body).block();
    }

    /**
     * Update the navigation property tasks in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateTasksWithResponse(
        String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphTodoTaskInner body, Context context) {
        return updateTasksWithResponseAsync(userId, todoTaskListId, todoTaskId, body, context).block();
    }

    /**
     * Delete navigation property tasks for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTasksWithResponseAsync(
        String userId, String todoTaskListId, String todoTaskId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteTasks(
                            this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete navigation property tasks for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteTasksWithResponseAsync(
        String userId, String todoTaskListId, String todoTaskId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error(new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .deleteTasks(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, ifMatch, accept, context);
    }

    /**
     * Delete navigation property tasks for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteTasksAsync(String userId, String todoTaskListId, String todoTaskId, String ifMatch) {
        return deleteTasksWithResponseAsync(userId, todoTaskListId, todoTaskId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property tasks for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteTasksAsync(String userId, String todoTaskListId, String todoTaskId) {
        final String ifMatch = null;
        return deleteTasksWithResponseAsync(userId, todoTaskListId, todoTaskId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property tasks for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteTasks(String userId, String todoTaskListId, String todoTaskId) {
        final String ifMatch = null;
        deleteTasksAsync(userId, todoTaskListId, todoTaskId, ifMatch).block();
    }

    /**
     * Delete navigation property tasks for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteTasksWithResponse(
        String userId, String todoTaskListId, String todoTaskId, String ifMatch, Context context) {
        return deleteTasksWithResponseAsync(userId, todoTaskListId, todoTaskId, ifMatch, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listMore(nextLink, context))
            .<PagedResponse<MicrosoftGraphExtensionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listMoreSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listMore(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of todoTask.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphTodoTaskInner>> listTasksNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listTasksNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphTodoTaskInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of todoTask.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphTodoTaskInner>> listTasksNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listTasksNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }
}
