// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * lobbyBypassSettings.
 */
@Fluent
public final class MicrosoftGraphLobbyBypassSettings implements JsonSerializable<MicrosoftGraphLobbyBypassSettings> {
    /*
     * Specifies whether or not to always let dial-in callers bypass the lobby. Optional.
     */
    private Boolean isDialInBypassEnabled;

    /*
     * lobbyBypassScope
     */
    private MicrosoftGraphLobbyBypassScope scope;

    /*
     * lobbyBypassSettings
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphLobbyBypassSettings class.
     */
    public MicrosoftGraphLobbyBypassSettings() {
    }

    /**
     * Get the isDialInBypassEnabled property: Specifies whether or not to always let dial-in callers bypass the lobby.
     * Optional.
     * 
     * @return the isDialInBypassEnabled value.
     */
    public Boolean isDialInBypassEnabled() {
        return this.isDialInBypassEnabled;
    }

    /**
     * Set the isDialInBypassEnabled property: Specifies whether or not to always let dial-in callers bypass the lobby.
     * Optional.
     * 
     * @param isDialInBypassEnabled the isDialInBypassEnabled value to set.
     * @return the MicrosoftGraphLobbyBypassSettings object itself.
     */
    public MicrosoftGraphLobbyBypassSettings withIsDialInBypassEnabled(Boolean isDialInBypassEnabled) {
        this.isDialInBypassEnabled = isDialInBypassEnabled;
        return this;
    }

    /**
     * Get the scope property: lobbyBypassScope.
     * 
     * @return the scope value.
     */
    public MicrosoftGraphLobbyBypassScope scope() {
        return this.scope;
    }

    /**
     * Set the scope property: lobbyBypassScope.
     * 
     * @param scope the scope value to set.
     * @return the MicrosoftGraphLobbyBypassSettings object itself.
     */
    public MicrosoftGraphLobbyBypassSettings withScope(MicrosoftGraphLobbyBypassScope scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the additionalProperties property: lobbyBypassSettings.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: lobbyBypassSettings.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphLobbyBypassSettings object itself.
     */
    public MicrosoftGraphLobbyBypassSettings withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isDialInBypassEnabled", this.isDialInBypassEnabled);
        jsonWriter.writeStringField("scope", this.scope == null ? null : this.scope.toString());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphLobbyBypassSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphLobbyBypassSettings if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphLobbyBypassSettings.
     */
    public static MicrosoftGraphLobbyBypassSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphLobbyBypassSettings deserializedMicrosoftGraphLobbyBypassSettings
                = new MicrosoftGraphLobbyBypassSettings();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("isDialInBypassEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphLobbyBypassSettings.isDialInBypassEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("scope".equals(fieldName)) {
                    deserializedMicrosoftGraphLobbyBypassSettings.scope
                        = MicrosoftGraphLobbyBypassScope.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphLobbyBypassSettings.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphLobbyBypassSettings;
        });
    }
}
