// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * mailboxSettings.
 */
@Fluent
public final class MicrosoftGraphMailboxSettings implements JsonSerializable<MicrosoftGraphMailboxSettings> {
    /*
     * Folder ID of an archive folder for the user.
     */
    private String archiveFolder;

    /*
     * automaticRepliesSetting
     */
    private MicrosoftGraphAutomaticRepliesSetting automaticRepliesSetting;

    /*
     * The date format for the user's mailbox.
     */
    private String dateFormat;

    /*
     * delegateMeetingMessageDeliveryOptions
     */
    private MicrosoftGraphDelegateMeetingMessageDeliveryOptions delegateMeetingMessageDeliveryOptions;

    /*
     * localeInfo
     */
    private MicrosoftGraphLocaleInfo language;

    /*
     * The time format for the user's mailbox.
     */
    private String timeFormat;

    /*
     * The default time zone for the user's mailbox.
     */
    private String timeZone;

    /*
     * workingHours
     */
    private MicrosoftGraphWorkingHours workingHours;

    /*
     * mailboxSettings
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphMailboxSettings class.
     */
    public MicrosoftGraphMailboxSettings() {
    }

    /**
     * Get the archiveFolder property: Folder ID of an archive folder for the user.
     * 
     * @return the archiveFolder value.
     */
    public String archiveFolder() {
        return this.archiveFolder;
    }

    /**
     * Set the archiveFolder property: Folder ID of an archive folder for the user.
     * 
     * @param archiveFolder the archiveFolder value to set.
     * @return the MicrosoftGraphMailboxSettings object itself.
     */
    public MicrosoftGraphMailboxSettings withArchiveFolder(String archiveFolder) {
        this.archiveFolder = archiveFolder;
        return this;
    }

    /**
     * Get the automaticRepliesSetting property: automaticRepliesSetting.
     * 
     * @return the automaticRepliesSetting value.
     */
    public MicrosoftGraphAutomaticRepliesSetting automaticRepliesSetting() {
        return this.automaticRepliesSetting;
    }

    /**
     * Set the automaticRepliesSetting property: automaticRepliesSetting.
     * 
     * @param automaticRepliesSetting the automaticRepliesSetting value to set.
     * @return the MicrosoftGraphMailboxSettings object itself.
     */
    public MicrosoftGraphMailboxSettings
        withAutomaticRepliesSetting(MicrosoftGraphAutomaticRepliesSetting automaticRepliesSetting) {
        this.automaticRepliesSetting = automaticRepliesSetting;
        return this;
    }

    /**
     * Get the dateFormat property: The date format for the user's mailbox.
     * 
     * @return the dateFormat value.
     */
    public String dateFormat() {
        return this.dateFormat;
    }

    /**
     * Set the dateFormat property: The date format for the user's mailbox.
     * 
     * @param dateFormat the dateFormat value to set.
     * @return the MicrosoftGraphMailboxSettings object itself.
     */
    public MicrosoftGraphMailboxSettings withDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    /**
     * Get the delegateMeetingMessageDeliveryOptions property: delegateMeetingMessageDeliveryOptions.
     * 
     * @return the delegateMeetingMessageDeliveryOptions value.
     */
    public MicrosoftGraphDelegateMeetingMessageDeliveryOptions delegateMeetingMessageDeliveryOptions() {
        return this.delegateMeetingMessageDeliveryOptions;
    }

    /**
     * Set the delegateMeetingMessageDeliveryOptions property: delegateMeetingMessageDeliveryOptions.
     * 
     * @param delegateMeetingMessageDeliveryOptions the delegateMeetingMessageDeliveryOptions value to set.
     * @return the MicrosoftGraphMailboxSettings object itself.
     */
    public MicrosoftGraphMailboxSettings withDelegateMeetingMessageDeliveryOptions(
        MicrosoftGraphDelegateMeetingMessageDeliveryOptions delegateMeetingMessageDeliveryOptions) {
        this.delegateMeetingMessageDeliveryOptions = delegateMeetingMessageDeliveryOptions;
        return this;
    }

    /**
     * Get the language property: localeInfo.
     * 
     * @return the language value.
     */
    public MicrosoftGraphLocaleInfo language() {
        return this.language;
    }

    /**
     * Set the language property: localeInfo.
     * 
     * @param language the language value to set.
     * @return the MicrosoftGraphMailboxSettings object itself.
     */
    public MicrosoftGraphMailboxSettings withLanguage(MicrosoftGraphLocaleInfo language) {
        this.language = language;
        return this;
    }

    /**
     * Get the timeFormat property: The time format for the user's mailbox.
     * 
     * @return the timeFormat value.
     */
    public String timeFormat() {
        return this.timeFormat;
    }

    /**
     * Set the timeFormat property: The time format for the user's mailbox.
     * 
     * @param timeFormat the timeFormat value to set.
     * @return the MicrosoftGraphMailboxSettings object itself.
     */
    public MicrosoftGraphMailboxSettings withTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
        return this;
    }

    /**
     * Get the timeZone property: The default time zone for the user's mailbox.
     * 
     * @return the timeZone value.
     */
    public String timeZone() {
        return this.timeZone;
    }

    /**
     * Set the timeZone property: The default time zone for the user's mailbox.
     * 
     * @param timeZone the timeZone value to set.
     * @return the MicrosoftGraphMailboxSettings object itself.
     */
    public MicrosoftGraphMailboxSettings withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    /**
     * Get the workingHours property: workingHours.
     * 
     * @return the workingHours value.
     */
    public MicrosoftGraphWorkingHours workingHours() {
        return this.workingHours;
    }

    /**
     * Set the workingHours property: workingHours.
     * 
     * @param workingHours the workingHours value to set.
     * @return the MicrosoftGraphMailboxSettings object itself.
     */
    public MicrosoftGraphMailboxSettings withWorkingHours(MicrosoftGraphWorkingHours workingHours) {
        this.workingHours = workingHours;
        return this;
    }

    /**
     * Get the additionalProperties property: mailboxSettings.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: mailboxSettings.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphMailboxSettings object itself.
     */
    public MicrosoftGraphMailboxSettings withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (automaticRepliesSetting() != null) {
            automaticRepliesSetting().validate();
        }
        if (language() != null) {
            language().validate();
        }
        if (workingHours() != null) {
            workingHours().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("archiveFolder", this.archiveFolder);
        jsonWriter.writeJsonField("automaticRepliesSetting", this.automaticRepliesSetting);
        jsonWriter.writeStringField("dateFormat", this.dateFormat);
        jsonWriter.writeStringField("delegateMeetingMessageDeliveryOptions",
            this.delegateMeetingMessageDeliveryOptions == null
                ? null
                : this.delegateMeetingMessageDeliveryOptions.toString());
        jsonWriter.writeJsonField("language", this.language);
        jsonWriter.writeStringField("timeFormat", this.timeFormat);
        jsonWriter.writeStringField("timeZone", this.timeZone);
        jsonWriter.writeJsonField("workingHours", this.workingHours);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphMailboxSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphMailboxSettings if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphMailboxSettings.
     */
    public static MicrosoftGraphMailboxSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphMailboxSettings deserializedMicrosoftGraphMailboxSettings
                = new MicrosoftGraphMailboxSettings();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("archiveFolder".equals(fieldName)) {
                    deserializedMicrosoftGraphMailboxSettings.archiveFolder = reader.getString();
                } else if ("automaticRepliesSetting".equals(fieldName)) {
                    deserializedMicrosoftGraphMailboxSettings.automaticRepliesSetting
                        = MicrosoftGraphAutomaticRepliesSetting.fromJson(reader);
                } else if ("dateFormat".equals(fieldName)) {
                    deserializedMicrosoftGraphMailboxSettings.dateFormat = reader.getString();
                } else if ("delegateMeetingMessageDeliveryOptions".equals(fieldName)) {
                    deserializedMicrosoftGraphMailboxSettings.delegateMeetingMessageDeliveryOptions
                        = MicrosoftGraphDelegateMeetingMessageDeliveryOptions.fromString(reader.getString());
                } else if ("language".equals(fieldName)) {
                    deserializedMicrosoftGraphMailboxSettings.language = MicrosoftGraphLocaleInfo.fromJson(reader);
                } else if ("timeFormat".equals(fieldName)) {
                    deserializedMicrosoftGraphMailboxSettings.timeFormat = reader.getString();
                } else if ("timeZone".equals(fieldName)) {
                    deserializedMicrosoftGraphMailboxSettings.timeZone = reader.getString();
                } else if ("workingHours".equals(fieldName)) {
                    deserializedMicrosoftGraphMailboxSettings.workingHours
                        = MicrosoftGraphWorkingHours.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphMailboxSettings.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphMailboxSettings;
        });
    }
}
