// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * user
 * 
 * Represents an Azure Active Directory user object.
 */
@Fluent
public final class MicrosoftGraphUserInner extends MicrosoftGraphDirectoryObjectInner {
    /*
     * true if the account is enabled; otherwise, false. This property is required when a user is created. Supports
     * $filter.
     */
    private Boolean accountEnabled;

    /*
     * Sets the age group of the user. Allowed values: null, minor, notAdult and adult. Refer to the legal age group
     * property definitions for further information.
     */
    private String ageGroup;

    /*
     * The licenses that are assigned to the user. Not nullable.
     */
    private List<MicrosoftGraphAssignedLicense> assignedLicenses;

    /*
     * The plans that are assigned to the user. Read-only. Not nullable.
     */
    private List<MicrosoftGraphAssignedPlan> assignedPlans;

    /*
     * The telephone numbers for the user. NOTE: Although this is a string collection, only one number can be set for
     * this property. Read-only for users synced from on-premises directory.
     */
    private List<String> businessPhones;

    /*
     * The city in which the user is located. Supports $filter.
     */
    private String city;

    /*
     * The company name which the user is associated. This property can be useful for describing the company that an
     * external user comes from. The maximum length of the company name is 64 chararcters.Returned only on $select.
     */
    private String companyName;

    /*
     * Sets whether consent has been obtained for minors. Allowed values: null, granted, denied and notRequired. Refer
     * to the legal age group property definitions for further information.
     */
    private String consentProvidedForMinor;

    /*
     * The country/region in which the user is located; for example, 'US' or 'UK'. Supports $filter.
     */
    private String country;

    /*
     * The created date of the user object.
     */
    private OffsetDateTime createdDateTime;

    /*
     * Indicates whether the user account was created as a regular school or work account (null), an external account
     * (Invitation), a local account for an Azure Active Directory B2C tenant (LocalAccount) or self-service sign-up
     * using email verification (EmailVerified). Read-only.
     */
    private String creationType;

    /*
     * The name for the department in which the user works. Supports $filter.
     */
    private String department;

    /*
     * The name displayed in the address book for the user. This is usually the combination of the user's first name,
     * middle initial and last name. This property is required when a user is created and it cannot be cleared during
     * updates. Supports $filter and $orderby.
     */
    private String displayName;

    /*
     * The date and time when the user was hired or will start work in case of a future hire. Returned only on $select.
     * Supports $filter.
     */
    private OffsetDateTime employeeHireDate;

    /*
     * The employee identifier assigned to the user by the organization. Returned only on $select. Supports $filter.
     */
    private String employeeId;

    /*
     * employeeOrgData
     */
    private MicrosoftGraphEmployeeOrgData employeeOrgData;

    /*
     * Captures enterprise worker type: Employee, Contractor, Consultant, Vendor, etc. Returned only on $select.
     * Supports $filter.
     */
    private String employeeType;

    /*
     * The externalUserState property.
     */
    private String externalUserState;

    /*
     * Shows the timestamp for the latest change to the externalUserState property. Returned only on $select.
     */
    private OffsetDateTime externalUserStateChangeDateTime;

    /*
     * The fax number of the user.
     */
    private String faxNumber;

    /*
     * The given name (first name) of the user. Supports $filter.
     */
    private String givenName;

    /*
     * Represents the identities that can be used to sign in to this user account. An identity can be provided by
     * Microsoft (also known as a local account), by organizations, or by social identity providers such as Facebook,
     * Google, and Microsoft, and tied to a user account. May contain multiple items with the same signInType value.
     * Supports $filter.
     */
    private List<MicrosoftGraphObjectIdentity> identities;

    /*
     * The instant message voice over IP (VOIP) session initiation protocol (SIP) addresses for the user. Read-only.
     */
    private List<String> imAddresses;

    /*
     * Do not use – reserved for future use.
     */
    private Boolean isResourceAccount;

    /*
     * The user's job title. Supports $filter.
     */
    private String jobTitle;

    /*
     * The time when this Azure AD user last changed their password. The date and time information uses ISO 8601 format
     * and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'
     */
    private OffsetDateTime lastPasswordChangeDateTime;

    /*
     * Used by enterprise applications to determine the legal age group of the user. This property is read-only and
     * calculated based on ageGroup and consentProvidedForMinor properties. Allowed values: null,
     * minorWithOutParentalConsent, minorWithParentalConsent, minorNoParentalConsentRequired, notAdult and adult. Refer
     * to the legal age group property definitions for further information.
     */
    private String legalAgeGroupClassification;

    /*
     * State of license assignments for this user. Read-only.
     */
    private List<MicrosoftGraphLicenseAssignmentState> licenseAssignmentStates;

    /*
     * The SMTP address for the user, for example, 'jeff@contoso.onmicrosoft.com'. Supports $filter.
     */
    private String mail;

    /*
     * The mail alias for the user. This property must be specified when a user is created. Supports $filter.
     */
    private String mailNickname;

    /*
     * The primary cellular telephone number for the user. Read-only for users synced from on-premises directory.
     */
    private String mobilePhone;

    /*
     * The office location in the user's place of business.
     */
    private String officeLocation;

    /*
     * Contains the on-premises Active Directory distinguished name or DN. The property is only populated for customers
     * who are synchronizing their on-premises directory to Azure Active Directory via Azure AD Connect. Read-only.
     */
    private String onPremisesDistinguishedName;

    /*
     * Contains the on-premises domainFQDN, also called dnsDomainName synchronized from the on-premises directory. The
     * property is only populated for customers who are synchronizing their on-premises directory to Azure Active
     * Directory via Azure AD Connect. Read-only.
     */
    private String onPremisesDomainName;

    /*
     * onPremisesExtensionAttributes
     */
    private MicrosoftGraphOnPremisesExtensionAttributes onPremisesExtensionAttributes;

    /*
     * This property is used to associate an on-premises Active Directory user account to their Azure AD user object.
     * This property must be specified when creating a new user account in the Graph if you are using a federated domain
     * for the user's userPrincipalName (UPN) property. Important: The $ and _ characters cannot be used when specifying
     * this property. Supports $filter.
     */
    private String onPremisesImmutableId;

    /*
     * The onPremisesLastSyncDateTime property.
     */
    private OffsetDateTime onPremisesLastSyncDateTime;

    /*
     * Errors when using Microsoft synchronization product during provisioning.
     */
    private List<MicrosoftGraphOnPremisesProvisioningError> onPremisesProvisioningErrors;

    /*
     * Contains the on-premises samAccountName synchronized from the on-premises directory. The property is only
     * populated for customers who are synchronizing their on-premises directory to Azure Active Directory via Azure AD
     * Connect. Read-only.
     */
    private String onPremisesSamAccountName;

    /*
     * Contains the on-premises security identifier (SID) for the user that was synchronized from on-premises to the
     * cloud. Read-only.
     */
    private String onPremisesSecurityIdentifier;

    /*
     * true if this object is synced from an on-premises directory; false if this object was originally synced from an
     * on-premises directory but is no longer synced; null if this object has never been synced from an on-premises
     * directory (default). Read-only
     */
    private Boolean onPremisesSyncEnabled;

    /*
     * Contains the on-premises userPrincipalName synchronized from the on-premises directory. The property is only
     * populated for customers who are synchronizing their on-premises directory to Azure Active Directory via Azure AD
     * Connect. Read-only.
     */
    private String onPremisesUserPrincipalName;

    /*
     * The otherMails property.
     */
    private List<String> otherMails;

    /*
     * The passwordPolicies property.
     */
    private String passwordPolicies;

    /*
     * passwordProfile
     */
    private MicrosoftGraphPasswordProfile passwordProfile;

    /*
     * The postal code for the user's postal address. The postal code is specific to the user's country/region. In the
     * United States of America, this attribute contains the ZIP code.
     */
    private String postalCode;

    /*
     * The preferred language for the user. Should follow ISO 639-1 Code; for example 'en-US'.
     */
    private String preferredLanguage;

    /*
     * The plans that are provisioned for the user. Read-only. Not nullable.
     */
    private List<MicrosoftGraphProvisionedPlan> provisionedPlans;

    /*
     * The proxyAddresses property.
     */
    private List<String> proxyAddresses;

    /*
     * true if the Outlook global address list should contain this user, otherwise false. If not set, this will be
     * treated as true. For users invited through the invitation manager, this property will be set to false.
     */
    private Boolean showInAddressList;

    /*
     * Any refresh tokens or sessions tokens (session cookies) issued before this time are invalid, and applications
     * will get an error when using an invalid refresh or sessions token to acquire a delegated access token (to access
     * APIs such as Microsoft Graph). If this happens, the application will need to acquire a new refresh token by
     * making a request to the authorize endpoint. Read-only. Use revokeSignInSessions to reset.
     */
    private OffsetDateTime signInSessionsValidFromDateTime;

    /*
     * The state or province in the user's address. Supports $filter.
     */
    private String state;

    /*
     * The street address of the user's place of business.
     */
    private String streetAddress;

    /*
     * The user's surname (family name or last name). Supports $filter.
     */
    private String surname;

    /*
     * A two letter country code (ISO standard 3166). Required for users that will be assigned licenses due to legal
     * requirement to check for availability of services in countries. Examples include: 'US', 'JP', and 'GB'. Not
     * nullable. Supports $filter.
     */
    private String usageLocation;

    /*
     * The user principal name (UPN) of the user. The UPN is an Internet-style login name for the user based on the
     * Internet standard RFC 822. By convention, this should map to the user's email name. The general format is
     * alias@domain, where domain must be present in the tenant's collection of verified domains. This property is
     * required when a user is created. The verified domains for the tenant can be accessed from the verifiedDomains
     * property of organization. Supports $filter and $orderby.
     */
    private String userPrincipalName;

    /*
     * A string value that can be used to classify user types in your directory, such as 'Member' and 'Guest'. Supports
     * $filter.
     */
    private String userType;

    /*
     * mailboxSettings
     */
    private MicrosoftGraphMailboxSettings mailboxSettings;

    /*
     * The limit on the maximum number of devices that the user is permitted to enroll. Allowed values are 5 or 1000.
     */
    private Integer deviceEnrollmentLimit;

    /*
     * A freeform text entry field for the user to describe themselves.
     */
    private String aboutMe;

    /*
     * The birthday of the user. The Timestamp type represents date and time information using ISO 8601 format and is
     * always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'
     */
    private OffsetDateTime birthday;

    /*
     * The hire date of the user. The Timestamp type represents date and time information using ISO 8601 format and is
     * always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     * Returned only on $select. Note: This property is specific to SharePoint Online. We recommend using the native
     * employeeHireDate property to set and update hire date values using Microsoft Graph APIs.
     */
    private OffsetDateTime hireDate;

    /*
     * A list for the user to describe their interests.
     */
    private List<String> interests;

    /*
     * The URL for the user's personal site.
     */
    private String mySite;

    /*
     * A list for the user to enumerate their past projects.
     */
    private List<String> pastProjects;

    /*
     * The preferred name for the user.
     */
    private String preferredName;

    /*
     * A list for the user to enumerate their responsibilities.
     */
    private List<String> responsibilities;

    /*
     * A list for the user to enumerate the schools they have attended.
     */
    private List<String> schools;

    /*
     * A list for the user to enumerate their skills.
     */
    private List<String> skills;

    /*
     * The appRoleAssignments property.
     */
    private List<MicrosoftGraphAppRoleAssignment> appRoleAssignments;

    /*
     * Directory objects that were created by the user. Read-only. Nullable.
     */
    private List<MicrosoftGraphDirectoryObjectInner> createdObjects;

    /*
     * The users and contacts that report to the user. (The users and contacts that have their manager property set to
     * this user.) Read-only. Nullable.
     */
    private List<MicrosoftGraphDirectoryObjectInner> directReports;

    /*
     * A collection of this user's license details. Read-only.
     */
    private List<MicrosoftGraphLicenseDetails> licenseDetails;

    /*
     * Represents an Azure Active Directory object. The directoryObject type is the base type for many other directory
     * entity types.
     */
    private MicrosoftGraphDirectoryObjectInner manager;

    /*
     * The groups and directory roles that the user is a member of. Read-only. Nullable.
     */
    private List<MicrosoftGraphDirectoryObjectInner> memberOf;

    /*
     * The oauth2PermissionGrants property.
     */
    private List<MicrosoftGraphOAuth2PermissionGrant> oauth2PermissionGrants;

    /*
     * Devices that are owned by the user. Read-only. Nullable.
     */
    private List<MicrosoftGraphDirectoryObjectInner> ownedDevices;

    /*
     * Directory objects that are owned by the user. Read-only. Nullable.
     */
    private List<MicrosoftGraphDirectoryObjectInner> ownedObjects;

    /*
     * Devices that are registered for the user. Read-only. Nullable.
     */
    private List<MicrosoftGraphDirectoryObjectInner> registeredDevices;

    /*
     * The scopedRoleMemberOf property.
     */
    private List<MicrosoftGraphScopedRoleMembership> scopedRoleMemberOf;

    /*
     * The transitiveMemberOf property.
     */
    private List<MicrosoftGraphDirectoryObjectInner> transitiveMemberOf;

    /*
     * calendar
     */
    private MicrosoftGraphCalendar calendar;

    /*
     * The user's calendar groups. Read-only. Nullable.
     */
    private List<MicrosoftGraphCalendarGroup> calendarGroups;

    /*
     * The user's calendars. Read-only. Nullable.
     */
    private List<MicrosoftGraphCalendar> calendars;

    /*
     * The calendar view for the calendar. Read-only. Nullable.
     */
    private List<MicrosoftGraphEvent> calendarView;

    /*
     * The user's contacts folders. Read-only. Nullable.
     */
    private List<MicrosoftGraphContactFolder> contactFolders;

    /*
     * The user's contacts. Read-only. Nullable.
     */
    private List<MicrosoftGraphContact> contacts;

    /*
     * The user's events. Default is to show Events under the Default Calendar. Read-only. Nullable.
     */
    private List<MicrosoftGraphEvent> events;

    /*
     * inferenceClassification
     */
    private MicrosoftGraphInferenceClassification inferenceClassification;

    /*
     * The user's mail folders. Read-only. Nullable.
     */
    private List<MicrosoftGraphMailFolder> mailFolders;

    /*
     * The messages in a mailbox or folder. Read-only. Nullable.
     */
    private List<MicrosoftGraphMessage> messages;

    /*
     * outlookUser
     */
    private MicrosoftGraphOutlookUser outlook;

    /*
     * People that are relevant to the user. Read-only. Nullable.
     */
    private List<MicrosoftGraphPerson> people;

    /*
     * profilePhoto
     */
    private MicrosoftGraphProfilePhoto photo;

    /*
     * The photos property.
     */
    private List<MicrosoftGraphProfilePhoto> photos;

    /*
     * drive
     */
    private MicrosoftGraphDrive drive;

    /*
     * A collection of drives available for this user. Read-only.
     */
    private List<MicrosoftGraphDrive> drives;

    /*
     * The followedSites property.
     */
    private List<MicrosoftGraphSite> followedSites;

    /*
     * The collection of open extensions defined for the user. Read-only. Nullable.
     */
    private List<MicrosoftGraphExtension> extensions;

    /*
     * The managed devices associated with the user.
     */
    private List<MicrosoftGraphManagedDevice> managedDevices;

    /*
     * Zero or more managed app registrations that belong to the user.
     */
    private List<MicrosoftGraphManagedAppRegistration> managedAppRegistrations;

    /*
     * The list of troubleshooting events for this user.
     */
    private List<MicrosoftGraphDeviceManagementTroubleshootingEvent> deviceManagementTroubleshootingEvents;

    /*
     * plannerUser
     */
    private MicrosoftGraphPlannerUser planner;

    /*
     * officeGraphInsights
     */
    private MicrosoftGraphOfficeGraphInsights insights;

    /*
     * userSettings
     */
    private MicrosoftGraphUserSettings settings;

    /*
     * onenote
     */
    private MicrosoftGraphOnenote onenote;

    /*
     * The user's activities across devices. Read-only. Nullable.
     */
    private List<MicrosoftGraphUserActivity> activities;

    /*
     * The onlineMeetings property.
     */
    private List<MicrosoftGraphOnlineMeeting> onlineMeetings;

    /*
     * presence
     */
    private MicrosoftGraphPresence presence;

    /*
     * The joinedTeams property.
     */
    private List<MicrosoftGraphTeamInner> joinedTeams;

    /*
     * userTeamwork
     */
    private MicrosoftGraphUserTeamwork teamwork;

    /*
     * todo
     */
    private MicrosoftGraphTodo todo;

    /*
     * Represents an Azure Active Directory user object.
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphUserInner class.
     */
    public MicrosoftGraphUserInner() {
    }

    /**
     * Get the accountEnabled property: true if the account is enabled; otherwise, false. This property is required when
     * a user is created. Supports $filter.
     * 
     * @return the accountEnabled value.
     */
    public Boolean accountEnabled() {
        return this.accountEnabled;
    }

    /**
     * Set the accountEnabled property: true if the account is enabled; otherwise, false. This property is required when
     * a user is created. Supports $filter.
     * 
     * @param accountEnabled the accountEnabled value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withAccountEnabled(Boolean accountEnabled) {
        this.accountEnabled = accountEnabled;
        return this;
    }

    /**
     * Get the ageGroup property: Sets the age group of the user. Allowed values: null, minor, notAdult and adult. Refer
     * to the legal age group property definitions for further information.
     * 
     * @return the ageGroup value.
     */
    public String ageGroup() {
        return this.ageGroup;
    }

    /**
     * Set the ageGroup property: Sets the age group of the user. Allowed values: null, minor, notAdult and adult. Refer
     * to the legal age group property definitions for further information.
     * 
     * @param ageGroup the ageGroup value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withAgeGroup(String ageGroup) {
        this.ageGroup = ageGroup;
        return this;
    }

    /**
     * Get the assignedLicenses property: The licenses that are assigned to the user. Not nullable.
     * 
     * @return the assignedLicenses value.
     */
    public List<MicrosoftGraphAssignedLicense> assignedLicenses() {
        return this.assignedLicenses;
    }

    /**
     * Set the assignedLicenses property: The licenses that are assigned to the user. Not nullable.
     * 
     * @param assignedLicenses the assignedLicenses value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withAssignedLicenses(List<MicrosoftGraphAssignedLicense> assignedLicenses) {
        this.assignedLicenses = assignedLicenses;
        return this;
    }

    /**
     * Get the assignedPlans property: The plans that are assigned to the user. Read-only. Not nullable.
     * 
     * @return the assignedPlans value.
     */
    public List<MicrosoftGraphAssignedPlan> assignedPlans() {
        return this.assignedPlans;
    }

    /**
     * Set the assignedPlans property: The plans that are assigned to the user. Read-only. Not nullable.
     * 
     * @param assignedPlans the assignedPlans value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withAssignedPlans(List<MicrosoftGraphAssignedPlan> assignedPlans) {
        this.assignedPlans = assignedPlans;
        return this;
    }

    /**
     * Get the businessPhones property: The telephone numbers for the user. NOTE: Although this is a string collection,
     * only one number can be set for this property. Read-only for users synced from on-premises directory.
     * 
     * @return the businessPhones value.
     */
    public List<String> businessPhones() {
        return this.businessPhones;
    }

    /**
     * Set the businessPhones property: The telephone numbers for the user. NOTE: Although this is a string collection,
     * only one number can be set for this property. Read-only for users synced from on-premises directory.
     * 
     * @param businessPhones the businessPhones value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withBusinessPhones(List<String> businessPhones) {
        this.businessPhones = businessPhones;
        return this;
    }

    /**
     * Get the city property: The city in which the user is located. Supports $filter.
     * 
     * @return the city value.
     */
    public String city() {
        return this.city;
    }

    /**
     * Set the city property: The city in which the user is located. Supports $filter.
     * 
     * @param city the city value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withCity(String city) {
        this.city = city;
        return this;
    }

    /**
     * Get the companyName property: The company name which the user is associated. This property can be useful for
     * describing the company that an external user comes from. The maximum length of the company name is 64
     * chararcters.Returned only on $select.
     * 
     * @return the companyName value.
     */
    public String companyName() {
        return this.companyName;
    }

    /**
     * Set the companyName property: The company name which the user is associated. This property can be useful for
     * describing the company that an external user comes from. The maximum length of the company name is 64
     * chararcters.Returned only on $select.
     * 
     * @param companyName the companyName value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    /**
     * Get the consentProvidedForMinor property: Sets whether consent has been obtained for minors. Allowed values:
     * null, granted, denied and notRequired. Refer to the legal age group property definitions for further information.
     * 
     * @return the consentProvidedForMinor value.
     */
    public String consentProvidedForMinor() {
        return this.consentProvidedForMinor;
    }

    /**
     * Set the consentProvidedForMinor property: Sets whether consent has been obtained for minors. Allowed values:
     * null, granted, denied and notRequired. Refer to the legal age group property definitions for further information.
     * 
     * @param consentProvidedForMinor the consentProvidedForMinor value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withConsentProvidedForMinor(String consentProvidedForMinor) {
        this.consentProvidedForMinor = consentProvidedForMinor;
        return this;
    }

    /**
     * Get the country property: The country/region in which the user is located; for example, 'US' or 'UK'. Supports
     * $filter.
     * 
     * @return the country value.
     */
    public String country() {
        return this.country;
    }

    /**
     * Set the country property: The country/region in which the user is located; for example, 'US' or 'UK'. Supports
     * $filter.
     * 
     * @param country the country value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withCountry(String country) {
        this.country = country;
        return this;
    }

    /**
     * Get the createdDateTime property: The created date of the user object.
     * 
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    /**
     * Set the createdDateTime property: The created date of the user object.
     * 
     * @param createdDateTime the createdDateTime value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    /**
     * Get the creationType property: Indicates whether the user account was created as a regular school or work account
     * (null), an external account (Invitation), a local account for an Azure Active Directory B2C tenant (LocalAccount)
     * or self-service sign-up using email verification (EmailVerified). Read-only.
     * 
     * @return the creationType value.
     */
    public String creationType() {
        return this.creationType;
    }

    /**
     * Set the creationType property: Indicates whether the user account was created as a regular school or work account
     * (null), an external account (Invitation), a local account for an Azure Active Directory B2C tenant (LocalAccount)
     * or self-service sign-up using email verification (EmailVerified). Read-only.
     * 
     * @param creationType the creationType value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withCreationType(String creationType) {
        this.creationType = creationType;
        return this;
    }

    /**
     * Get the department property: The name for the department in which the user works. Supports $filter.
     * 
     * @return the department value.
     */
    public String department() {
        return this.department;
    }

    /**
     * Set the department property: The name for the department in which the user works. Supports $filter.
     * 
     * @param department the department value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withDepartment(String department) {
        this.department = department;
        return this;
    }

    /**
     * Get the displayName property: The name displayed in the address book for the user. This is usually the
     * combination of the user's first name, middle initial and last name. This property is required when a user is
     * created and it cannot be cleared during updates. Supports $filter and $orderby.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The name displayed in the address book for the user. This is usually the
     * combination of the user's first name, middle initial and last name. This property is required when a user is
     * created and it cannot be cleared during updates. Supports $filter and $orderby.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the employeeHireDate property: The date and time when the user was hired or will start work in case of a
     * future hire. Returned only on $select. Supports $filter.
     * 
     * @return the employeeHireDate value.
     */
    public OffsetDateTime employeeHireDate() {
        return this.employeeHireDate;
    }

    /**
     * Set the employeeHireDate property: The date and time when the user was hired or will start work in case of a
     * future hire. Returned only on $select. Supports $filter.
     * 
     * @param employeeHireDate the employeeHireDate value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withEmployeeHireDate(OffsetDateTime employeeHireDate) {
        this.employeeHireDate = employeeHireDate;
        return this;
    }

    /**
     * Get the employeeId property: The employee identifier assigned to the user by the organization. Returned only on
     * $select. Supports $filter.
     * 
     * @return the employeeId value.
     */
    public String employeeId() {
        return this.employeeId;
    }

    /**
     * Set the employeeId property: The employee identifier assigned to the user by the organization. Returned only on
     * $select. Supports $filter.
     * 
     * @param employeeId the employeeId value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withEmployeeId(String employeeId) {
        this.employeeId = employeeId;
        return this;
    }

    /**
     * Get the employeeOrgData property: employeeOrgData.
     * 
     * @return the employeeOrgData value.
     */
    public MicrosoftGraphEmployeeOrgData employeeOrgData() {
        return this.employeeOrgData;
    }

    /**
     * Set the employeeOrgData property: employeeOrgData.
     * 
     * @param employeeOrgData the employeeOrgData value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withEmployeeOrgData(MicrosoftGraphEmployeeOrgData employeeOrgData) {
        this.employeeOrgData = employeeOrgData;
        return this;
    }

    /**
     * Get the employeeType property: Captures enterprise worker type: Employee, Contractor, Consultant, Vendor, etc.
     * Returned only on $select. Supports $filter.
     * 
     * @return the employeeType value.
     */
    public String employeeType() {
        return this.employeeType;
    }

    /**
     * Set the employeeType property: Captures enterprise worker type: Employee, Contractor, Consultant, Vendor, etc.
     * Returned only on $select. Supports $filter.
     * 
     * @param employeeType the employeeType value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withEmployeeType(String employeeType) {
        this.employeeType = employeeType;
        return this;
    }

    /**
     * Get the externalUserState property: The externalUserState property.
     * 
     * @return the externalUserState value.
     */
    public String externalUserState() {
        return this.externalUserState;
    }

    /**
     * Set the externalUserState property: The externalUserState property.
     * 
     * @param externalUserState the externalUserState value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withExternalUserState(String externalUserState) {
        this.externalUserState = externalUserState;
        return this;
    }

    /**
     * Get the externalUserStateChangeDateTime property: Shows the timestamp for the latest change to the
     * externalUserState property. Returned only on $select.
     * 
     * @return the externalUserStateChangeDateTime value.
     */
    public OffsetDateTime externalUserStateChangeDateTime() {
        return this.externalUserStateChangeDateTime;
    }

    /**
     * Set the externalUserStateChangeDateTime property: Shows the timestamp for the latest change to the
     * externalUserState property. Returned only on $select.
     * 
     * @param externalUserStateChangeDateTime the externalUserStateChangeDateTime value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withExternalUserStateChangeDateTime(OffsetDateTime externalUserStateChangeDateTime) {
        this.externalUserStateChangeDateTime = externalUserStateChangeDateTime;
        return this;
    }

    /**
     * Get the faxNumber property: The fax number of the user.
     * 
     * @return the faxNumber value.
     */
    public String faxNumber() {
        return this.faxNumber;
    }

    /**
     * Set the faxNumber property: The fax number of the user.
     * 
     * @param faxNumber the faxNumber value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
        return this;
    }

    /**
     * Get the givenName property: The given name (first name) of the user. Supports $filter.
     * 
     * @return the givenName value.
     */
    public String givenName() {
        return this.givenName;
    }

    /**
     * Set the givenName property: The given name (first name) of the user. Supports $filter.
     * 
     * @param givenName the givenName value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withGivenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    /**
     * Get the identities property: Represents the identities that can be used to sign in to this user account. An
     * identity can be provided by Microsoft (also known as a local account), by organizations, or by social identity
     * providers such as Facebook, Google, and Microsoft, and tied to a user account. May contain multiple items with
     * the same signInType value. Supports $filter.
     * 
     * @return the identities value.
     */
    public List<MicrosoftGraphObjectIdentity> identities() {
        return this.identities;
    }

    /**
     * Set the identities property: Represents the identities that can be used to sign in to this user account. An
     * identity can be provided by Microsoft (also known as a local account), by organizations, or by social identity
     * providers such as Facebook, Google, and Microsoft, and tied to a user account. May contain multiple items with
     * the same signInType value. Supports $filter.
     * 
     * @param identities the identities value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withIdentities(List<MicrosoftGraphObjectIdentity> identities) {
        this.identities = identities;
        return this;
    }

    /**
     * Get the imAddresses property: The instant message voice over IP (VOIP) session initiation protocol (SIP)
     * addresses for the user. Read-only.
     * 
     * @return the imAddresses value.
     */
    public List<String> imAddresses() {
        return this.imAddresses;
    }

    /**
     * Set the imAddresses property: The instant message voice over IP (VOIP) session initiation protocol (SIP)
     * addresses for the user. Read-only.
     * 
     * @param imAddresses the imAddresses value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withImAddresses(List<String> imAddresses) {
        this.imAddresses = imAddresses;
        return this;
    }

    /**
     * Get the isResourceAccount property: Do not use – reserved for future use.
     * 
     * @return the isResourceAccount value.
     */
    public Boolean isResourceAccount() {
        return this.isResourceAccount;
    }

    /**
     * Set the isResourceAccount property: Do not use – reserved for future use.
     * 
     * @param isResourceAccount the isResourceAccount value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withIsResourceAccount(Boolean isResourceAccount) {
        this.isResourceAccount = isResourceAccount;
        return this;
    }

    /**
     * Get the jobTitle property: The user's job title. Supports $filter.
     * 
     * @return the jobTitle value.
     */
    public String jobTitle() {
        return this.jobTitle;
    }

    /**
     * Set the jobTitle property: The user's job title. Supports $filter.
     * 
     * @param jobTitle the jobTitle value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
        return this;
    }

    /**
     * Get the lastPasswordChangeDateTime property: The time when this Azure AD user last changed their password. The
     * date and time information uses ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1,
     * 2014 would look like this: '2014-01-01T00:00:00Z'.
     * 
     * @return the lastPasswordChangeDateTime value.
     */
    public OffsetDateTime lastPasswordChangeDateTime() {
        return this.lastPasswordChangeDateTime;
    }

    /**
     * Set the lastPasswordChangeDateTime property: The time when this Azure AD user last changed their password. The
     * date and time information uses ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1,
     * 2014 would look like this: '2014-01-01T00:00:00Z'.
     * 
     * @param lastPasswordChangeDateTime the lastPasswordChangeDateTime value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withLastPasswordChangeDateTime(OffsetDateTime lastPasswordChangeDateTime) {
        this.lastPasswordChangeDateTime = lastPasswordChangeDateTime;
        return this;
    }

    /**
     * Get the legalAgeGroupClassification property: Used by enterprise applications to determine the legal age group of
     * the user. This property is read-only and calculated based on ageGroup and consentProvidedForMinor properties.
     * Allowed values: null, minorWithOutParentalConsent, minorWithParentalConsent, minorNoParentalConsentRequired,
     * notAdult and adult. Refer to the legal age group property definitions for further information.
     * 
     * @return the legalAgeGroupClassification value.
     */
    public String legalAgeGroupClassification() {
        return this.legalAgeGroupClassification;
    }

    /**
     * Set the legalAgeGroupClassification property: Used by enterprise applications to determine the legal age group of
     * the user. This property is read-only and calculated based on ageGroup and consentProvidedForMinor properties.
     * Allowed values: null, minorWithOutParentalConsent, minorWithParentalConsent, minorNoParentalConsentRequired,
     * notAdult and adult. Refer to the legal age group property definitions for further information.
     * 
     * @param legalAgeGroupClassification the legalAgeGroupClassification value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withLegalAgeGroupClassification(String legalAgeGroupClassification) {
        this.legalAgeGroupClassification = legalAgeGroupClassification;
        return this;
    }

    /**
     * Get the licenseAssignmentStates property: State of license assignments for this user. Read-only.
     * 
     * @return the licenseAssignmentStates value.
     */
    public List<MicrosoftGraphLicenseAssignmentState> licenseAssignmentStates() {
        return this.licenseAssignmentStates;
    }

    /**
     * Set the licenseAssignmentStates property: State of license assignments for this user. Read-only.
     * 
     * @param licenseAssignmentStates the licenseAssignmentStates value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner
        withLicenseAssignmentStates(List<MicrosoftGraphLicenseAssignmentState> licenseAssignmentStates) {
        this.licenseAssignmentStates = licenseAssignmentStates;
        return this;
    }

    /**
     * Get the mail property: The SMTP address for the user, for example, 'jeff&#064;contoso.onmicrosoft.com'. Supports
     * $filter.
     * 
     * @return the mail value.
     */
    public String mail() {
        return this.mail;
    }

    /**
     * Set the mail property: The SMTP address for the user, for example, 'jeff&#064;contoso.onmicrosoft.com'. Supports
     * $filter.
     * 
     * @param mail the mail value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withMail(String mail) {
        this.mail = mail;
        return this;
    }

    /**
     * Get the mailNickname property: The mail alias for the user. This property must be specified when a user is
     * created. Supports $filter.
     * 
     * @return the mailNickname value.
     */
    public String mailNickname() {
        return this.mailNickname;
    }

    /**
     * Set the mailNickname property: The mail alias for the user. This property must be specified when a user is
     * created. Supports $filter.
     * 
     * @param mailNickname the mailNickname value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withMailNickname(String mailNickname) {
        this.mailNickname = mailNickname;
        return this;
    }

    /**
     * Get the mobilePhone property: The primary cellular telephone number for the user. Read-only for users synced from
     * on-premises directory.
     * 
     * @return the mobilePhone value.
     */
    public String mobilePhone() {
        return this.mobilePhone;
    }

    /**
     * Set the mobilePhone property: The primary cellular telephone number for the user. Read-only for users synced from
     * on-premises directory.
     * 
     * @param mobilePhone the mobilePhone value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    /**
     * Get the officeLocation property: The office location in the user's place of business.
     * 
     * @return the officeLocation value.
     */
    public String officeLocation() {
        return this.officeLocation;
    }

    /**
     * Set the officeLocation property: The office location in the user's place of business.
     * 
     * @param officeLocation the officeLocation value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withOfficeLocation(String officeLocation) {
        this.officeLocation = officeLocation;
        return this;
    }

    /**
     * Get the onPremisesDistinguishedName property: Contains the on-premises Active Directory distinguished name or DN.
     * The property is only populated for customers who are synchronizing their on-premises directory to Azure Active
     * Directory via Azure AD Connect. Read-only.
     * 
     * @return the onPremisesDistinguishedName value.
     */
    public String onPremisesDistinguishedName() {
        return this.onPremisesDistinguishedName;
    }

    /**
     * Set the onPremisesDistinguishedName property: Contains the on-premises Active Directory distinguished name or DN.
     * The property is only populated for customers who are synchronizing their on-premises directory to Azure Active
     * Directory via Azure AD Connect. Read-only.
     * 
     * @param onPremisesDistinguishedName the onPremisesDistinguishedName value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withOnPremisesDistinguishedName(String onPremisesDistinguishedName) {
        this.onPremisesDistinguishedName = onPremisesDistinguishedName;
        return this;
    }

    /**
     * Get the onPremisesDomainName property: Contains the on-premises domainFQDN, also called dnsDomainName
     * synchronized from the on-premises directory. The property is only populated for customers who are synchronizing
     * their on-premises directory to Azure Active Directory via Azure AD Connect. Read-only.
     * 
     * @return the onPremisesDomainName value.
     */
    public String onPremisesDomainName() {
        return this.onPremisesDomainName;
    }

    /**
     * Set the onPremisesDomainName property: Contains the on-premises domainFQDN, also called dnsDomainName
     * synchronized from the on-premises directory. The property is only populated for customers who are synchronizing
     * their on-premises directory to Azure Active Directory via Azure AD Connect. Read-only.
     * 
     * @param onPremisesDomainName the onPremisesDomainName value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withOnPremisesDomainName(String onPremisesDomainName) {
        this.onPremisesDomainName = onPremisesDomainName;
        return this;
    }

    /**
     * Get the onPremisesExtensionAttributes property: onPremisesExtensionAttributes.
     * 
     * @return the onPremisesExtensionAttributes value.
     */
    public MicrosoftGraphOnPremisesExtensionAttributes onPremisesExtensionAttributes() {
        return this.onPremisesExtensionAttributes;
    }

    /**
     * Set the onPremisesExtensionAttributes property: onPremisesExtensionAttributes.
     * 
     * @param onPremisesExtensionAttributes the onPremisesExtensionAttributes value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner
        withOnPremisesExtensionAttributes(MicrosoftGraphOnPremisesExtensionAttributes onPremisesExtensionAttributes) {
        this.onPremisesExtensionAttributes = onPremisesExtensionAttributes;
        return this;
    }

    /**
     * Get the onPremisesImmutableId property: This property is used to associate an on-premises Active Directory user
     * account to their Azure AD user object. This property must be specified when creating a new user account in the
     * Graph if you are using a federated domain for the user's userPrincipalName (UPN) property. Important: The $ and _
     * characters cannot be used when specifying this property. Supports $filter.
     * 
     * @return the onPremisesImmutableId value.
     */
    public String onPremisesImmutableId() {
        return this.onPremisesImmutableId;
    }

    /**
     * Set the onPremisesImmutableId property: This property is used to associate an on-premises Active Directory user
     * account to their Azure AD user object. This property must be specified when creating a new user account in the
     * Graph if you are using a federated domain for the user's userPrincipalName (UPN) property. Important: The $ and _
     * characters cannot be used when specifying this property. Supports $filter.
     * 
     * @param onPremisesImmutableId the onPremisesImmutableId value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withOnPremisesImmutableId(String onPremisesImmutableId) {
        this.onPremisesImmutableId = onPremisesImmutableId;
        return this;
    }

    /**
     * Get the onPremisesLastSyncDateTime property: The onPremisesLastSyncDateTime property.
     * 
     * @return the onPremisesLastSyncDateTime value.
     */
    public OffsetDateTime onPremisesLastSyncDateTime() {
        return this.onPremisesLastSyncDateTime;
    }

    /**
     * Set the onPremisesLastSyncDateTime property: The onPremisesLastSyncDateTime property.
     * 
     * @param onPremisesLastSyncDateTime the onPremisesLastSyncDateTime value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withOnPremisesLastSyncDateTime(OffsetDateTime onPremisesLastSyncDateTime) {
        this.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
        return this;
    }

    /**
     * Get the onPremisesProvisioningErrors property: Errors when using Microsoft synchronization product during
     * provisioning.
     * 
     * @return the onPremisesProvisioningErrors value.
     */
    public List<MicrosoftGraphOnPremisesProvisioningError> onPremisesProvisioningErrors() {
        return this.onPremisesProvisioningErrors;
    }

    /**
     * Set the onPremisesProvisioningErrors property: Errors when using Microsoft synchronization product during
     * provisioning.
     * 
     * @param onPremisesProvisioningErrors the onPremisesProvisioningErrors value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner
        withOnPremisesProvisioningErrors(List<MicrosoftGraphOnPremisesProvisioningError> onPremisesProvisioningErrors) {
        this.onPremisesProvisioningErrors = onPremisesProvisioningErrors;
        return this;
    }

    /**
     * Get the onPremisesSamAccountName property: Contains the on-premises samAccountName synchronized from the
     * on-premises directory. The property is only populated for customers who are synchronizing their on-premises
     * directory to Azure Active Directory via Azure AD Connect. Read-only.
     * 
     * @return the onPremisesSamAccountName value.
     */
    public String onPremisesSamAccountName() {
        return this.onPremisesSamAccountName;
    }

    /**
     * Set the onPremisesSamAccountName property: Contains the on-premises samAccountName synchronized from the
     * on-premises directory. The property is only populated for customers who are synchronizing their on-premises
     * directory to Azure Active Directory via Azure AD Connect. Read-only.
     * 
     * @param onPremisesSamAccountName the onPremisesSamAccountName value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withOnPremisesSamAccountName(String onPremisesSamAccountName) {
        this.onPremisesSamAccountName = onPremisesSamAccountName;
        return this;
    }

    /**
     * Get the onPremisesSecurityIdentifier property: Contains the on-premises security identifier (SID) for the user
     * that was synchronized from on-premises to the cloud. Read-only.
     * 
     * @return the onPremisesSecurityIdentifier value.
     */
    public String onPremisesSecurityIdentifier() {
        return this.onPremisesSecurityIdentifier;
    }

    /**
     * Set the onPremisesSecurityIdentifier property: Contains the on-premises security identifier (SID) for the user
     * that was synchronized from on-premises to the cloud. Read-only.
     * 
     * @param onPremisesSecurityIdentifier the onPremisesSecurityIdentifier value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withOnPremisesSecurityIdentifier(String onPremisesSecurityIdentifier) {
        this.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
        return this;
    }

    /**
     * Get the onPremisesSyncEnabled property: true if this object is synced from an on-premises directory; false if
     * this object was originally synced from an on-premises directory but is no longer synced; null if this object has
     * never been synced from an on-premises directory (default). Read-only.
     * 
     * @return the onPremisesSyncEnabled value.
     */
    public Boolean onPremisesSyncEnabled() {
        return this.onPremisesSyncEnabled;
    }

    /**
     * Set the onPremisesSyncEnabled property: true if this object is synced from an on-premises directory; false if
     * this object was originally synced from an on-premises directory but is no longer synced; null if this object has
     * never been synced from an on-premises directory (default). Read-only.
     * 
     * @param onPremisesSyncEnabled the onPremisesSyncEnabled value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withOnPremisesSyncEnabled(Boolean onPremisesSyncEnabled) {
        this.onPremisesSyncEnabled = onPremisesSyncEnabled;
        return this;
    }

    /**
     * Get the onPremisesUserPrincipalName property: Contains the on-premises userPrincipalName synchronized from the
     * on-premises directory. The property is only populated for customers who are synchronizing their on-premises
     * directory to Azure Active Directory via Azure AD Connect. Read-only.
     * 
     * @return the onPremisesUserPrincipalName value.
     */
    public String onPremisesUserPrincipalName() {
        return this.onPremisesUserPrincipalName;
    }

    /**
     * Set the onPremisesUserPrincipalName property: Contains the on-premises userPrincipalName synchronized from the
     * on-premises directory. The property is only populated for customers who are synchronizing their on-premises
     * directory to Azure Active Directory via Azure AD Connect. Read-only.
     * 
     * @param onPremisesUserPrincipalName the onPremisesUserPrincipalName value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withOnPremisesUserPrincipalName(String onPremisesUserPrincipalName) {
        this.onPremisesUserPrincipalName = onPremisesUserPrincipalName;
        return this;
    }

    /**
     * Get the otherMails property: The otherMails property.
     * 
     * @return the otherMails value.
     */
    public List<String> otherMails() {
        return this.otherMails;
    }

    /**
     * Set the otherMails property: The otherMails property.
     * 
     * @param otherMails the otherMails value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withOtherMails(List<String> otherMails) {
        this.otherMails = otherMails;
        return this;
    }

    /**
     * Get the passwordPolicies property: The passwordPolicies property.
     * 
     * @return the passwordPolicies value.
     */
    public String passwordPolicies() {
        return this.passwordPolicies;
    }

    /**
     * Set the passwordPolicies property: The passwordPolicies property.
     * 
     * @param passwordPolicies the passwordPolicies value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withPasswordPolicies(String passwordPolicies) {
        this.passwordPolicies = passwordPolicies;
        return this;
    }

    /**
     * Get the passwordProfile property: passwordProfile.
     * 
     * @return the passwordProfile value.
     */
    public MicrosoftGraphPasswordProfile passwordProfile() {
        return this.passwordProfile;
    }

    /**
     * Set the passwordProfile property: passwordProfile.
     * 
     * @param passwordProfile the passwordProfile value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withPasswordProfile(MicrosoftGraphPasswordProfile passwordProfile) {
        this.passwordProfile = passwordProfile;
        return this;
    }

    /**
     * Get the postalCode property: The postal code for the user's postal address. The postal code is specific to the
     * user's country/region. In the United States of America, this attribute contains the ZIP code.
     * 
     * @return the postalCode value.
     */
    public String postalCode() {
        return this.postalCode;
    }

    /**
     * Set the postalCode property: The postal code for the user's postal address. The postal code is specific to the
     * user's country/region. In the United States of America, this attribute contains the ZIP code.
     * 
     * @param postalCode the postalCode value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withPostalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    /**
     * Get the preferredLanguage property: The preferred language for the user. Should follow ISO 639-1 Code; for
     * example 'en-US'.
     * 
     * @return the preferredLanguage value.
     */
    public String preferredLanguage() {
        return this.preferredLanguage;
    }

    /**
     * Set the preferredLanguage property: The preferred language for the user. Should follow ISO 639-1 Code; for
     * example 'en-US'.
     * 
     * @param preferredLanguage the preferredLanguage value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
        return this;
    }

    /**
     * Get the provisionedPlans property: The plans that are provisioned for the user. Read-only. Not nullable.
     * 
     * @return the provisionedPlans value.
     */
    public List<MicrosoftGraphProvisionedPlan> provisionedPlans() {
        return this.provisionedPlans;
    }

    /**
     * Set the provisionedPlans property: The plans that are provisioned for the user. Read-only. Not nullable.
     * 
     * @param provisionedPlans the provisionedPlans value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withProvisionedPlans(List<MicrosoftGraphProvisionedPlan> provisionedPlans) {
        this.provisionedPlans = provisionedPlans;
        return this;
    }

    /**
     * Get the proxyAddresses property: The proxyAddresses property.
     * 
     * @return the proxyAddresses value.
     */
    public List<String> proxyAddresses() {
        return this.proxyAddresses;
    }

    /**
     * Set the proxyAddresses property: The proxyAddresses property.
     * 
     * @param proxyAddresses the proxyAddresses value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withProxyAddresses(List<String> proxyAddresses) {
        this.proxyAddresses = proxyAddresses;
        return this;
    }

    /**
     * Get the showInAddressList property: true if the Outlook global address list should contain this user, otherwise
     * false. If not set, this will be treated as true. For users invited through the invitation manager, this property
     * will be set to false.
     * 
     * @return the showInAddressList value.
     */
    public Boolean showInAddressList() {
        return this.showInAddressList;
    }

    /**
     * Set the showInAddressList property: true if the Outlook global address list should contain this user, otherwise
     * false. If not set, this will be treated as true. For users invited through the invitation manager, this property
     * will be set to false.
     * 
     * @param showInAddressList the showInAddressList value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withShowInAddressList(Boolean showInAddressList) {
        this.showInAddressList = showInAddressList;
        return this;
    }

    /**
     * Get the signInSessionsValidFromDateTime property: Any refresh tokens or sessions tokens (session cookies) issued
     * before this time are invalid, and applications will get an error when using an invalid refresh or sessions token
     * to acquire a delegated access token (to access APIs such as Microsoft Graph). If this happens, the application
     * will need to acquire a new refresh token by making a request to the authorize endpoint. Read-only. Use
     * revokeSignInSessions to reset.
     * 
     * @return the signInSessionsValidFromDateTime value.
     */
    public OffsetDateTime signInSessionsValidFromDateTime() {
        return this.signInSessionsValidFromDateTime;
    }

    /**
     * Set the signInSessionsValidFromDateTime property: Any refresh tokens or sessions tokens (session cookies) issued
     * before this time are invalid, and applications will get an error when using an invalid refresh or sessions token
     * to acquire a delegated access token (to access APIs such as Microsoft Graph). If this happens, the application
     * will need to acquire a new refresh token by making a request to the authorize endpoint. Read-only. Use
     * revokeSignInSessions to reset.
     * 
     * @param signInSessionsValidFromDateTime the signInSessionsValidFromDateTime value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withSignInSessionsValidFromDateTime(OffsetDateTime signInSessionsValidFromDateTime) {
        this.signInSessionsValidFromDateTime = signInSessionsValidFromDateTime;
        return this;
    }

    /**
     * Get the state property: The state or province in the user's address. Supports $filter.
     * 
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Set the state property: The state or province in the user's address. Supports $filter.
     * 
     * @param state the state value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withState(String state) {
        this.state = state;
        return this;
    }

    /**
     * Get the streetAddress property: The street address of the user's place of business.
     * 
     * @return the streetAddress value.
     */
    public String streetAddress() {
        return this.streetAddress;
    }

    /**
     * Set the streetAddress property: The street address of the user's place of business.
     * 
     * @param streetAddress the streetAddress value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withStreetAddress(String streetAddress) {
        this.streetAddress = streetAddress;
        return this;
    }

    /**
     * Get the surname property: The user's surname (family name or last name). Supports $filter.
     * 
     * @return the surname value.
     */
    public String surname() {
        return this.surname;
    }

    /**
     * Set the surname property: The user's surname (family name or last name). Supports $filter.
     * 
     * @param surname the surname value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withSurname(String surname) {
        this.surname = surname;
        return this;
    }

    /**
     * Get the usageLocation property: A two letter country code (ISO standard 3166). Required for users that will be
     * assigned licenses due to legal requirement to check for availability of services in countries. Examples include:
     * 'US', 'JP', and 'GB'. Not nullable. Supports $filter.
     * 
     * @return the usageLocation value.
     */
    public String usageLocation() {
        return this.usageLocation;
    }

    /**
     * Set the usageLocation property: A two letter country code (ISO standard 3166). Required for users that will be
     * assigned licenses due to legal requirement to check for availability of services in countries. Examples include:
     * 'US', 'JP', and 'GB'. Not nullable. Supports $filter.
     * 
     * @param usageLocation the usageLocation value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withUsageLocation(String usageLocation) {
        this.usageLocation = usageLocation;
        return this;
    }

    /**
     * Get the userPrincipalName property: The user principal name (UPN) of the user. The UPN is an Internet-style login
     * name for the user based on the Internet standard RFC 822. By convention, this should map to the user's email
     * name. The general format is alias&#064;domain, where domain must be present in the tenant's collection of
     * verified domains. This property is required when a user is created. The verified domains for the tenant can be
     * accessed from the verifiedDomains property of organization. Supports $filter and $orderby.
     * 
     * @return the userPrincipalName value.
     */
    public String userPrincipalName() {
        return this.userPrincipalName;
    }

    /**
     * Set the userPrincipalName property: The user principal name (UPN) of the user. The UPN is an Internet-style login
     * name for the user based on the Internet standard RFC 822. By convention, this should map to the user's email
     * name. The general format is alias&#064;domain, where domain must be present in the tenant's collection of
     * verified domains. This property is required when a user is created. The verified domains for the tenant can be
     * accessed from the verifiedDomains property of organization. Supports $filter and $orderby.
     * 
     * @param userPrincipalName the userPrincipalName value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withUserPrincipalName(String userPrincipalName) {
        this.userPrincipalName = userPrincipalName;
        return this;
    }

    /**
     * Get the userType property: A string value that can be used to classify user types in your directory, such as
     * 'Member' and 'Guest'. Supports $filter.
     * 
     * @return the userType value.
     */
    public String userType() {
        return this.userType;
    }

    /**
     * Set the userType property: A string value that can be used to classify user types in your directory, such as
     * 'Member' and 'Guest'. Supports $filter.
     * 
     * @param userType the userType value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withUserType(String userType) {
        this.userType = userType;
        return this;
    }

    /**
     * Get the mailboxSettings property: mailboxSettings.
     * 
     * @return the mailboxSettings value.
     */
    public MicrosoftGraphMailboxSettings mailboxSettings() {
        return this.mailboxSettings;
    }

    /**
     * Set the mailboxSettings property: mailboxSettings.
     * 
     * @param mailboxSettings the mailboxSettings value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withMailboxSettings(MicrosoftGraphMailboxSettings mailboxSettings) {
        this.mailboxSettings = mailboxSettings;
        return this;
    }

    /**
     * Get the deviceEnrollmentLimit property: The limit on the maximum number of devices that the user is permitted to
     * enroll. Allowed values are 5 or 1000.
     * 
     * @return the deviceEnrollmentLimit value.
     */
    public Integer deviceEnrollmentLimit() {
        return this.deviceEnrollmentLimit;
    }

    /**
     * Set the deviceEnrollmentLimit property: The limit on the maximum number of devices that the user is permitted to
     * enroll. Allowed values are 5 or 1000.
     * 
     * @param deviceEnrollmentLimit the deviceEnrollmentLimit value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withDeviceEnrollmentLimit(Integer deviceEnrollmentLimit) {
        this.deviceEnrollmentLimit = deviceEnrollmentLimit;
        return this;
    }

    /**
     * Get the aboutMe property: A freeform text entry field for the user to describe themselves.
     * 
     * @return the aboutMe value.
     */
    public String aboutMe() {
        return this.aboutMe;
    }

    /**
     * Set the aboutMe property: A freeform text entry field for the user to describe themselves.
     * 
     * @param aboutMe the aboutMe value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withAboutMe(String aboutMe) {
        this.aboutMe = aboutMe;
        return this;
    }

    /**
     * Get the birthday property: The birthday of the user. The Timestamp type represents date and time information
     * using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     * 
     * @return the birthday value.
     */
    public OffsetDateTime birthday() {
        return this.birthday;
    }

    /**
     * Set the birthday property: The birthday of the user. The Timestamp type represents date and time information
     * using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     * 
     * @param birthday the birthday value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withBirthday(OffsetDateTime birthday) {
        this.birthday = birthday;
        return this;
    }

    /**
     * Get the hireDate property: The hire date of the user. The Timestamp type represents date and time information
     * using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Returned only on $select. Note: This property is specific to SharePoint Online. We
     * recommend using the native employeeHireDate property to set and update hire date values using Microsoft Graph
     * APIs.
     * 
     * @return the hireDate value.
     */
    public OffsetDateTime hireDate() {
        return this.hireDate;
    }

    /**
     * Set the hireDate property: The hire date of the user. The Timestamp type represents date and time information
     * using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Returned only on $select. Note: This property is specific to SharePoint Online. We
     * recommend using the native employeeHireDate property to set and update hire date values using Microsoft Graph
     * APIs.
     * 
     * @param hireDate the hireDate value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withHireDate(OffsetDateTime hireDate) {
        this.hireDate = hireDate;
        return this;
    }

    /**
     * Get the interests property: A list for the user to describe their interests.
     * 
     * @return the interests value.
     */
    public List<String> interests() {
        return this.interests;
    }

    /**
     * Set the interests property: A list for the user to describe their interests.
     * 
     * @param interests the interests value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withInterests(List<String> interests) {
        this.interests = interests;
        return this;
    }

    /**
     * Get the mySite property: The URL for the user's personal site.
     * 
     * @return the mySite value.
     */
    public String mySite() {
        return this.mySite;
    }

    /**
     * Set the mySite property: The URL for the user's personal site.
     * 
     * @param mySite the mySite value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withMySite(String mySite) {
        this.mySite = mySite;
        return this;
    }

    /**
     * Get the pastProjects property: A list for the user to enumerate their past projects.
     * 
     * @return the pastProjects value.
     */
    public List<String> pastProjects() {
        return this.pastProjects;
    }

    /**
     * Set the pastProjects property: A list for the user to enumerate their past projects.
     * 
     * @param pastProjects the pastProjects value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withPastProjects(List<String> pastProjects) {
        this.pastProjects = pastProjects;
        return this;
    }

    /**
     * Get the preferredName property: The preferred name for the user.
     * 
     * @return the preferredName value.
     */
    public String preferredName() {
        return this.preferredName;
    }

    /**
     * Set the preferredName property: The preferred name for the user.
     * 
     * @param preferredName the preferredName value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withPreferredName(String preferredName) {
        this.preferredName = preferredName;
        return this;
    }

    /**
     * Get the responsibilities property: A list for the user to enumerate their responsibilities.
     * 
     * @return the responsibilities value.
     */
    public List<String> responsibilities() {
        return this.responsibilities;
    }

    /**
     * Set the responsibilities property: A list for the user to enumerate their responsibilities.
     * 
     * @param responsibilities the responsibilities value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withResponsibilities(List<String> responsibilities) {
        this.responsibilities = responsibilities;
        return this;
    }

    /**
     * Get the schools property: A list for the user to enumerate the schools they have attended.
     * 
     * @return the schools value.
     */
    public List<String> schools() {
        return this.schools;
    }

    /**
     * Set the schools property: A list for the user to enumerate the schools they have attended.
     * 
     * @param schools the schools value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withSchools(List<String> schools) {
        this.schools = schools;
        return this;
    }

    /**
     * Get the skills property: A list for the user to enumerate their skills.
     * 
     * @return the skills value.
     */
    public List<String> skills() {
        return this.skills;
    }

    /**
     * Set the skills property: A list for the user to enumerate their skills.
     * 
     * @param skills the skills value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withSkills(List<String> skills) {
        this.skills = skills;
        return this;
    }

    /**
     * Get the appRoleAssignments property: The appRoleAssignments property.
     * 
     * @return the appRoleAssignments value.
     */
    public List<MicrosoftGraphAppRoleAssignment> appRoleAssignments() {
        return this.appRoleAssignments;
    }

    /**
     * Set the appRoleAssignments property: The appRoleAssignments property.
     * 
     * @param appRoleAssignments the appRoleAssignments value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withAppRoleAssignments(List<MicrosoftGraphAppRoleAssignment> appRoleAssignments) {
        this.appRoleAssignments = appRoleAssignments;
        return this;
    }

    /**
     * Get the createdObjects property: Directory objects that were created by the user. Read-only. Nullable.
     * 
     * @return the createdObjects value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> createdObjects() {
        return this.createdObjects;
    }

    /**
     * Set the createdObjects property: Directory objects that were created by the user. Read-only. Nullable.
     * 
     * @param createdObjects the createdObjects value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withCreatedObjects(List<MicrosoftGraphDirectoryObjectInner> createdObjects) {
        this.createdObjects = createdObjects;
        return this;
    }

    /**
     * Get the directReports property: The users and contacts that report to the user. (The users and contacts that have
     * their manager property set to this user.) Read-only. Nullable.
     * 
     * @return the directReports value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> directReports() {
        return this.directReports;
    }

    /**
     * Set the directReports property: The users and contacts that report to the user. (The users and contacts that have
     * their manager property set to this user.) Read-only. Nullable.
     * 
     * @param directReports the directReports value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withDirectReports(List<MicrosoftGraphDirectoryObjectInner> directReports) {
        this.directReports = directReports;
        return this;
    }

    /**
     * Get the licenseDetails property: A collection of this user's license details. Read-only.
     * 
     * @return the licenseDetails value.
     */
    public List<MicrosoftGraphLicenseDetails> licenseDetails() {
        return this.licenseDetails;
    }

    /**
     * Set the licenseDetails property: A collection of this user's license details. Read-only.
     * 
     * @param licenseDetails the licenseDetails value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withLicenseDetails(List<MicrosoftGraphLicenseDetails> licenseDetails) {
        this.licenseDetails = licenseDetails;
        return this;
    }

    /**
     * Get the manager property: Represents an Azure Active Directory object. The directoryObject type is the base type
     * for many other directory entity types.
     * 
     * @return the manager value.
     */
    public MicrosoftGraphDirectoryObjectInner manager() {
        return this.manager;
    }

    /**
     * Set the manager property: Represents an Azure Active Directory object. The directoryObject type is the base type
     * for many other directory entity types.
     * 
     * @param manager the manager value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withManager(MicrosoftGraphDirectoryObjectInner manager) {
        this.manager = manager;
        return this;
    }

    /**
     * Get the memberOf property: The groups and directory roles that the user is a member of. Read-only. Nullable.
     * 
     * @return the memberOf value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> memberOf() {
        return this.memberOf;
    }

    /**
     * Set the memberOf property: The groups and directory roles that the user is a member of. Read-only. Nullable.
     * 
     * @param memberOf the memberOf value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withMemberOf(List<MicrosoftGraphDirectoryObjectInner> memberOf) {
        this.memberOf = memberOf;
        return this;
    }

    /**
     * Get the oauth2PermissionGrants property: The oauth2PermissionGrants property.
     * 
     * @return the oauth2PermissionGrants value.
     */
    public List<MicrosoftGraphOAuth2PermissionGrant> oauth2PermissionGrants() {
        return this.oauth2PermissionGrants;
    }

    /**
     * Set the oauth2PermissionGrants property: The oauth2PermissionGrants property.
     * 
     * @param oauth2PermissionGrants the oauth2PermissionGrants value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner
        withOauth2PermissionGrants(List<MicrosoftGraphOAuth2PermissionGrant> oauth2PermissionGrants) {
        this.oauth2PermissionGrants = oauth2PermissionGrants;
        return this;
    }

    /**
     * Get the ownedDevices property: Devices that are owned by the user. Read-only. Nullable.
     * 
     * @return the ownedDevices value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> ownedDevices() {
        return this.ownedDevices;
    }

    /**
     * Set the ownedDevices property: Devices that are owned by the user. Read-only. Nullable.
     * 
     * @param ownedDevices the ownedDevices value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withOwnedDevices(List<MicrosoftGraphDirectoryObjectInner> ownedDevices) {
        this.ownedDevices = ownedDevices;
        return this;
    }

    /**
     * Get the ownedObjects property: Directory objects that are owned by the user. Read-only. Nullable.
     * 
     * @return the ownedObjects value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> ownedObjects() {
        return this.ownedObjects;
    }

    /**
     * Set the ownedObjects property: Directory objects that are owned by the user. Read-only. Nullable.
     * 
     * @param ownedObjects the ownedObjects value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withOwnedObjects(List<MicrosoftGraphDirectoryObjectInner> ownedObjects) {
        this.ownedObjects = ownedObjects;
        return this;
    }

    /**
     * Get the registeredDevices property: Devices that are registered for the user. Read-only. Nullable.
     * 
     * @return the registeredDevices value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> registeredDevices() {
        return this.registeredDevices;
    }

    /**
     * Set the registeredDevices property: Devices that are registered for the user. Read-only. Nullable.
     * 
     * @param registeredDevices the registeredDevices value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withRegisteredDevices(List<MicrosoftGraphDirectoryObjectInner> registeredDevices) {
        this.registeredDevices = registeredDevices;
        return this;
    }

    /**
     * Get the scopedRoleMemberOf property: The scopedRoleMemberOf property.
     * 
     * @return the scopedRoleMemberOf value.
     */
    public List<MicrosoftGraphScopedRoleMembership> scopedRoleMemberOf() {
        return this.scopedRoleMemberOf;
    }

    /**
     * Set the scopedRoleMemberOf property: The scopedRoleMemberOf property.
     * 
     * @param scopedRoleMemberOf the scopedRoleMemberOf value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withScopedRoleMemberOf(List<MicrosoftGraphScopedRoleMembership> scopedRoleMemberOf) {
        this.scopedRoleMemberOf = scopedRoleMemberOf;
        return this;
    }

    /**
     * Get the transitiveMemberOf property: The transitiveMemberOf property.
     * 
     * @return the transitiveMemberOf value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> transitiveMemberOf() {
        return this.transitiveMemberOf;
    }

    /**
     * Set the transitiveMemberOf property: The transitiveMemberOf property.
     * 
     * @param transitiveMemberOf the transitiveMemberOf value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withTransitiveMemberOf(List<MicrosoftGraphDirectoryObjectInner> transitiveMemberOf) {
        this.transitiveMemberOf = transitiveMemberOf;
        return this;
    }

    /**
     * Get the calendar property: calendar.
     * 
     * @return the calendar value.
     */
    public MicrosoftGraphCalendar calendar() {
        return this.calendar;
    }

    /**
     * Set the calendar property: calendar.
     * 
     * @param calendar the calendar value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withCalendar(MicrosoftGraphCalendar calendar) {
        this.calendar = calendar;
        return this;
    }

    /**
     * Get the calendarGroups property: The user's calendar groups. Read-only. Nullable.
     * 
     * @return the calendarGroups value.
     */
    public List<MicrosoftGraphCalendarGroup> calendarGroups() {
        return this.calendarGroups;
    }

    /**
     * Set the calendarGroups property: The user's calendar groups. Read-only. Nullable.
     * 
     * @param calendarGroups the calendarGroups value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withCalendarGroups(List<MicrosoftGraphCalendarGroup> calendarGroups) {
        this.calendarGroups = calendarGroups;
        return this;
    }

    /**
     * Get the calendars property: The user's calendars. Read-only. Nullable.
     * 
     * @return the calendars value.
     */
    public List<MicrosoftGraphCalendar> calendars() {
        return this.calendars;
    }

    /**
     * Set the calendars property: The user's calendars. Read-only. Nullable.
     * 
     * @param calendars the calendars value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withCalendars(List<MicrosoftGraphCalendar> calendars) {
        this.calendars = calendars;
        return this;
    }

    /**
     * Get the calendarView property: The calendar view for the calendar. Read-only. Nullable.
     * 
     * @return the calendarView value.
     */
    public List<MicrosoftGraphEvent> calendarView() {
        return this.calendarView;
    }

    /**
     * Set the calendarView property: The calendar view for the calendar. Read-only. Nullable.
     * 
     * @param calendarView the calendarView value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withCalendarView(List<MicrosoftGraphEvent> calendarView) {
        this.calendarView = calendarView;
        return this;
    }

    /**
     * Get the contactFolders property: The user's contacts folders. Read-only. Nullable.
     * 
     * @return the contactFolders value.
     */
    public List<MicrosoftGraphContactFolder> contactFolders() {
        return this.contactFolders;
    }

    /**
     * Set the contactFolders property: The user's contacts folders. Read-only. Nullable.
     * 
     * @param contactFolders the contactFolders value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withContactFolders(List<MicrosoftGraphContactFolder> contactFolders) {
        this.contactFolders = contactFolders;
        return this;
    }

    /**
     * Get the contacts property: The user's contacts. Read-only. Nullable.
     * 
     * @return the contacts value.
     */
    public List<MicrosoftGraphContact> contacts() {
        return this.contacts;
    }

    /**
     * Set the contacts property: The user's contacts. Read-only. Nullable.
     * 
     * @param contacts the contacts value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withContacts(List<MicrosoftGraphContact> contacts) {
        this.contacts = contacts;
        return this;
    }

    /**
     * Get the events property: The user's events. Default is to show Events under the Default Calendar. Read-only.
     * Nullable.
     * 
     * @return the events value.
     */
    public List<MicrosoftGraphEvent> events() {
        return this.events;
    }

    /**
     * Set the events property: The user's events. Default is to show Events under the Default Calendar. Read-only.
     * Nullable.
     * 
     * @param events the events value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withEvents(List<MicrosoftGraphEvent> events) {
        this.events = events;
        return this;
    }

    /**
     * Get the inferenceClassification property: inferenceClassification.
     * 
     * @return the inferenceClassification value.
     */
    public MicrosoftGraphInferenceClassification inferenceClassification() {
        return this.inferenceClassification;
    }

    /**
     * Set the inferenceClassification property: inferenceClassification.
     * 
     * @param inferenceClassification the inferenceClassification value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner
        withInferenceClassification(MicrosoftGraphInferenceClassification inferenceClassification) {
        this.inferenceClassification = inferenceClassification;
        return this;
    }

    /**
     * Get the mailFolders property: The user's mail folders. Read-only. Nullable.
     * 
     * @return the mailFolders value.
     */
    public List<MicrosoftGraphMailFolder> mailFolders() {
        return this.mailFolders;
    }

    /**
     * Set the mailFolders property: The user's mail folders. Read-only. Nullable.
     * 
     * @param mailFolders the mailFolders value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withMailFolders(List<MicrosoftGraphMailFolder> mailFolders) {
        this.mailFolders = mailFolders;
        return this;
    }

    /**
     * Get the messages property: The messages in a mailbox or folder. Read-only. Nullable.
     * 
     * @return the messages value.
     */
    public List<MicrosoftGraphMessage> messages() {
        return this.messages;
    }

    /**
     * Set the messages property: The messages in a mailbox or folder. Read-only. Nullable.
     * 
     * @param messages the messages value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withMessages(List<MicrosoftGraphMessage> messages) {
        this.messages = messages;
        return this;
    }

    /**
     * Get the outlook property: outlookUser.
     * 
     * @return the outlook value.
     */
    public MicrosoftGraphOutlookUser outlook() {
        return this.outlook;
    }

    /**
     * Set the outlook property: outlookUser.
     * 
     * @param outlook the outlook value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withOutlook(MicrosoftGraphOutlookUser outlook) {
        this.outlook = outlook;
        return this;
    }

    /**
     * Get the people property: People that are relevant to the user. Read-only. Nullable.
     * 
     * @return the people value.
     */
    public List<MicrosoftGraphPerson> people() {
        return this.people;
    }

    /**
     * Set the people property: People that are relevant to the user. Read-only. Nullable.
     * 
     * @param people the people value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withPeople(List<MicrosoftGraphPerson> people) {
        this.people = people;
        return this;
    }

    /**
     * Get the photo property: profilePhoto.
     * 
     * @return the photo value.
     */
    public MicrosoftGraphProfilePhoto photo() {
        return this.photo;
    }

    /**
     * Set the photo property: profilePhoto.
     * 
     * @param photo the photo value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withPhoto(MicrosoftGraphProfilePhoto photo) {
        this.photo = photo;
        return this;
    }

    /**
     * Get the photos property: The photos property.
     * 
     * @return the photos value.
     */
    public List<MicrosoftGraphProfilePhoto> photos() {
        return this.photos;
    }

    /**
     * Set the photos property: The photos property.
     * 
     * @param photos the photos value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withPhotos(List<MicrosoftGraphProfilePhoto> photos) {
        this.photos = photos;
        return this;
    }

    /**
     * Get the drive property: drive.
     * 
     * @return the drive value.
     */
    public MicrosoftGraphDrive drive() {
        return this.drive;
    }

    /**
     * Set the drive property: drive.
     * 
     * @param drive the drive value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withDrive(MicrosoftGraphDrive drive) {
        this.drive = drive;
        return this;
    }

    /**
     * Get the drives property: A collection of drives available for this user. Read-only.
     * 
     * @return the drives value.
     */
    public List<MicrosoftGraphDrive> drives() {
        return this.drives;
    }

    /**
     * Set the drives property: A collection of drives available for this user. Read-only.
     * 
     * @param drives the drives value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withDrives(List<MicrosoftGraphDrive> drives) {
        this.drives = drives;
        return this;
    }

    /**
     * Get the followedSites property: The followedSites property.
     * 
     * @return the followedSites value.
     */
    public List<MicrosoftGraphSite> followedSites() {
        return this.followedSites;
    }

    /**
     * Set the followedSites property: The followedSites property.
     * 
     * @param followedSites the followedSites value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withFollowedSites(List<MicrosoftGraphSite> followedSites) {
        this.followedSites = followedSites;
        return this;
    }

    /**
     * Get the extensions property: The collection of open extensions defined for the user. Read-only. Nullable.
     * 
     * @return the extensions value.
     */
    public List<MicrosoftGraphExtension> extensions() {
        return this.extensions;
    }

    /**
     * Set the extensions property: The collection of open extensions defined for the user. Read-only. Nullable.
     * 
     * @param extensions the extensions value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withExtensions(List<MicrosoftGraphExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    /**
     * Get the managedDevices property: The managed devices associated with the user.
     * 
     * @return the managedDevices value.
     */
    public List<MicrosoftGraphManagedDevice> managedDevices() {
        return this.managedDevices;
    }

    /**
     * Set the managedDevices property: The managed devices associated with the user.
     * 
     * @param managedDevices the managedDevices value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withManagedDevices(List<MicrosoftGraphManagedDevice> managedDevices) {
        this.managedDevices = managedDevices;
        return this;
    }

    /**
     * Get the managedAppRegistrations property: Zero or more managed app registrations that belong to the user.
     * 
     * @return the managedAppRegistrations value.
     */
    public List<MicrosoftGraphManagedAppRegistration> managedAppRegistrations() {
        return this.managedAppRegistrations;
    }

    /**
     * Set the managedAppRegistrations property: Zero or more managed app registrations that belong to the user.
     * 
     * @param managedAppRegistrations the managedAppRegistrations value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner
        withManagedAppRegistrations(List<MicrosoftGraphManagedAppRegistration> managedAppRegistrations) {
        this.managedAppRegistrations = managedAppRegistrations;
        return this;
    }

    /**
     * Get the deviceManagementTroubleshootingEvents property: The list of troubleshooting events for this user.
     * 
     * @return the deviceManagementTroubleshootingEvents value.
     */
    public List<MicrosoftGraphDeviceManagementTroubleshootingEvent> deviceManagementTroubleshootingEvents() {
        return this.deviceManagementTroubleshootingEvents;
    }

    /**
     * Set the deviceManagementTroubleshootingEvents property: The list of troubleshooting events for this user.
     * 
     * @param deviceManagementTroubleshootingEvents the deviceManagementTroubleshootingEvents value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withDeviceManagementTroubleshootingEvents(
        List<MicrosoftGraphDeviceManagementTroubleshootingEvent> deviceManagementTroubleshootingEvents) {
        this.deviceManagementTroubleshootingEvents = deviceManagementTroubleshootingEvents;
        return this;
    }

    /**
     * Get the planner property: plannerUser.
     * 
     * @return the planner value.
     */
    public MicrosoftGraphPlannerUser planner() {
        return this.planner;
    }

    /**
     * Set the planner property: plannerUser.
     * 
     * @param planner the planner value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withPlanner(MicrosoftGraphPlannerUser planner) {
        this.planner = planner;
        return this;
    }

    /**
     * Get the insights property: officeGraphInsights.
     * 
     * @return the insights value.
     */
    public MicrosoftGraphOfficeGraphInsights insights() {
        return this.insights;
    }

    /**
     * Set the insights property: officeGraphInsights.
     * 
     * @param insights the insights value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withInsights(MicrosoftGraphOfficeGraphInsights insights) {
        this.insights = insights;
        return this;
    }

    /**
     * Get the settings property: userSettings.
     * 
     * @return the settings value.
     */
    public MicrosoftGraphUserSettings settings() {
        return this.settings;
    }

    /**
     * Set the settings property: userSettings.
     * 
     * @param settings the settings value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withSettings(MicrosoftGraphUserSettings settings) {
        this.settings = settings;
        return this;
    }

    /**
     * Get the onenote property: onenote.
     * 
     * @return the onenote value.
     */
    public MicrosoftGraphOnenote onenote() {
        return this.onenote;
    }

    /**
     * Set the onenote property: onenote.
     * 
     * @param onenote the onenote value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withOnenote(MicrosoftGraphOnenote onenote) {
        this.onenote = onenote;
        return this;
    }

    /**
     * Get the activities property: The user's activities across devices. Read-only. Nullable.
     * 
     * @return the activities value.
     */
    public List<MicrosoftGraphUserActivity> activities() {
        return this.activities;
    }

    /**
     * Set the activities property: The user's activities across devices. Read-only. Nullable.
     * 
     * @param activities the activities value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withActivities(List<MicrosoftGraphUserActivity> activities) {
        this.activities = activities;
        return this;
    }

    /**
     * Get the onlineMeetings property: The onlineMeetings property.
     * 
     * @return the onlineMeetings value.
     */
    public List<MicrosoftGraphOnlineMeeting> onlineMeetings() {
        return this.onlineMeetings;
    }

    /**
     * Set the onlineMeetings property: The onlineMeetings property.
     * 
     * @param onlineMeetings the onlineMeetings value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withOnlineMeetings(List<MicrosoftGraphOnlineMeeting> onlineMeetings) {
        this.onlineMeetings = onlineMeetings;
        return this;
    }

    /**
     * Get the presence property: presence.
     * 
     * @return the presence value.
     */
    public MicrosoftGraphPresence presence() {
        return this.presence;
    }

    /**
     * Set the presence property: presence.
     * 
     * @param presence the presence value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withPresence(MicrosoftGraphPresence presence) {
        this.presence = presence;
        return this;
    }

    /**
     * Get the joinedTeams property: The joinedTeams property.
     * 
     * @return the joinedTeams value.
     */
    public List<MicrosoftGraphTeamInner> joinedTeams() {
        return this.joinedTeams;
    }

    /**
     * Set the joinedTeams property: The joinedTeams property.
     * 
     * @param joinedTeams the joinedTeams value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withJoinedTeams(List<MicrosoftGraphTeamInner> joinedTeams) {
        this.joinedTeams = joinedTeams;
        return this;
    }

    /**
     * Get the teamwork property: userTeamwork.
     * 
     * @return the teamwork value.
     */
    public MicrosoftGraphUserTeamwork teamwork() {
        return this.teamwork;
    }

    /**
     * Set the teamwork property: userTeamwork.
     * 
     * @param teamwork the teamwork value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withTeamwork(MicrosoftGraphUserTeamwork teamwork) {
        this.teamwork = teamwork;
        return this;
    }

    /**
     * Get the todo property: todo.
     * 
     * @return the todo value.
     */
    public MicrosoftGraphTodo todo() {
        return this.todo;
    }

    /**
     * Set the todo property: todo.
     * 
     * @param todo the todo value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withTodo(MicrosoftGraphTodo todo) {
        this.todo = todo;
        return this;
    }

    /**
     * Get the additionalProperties property: Represents an Azure Active Directory user object.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Represents an Azure Active Directory user object.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphUserInner object itself.
     */
    public MicrosoftGraphUserInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphUserInner withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphUserInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (assignedLicenses() != null) {
            assignedLicenses().forEach(e -> e.validate());
        }
        if (assignedPlans() != null) {
            assignedPlans().forEach(e -> e.validate());
        }
        if (employeeOrgData() != null) {
            employeeOrgData().validate();
        }
        if (identities() != null) {
            identities().forEach(e -> e.validate());
        }
        if (licenseAssignmentStates() != null) {
            licenseAssignmentStates().forEach(e -> e.validate());
        }
        if (onPremisesExtensionAttributes() != null) {
            onPremisesExtensionAttributes().validate();
        }
        if (onPremisesProvisioningErrors() != null) {
            onPremisesProvisioningErrors().forEach(e -> e.validate());
        }
        if (passwordProfile() != null) {
            passwordProfile().validate();
        }
        if (provisionedPlans() != null) {
            provisionedPlans().forEach(e -> e.validate());
        }
        if (mailboxSettings() != null) {
            mailboxSettings().validate();
        }
        if (appRoleAssignments() != null) {
            appRoleAssignments().forEach(e -> e.validate());
        }
        if (createdObjects() != null) {
            createdObjects().forEach(e -> e.validate());
        }
        if (directReports() != null) {
            directReports().forEach(e -> e.validate());
        }
        if (licenseDetails() != null) {
            licenseDetails().forEach(e -> e.validate());
        }
        if (manager() != null) {
            manager().validate();
        }
        if (memberOf() != null) {
            memberOf().forEach(e -> e.validate());
        }
        if (oauth2PermissionGrants() != null) {
            oauth2PermissionGrants().forEach(e -> e.validate());
        }
        if (ownedDevices() != null) {
            ownedDevices().forEach(e -> e.validate());
        }
        if (ownedObjects() != null) {
            ownedObjects().forEach(e -> e.validate());
        }
        if (registeredDevices() != null) {
            registeredDevices().forEach(e -> e.validate());
        }
        if (scopedRoleMemberOf() != null) {
            scopedRoleMemberOf().forEach(e -> e.validate());
        }
        if (transitiveMemberOf() != null) {
            transitiveMemberOf().forEach(e -> e.validate());
        }
        if (calendar() != null) {
            calendar().validate();
        }
        if (calendarGroups() != null) {
            calendarGroups().forEach(e -> e.validate());
        }
        if (calendars() != null) {
            calendars().forEach(e -> e.validate());
        }
        if (calendarView() != null) {
            calendarView().forEach(e -> e.validate());
        }
        if (contactFolders() != null) {
            contactFolders().forEach(e -> e.validate());
        }
        if (contacts() != null) {
            contacts().forEach(e -> e.validate());
        }
        if (events() != null) {
            events().forEach(e -> e.validate());
        }
        if (inferenceClassification() != null) {
            inferenceClassification().validate();
        }
        if (mailFolders() != null) {
            mailFolders().forEach(e -> e.validate());
        }
        if (messages() != null) {
            messages().forEach(e -> e.validate());
        }
        if (outlook() != null) {
            outlook().validate();
        }
        if (people() != null) {
            people().forEach(e -> e.validate());
        }
        if (photo() != null) {
            photo().validate();
        }
        if (photos() != null) {
            photos().forEach(e -> e.validate());
        }
        if (drive() != null) {
            drive().validate();
        }
        if (drives() != null) {
            drives().forEach(e -> e.validate());
        }
        if (followedSites() != null) {
            followedSites().forEach(e -> e.validate());
        }
        if (extensions() != null) {
            extensions().forEach(e -> e.validate());
        }
        if (managedDevices() != null) {
            managedDevices().forEach(e -> e.validate());
        }
        if (managedAppRegistrations() != null) {
            managedAppRegistrations().forEach(e -> e.validate());
        }
        if (deviceManagementTroubleshootingEvents() != null) {
            deviceManagementTroubleshootingEvents().forEach(e -> e.validate());
        }
        if (planner() != null) {
            planner().validate();
        }
        if (insights() != null) {
            insights().validate();
        }
        if (settings() != null) {
            settings().validate();
        }
        if (onenote() != null) {
            onenote().validate();
        }
        if (activities() != null) {
            activities().forEach(e -> e.validate());
        }
        if (onlineMeetings() != null) {
            onlineMeetings().forEach(e -> e.validate());
        }
        if (presence() != null) {
            presence().validate();
        }
        if (joinedTeams() != null) {
            joinedTeams().forEach(e -> e.validate());
        }
        if (teamwork() != null) {
            teamwork().validate();
        }
        if (todo() != null) {
            todo().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("deletedDateTime",
            deletedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(deletedDateTime()));
        jsonWriter.writeBooleanField("accountEnabled", this.accountEnabled);
        jsonWriter.writeStringField("ageGroup", this.ageGroup);
        jsonWriter.writeArrayField("assignedLicenses", this.assignedLicenses,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("assignedPlans", this.assignedPlans, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("businessPhones", this.businessPhones,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("city", this.city);
        jsonWriter.writeStringField("companyName", this.companyName);
        jsonWriter.writeStringField("consentProvidedForMinor", this.consentProvidedForMinor);
        jsonWriter.writeStringField("country", this.country);
        jsonWriter.writeStringField("createdDateTime",
            this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("creationType", this.creationType);
        jsonWriter.writeStringField("department", this.department);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("employeeHireDate",
            this.employeeHireDate == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.employeeHireDate));
        jsonWriter.writeStringField("employeeId", this.employeeId);
        jsonWriter.writeJsonField("employeeOrgData", this.employeeOrgData);
        jsonWriter.writeStringField("employeeType", this.employeeType);
        jsonWriter.writeStringField("externalUserState", this.externalUserState);
        jsonWriter.writeStringField("externalUserStateChangeDateTime",
            this.externalUserStateChangeDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.externalUserStateChangeDateTime));
        jsonWriter.writeStringField("faxNumber", this.faxNumber);
        jsonWriter.writeStringField("givenName", this.givenName);
        jsonWriter.writeArrayField("identities", this.identities, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("imAddresses", this.imAddresses, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isResourceAccount", this.isResourceAccount);
        jsonWriter.writeStringField("jobTitle", this.jobTitle);
        jsonWriter.writeStringField("lastPasswordChangeDateTime",
            this.lastPasswordChangeDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastPasswordChangeDateTime));
        jsonWriter.writeStringField("legalAgeGroupClassification", this.legalAgeGroupClassification);
        jsonWriter.writeArrayField("licenseAssignmentStates", this.licenseAssignmentStates,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("mail", this.mail);
        jsonWriter.writeStringField("mailNickname", this.mailNickname);
        jsonWriter.writeStringField("mobilePhone", this.mobilePhone);
        jsonWriter.writeStringField("officeLocation", this.officeLocation);
        jsonWriter.writeStringField("onPremisesDistinguishedName", this.onPremisesDistinguishedName);
        jsonWriter.writeStringField("onPremisesDomainName", this.onPremisesDomainName);
        jsonWriter.writeJsonField("onPremisesExtensionAttributes", this.onPremisesExtensionAttributes);
        jsonWriter.writeStringField("onPremisesImmutableId", this.onPremisesImmutableId);
        jsonWriter.writeStringField("onPremisesLastSyncDateTime",
            this.onPremisesLastSyncDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.onPremisesLastSyncDateTime));
        jsonWriter.writeArrayField("onPremisesProvisioningErrors", this.onPremisesProvisioningErrors,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("onPremisesSamAccountName", this.onPremisesSamAccountName);
        jsonWriter.writeStringField("onPremisesSecurityIdentifier", this.onPremisesSecurityIdentifier);
        jsonWriter.writeBooleanField("onPremisesSyncEnabled", this.onPremisesSyncEnabled);
        jsonWriter.writeStringField("onPremisesUserPrincipalName", this.onPremisesUserPrincipalName);
        jsonWriter.writeArrayField("otherMails", this.otherMails, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("passwordPolicies", this.passwordPolicies);
        jsonWriter.writeJsonField("passwordProfile", this.passwordProfile);
        jsonWriter.writeStringField("postalCode", this.postalCode);
        jsonWriter.writeStringField("preferredLanguage", this.preferredLanguage);
        jsonWriter.writeArrayField("provisionedPlans", this.provisionedPlans,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("proxyAddresses", this.proxyAddresses,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("showInAddressList", this.showInAddressList);
        jsonWriter.writeStringField("signInSessionsValidFromDateTime",
            this.signInSessionsValidFromDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.signInSessionsValidFromDateTime));
        jsonWriter.writeStringField("state", this.state);
        jsonWriter.writeStringField("streetAddress", this.streetAddress);
        jsonWriter.writeStringField("surname", this.surname);
        jsonWriter.writeStringField("usageLocation", this.usageLocation);
        jsonWriter.writeStringField("userPrincipalName", this.userPrincipalName);
        jsonWriter.writeStringField("userType", this.userType);
        jsonWriter.writeJsonField("mailboxSettings", this.mailboxSettings);
        jsonWriter.writeNumberField("deviceEnrollmentLimit", this.deviceEnrollmentLimit);
        jsonWriter.writeStringField("aboutMe", this.aboutMe);
        jsonWriter.writeStringField("birthday",
            this.birthday == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.birthday));
        jsonWriter.writeStringField("hireDate",
            this.hireDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.hireDate));
        jsonWriter.writeArrayField("interests", this.interests, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("mySite", this.mySite);
        jsonWriter.writeArrayField("pastProjects", this.pastProjects, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("preferredName", this.preferredName);
        jsonWriter.writeArrayField("responsibilities", this.responsibilities,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("schools", this.schools, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("skills", this.skills, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("appRoleAssignments", this.appRoleAssignments,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("createdObjects", this.createdObjects,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("directReports", this.directReports, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("licenseDetails", this.licenseDetails,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("manager", this.manager);
        jsonWriter.writeArrayField("memberOf", this.memberOf, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("oauth2PermissionGrants", this.oauth2PermissionGrants,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("ownedDevices", this.ownedDevices, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("ownedObjects", this.ownedObjects, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("registeredDevices", this.registeredDevices,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("scopedRoleMemberOf", this.scopedRoleMemberOf,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("transitiveMemberOf", this.transitiveMemberOf,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("calendar", this.calendar);
        jsonWriter.writeArrayField("calendarGroups", this.calendarGroups,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("calendars", this.calendars, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("calendarView", this.calendarView, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("contactFolders", this.contactFolders,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("contacts", this.contacts, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("events", this.events, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("inferenceClassification", this.inferenceClassification);
        jsonWriter.writeArrayField("mailFolders", this.mailFolders, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("messages", this.messages, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("outlook", this.outlook);
        jsonWriter.writeArrayField("people", this.people, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("photo", this.photo);
        jsonWriter.writeArrayField("photos", this.photos, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("drive", this.drive);
        jsonWriter.writeArrayField("drives", this.drives, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("followedSites", this.followedSites, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("managedDevices", this.managedDevices,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("managedAppRegistrations", this.managedAppRegistrations,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("deviceManagementTroubleshootingEvents", this.deviceManagementTroubleshootingEvents,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("planner", this.planner);
        jsonWriter.writeJsonField("insights", this.insights);
        jsonWriter.writeJsonField("settings", this.settings);
        jsonWriter.writeJsonField("onenote", this.onenote);
        jsonWriter.writeArrayField("activities", this.activities, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("onlineMeetings", this.onlineMeetings,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("presence", this.presence);
        jsonWriter.writeArrayField("joinedTeams", this.joinedTeams, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("teamwork", this.teamwork);
        jsonWriter.writeJsonField("todo", this.todo);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphUserInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphUserInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphUserInner.
     */
    public static MicrosoftGraphUserInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphUserInner deserializedMicrosoftGraphUserInner = new MicrosoftGraphUserInner();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.withId(reader.getString());
                } else if ("deletedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.withDeletedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("accountEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.accountEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("ageGroup".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.ageGroup = reader.getString();
                } else if ("assignedLicenses".equals(fieldName)) {
                    List<MicrosoftGraphAssignedLicense> assignedLicenses
                        = reader.readArray(reader1 -> MicrosoftGraphAssignedLicense.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.assignedLicenses = assignedLicenses;
                } else if ("assignedPlans".equals(fieldName)) {
                    List<MicrosoftGraphAssignedPlan> assignedPlans
                        = reader.readArray(reader1 -> MicrosoftGraphAssignedPlan.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.assignedPlans = assignedPlans;
                } else if ("businessPhones".equals(fieldName)) {
                    List<String> businessPhones = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphUserInner.businessPhones = businessPhones;
                } else if ("city".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.city = reader.getString();
                } else if ("companyName".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.companyName = reader.getString();
                } else if ("consentProvidedForMinor".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.consentProvidedForMinor = reader.getString();
                } else if ("country".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.country = reader.getString();
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.createdDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("creationType".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.creationType = reader.getString();
                } else if ("department".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.department = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.displayName = reader.getString();
                } else if ("employeeHireDate".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.employeeHireDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("employeeId".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.employeeId = reader.getString();
                } else if ("employeeOrgData".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.employeeOrgData
                        = MicrosoftGraphEmployeeOrgData.fromJson(reader);
                } else if ("employeeType".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.employeeType = reader.getString();
                } else if ("externalUserState".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.externalUserState = reader.getString();
                } else if ("externalUserStateChangeDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.externalUserStateChangeDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("faxNumber".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.faxNumber = reader.getString();
                } else if ("givenName".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.givenName = reader.getString();
                } else if ("identities".equals(fieldName)) {
                    List<MicrosoftGraphObjectIdentity> identities
                        = reader.readArray(reader1 -> MicrosoftGraphObjectIdentity.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.identities = identities;
                } else if ("imAddresses".equals(fieldName)) {
                    List<String> imAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphUserInner.imAddresses = imAddresses;
                } else if ("isResourceAccount".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.isResourceAccount = reader.getNullable(JsonReader::getBoolean);
                } else if ("jobTitle".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.jobTitle = reader.getString();
                } else if ("lastPasswordChangeDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.lastPasswordChangeDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("legalAgeGroupClassification".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.legalAgeGroupClassification = reader.getString();
                } else if ("licenseAssignmentStates".equals(fieldName)) {
                    List<MicrosoftGraphLicenseAssignmentState> licenseAssignmentStates
                        = reader.readArray(reader1 -> MicrosoftGraphLicenseAssignmentState.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.licenseAssignmentStates = licenseAssignmentStates;
                } else if ("mail".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.mail = reader.getString();
                } else if ("mailNickname".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.mailNickname = reader.getString();
                } else if ("mobilePhone".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.mobilePhone = reader.getString();
                } else if ("officeLocation".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.officeLocation = reader.getString();
                } else if ("onPremisesDistinguishedName".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.onPremisesDistinguishedName = reader.getString();
                } else if ("onPremisesDomainName".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.onPremisesDomainName = reader.getString();
                } else if ("onPremisesExtensionAttributes".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.onPremisesExtensionAttributes
                        = MicrosoftGraphOnPremisesExtensionAttributes.fromJson(reader);
                } else if ("onPremisesImmutableId".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.onPremisesImmutableId = reader.getString();
                } else if ("onPremisesLastSyncDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.onPremisesLastSyncDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("onPremisesProvisioningErrors".equals(fieldName)) {
                    List<MicrosoftGraphOnPremisesProvisioningError> onPremisesProvisioningErrors
                        = reader.readArray(reader1 -> MicrosoftGraphOnPremisesProvisioningError.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.onPremisesProvisioningErrors = onPremisesProvisioningErrors;
                } else if ("onPremisesSamAccountName".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.onPremisesSamAccountName = reader.getString();
                } else if ("onPremisesSecurityIdentifier".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.onPremisesSecurityIdentifier = reader.getString();
                } else if ("onPremisesSyncEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.onPremisesSyncEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("onPremisesUserPrincipalName".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.onPremisesUserPrincipalName = reader.getString();
                } else if ("otherMails".equals(fieldName)) {
                    List<String> otherMails = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphUserInner.otherMails = otherMails;
                } else if ("passwordPolicies".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.passwordPolicies = reader.getString();
                } else if ("passwordProfile".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.passwordProfile
                        = MicrosoftGraphPasswordProfile.fromJson(reader);
                } else if ("postalCode".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.postalCode = reader.getString();
                } else if ("preferredLanguage".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.preferredLanguage = reader.getString();
                } else if ("provisionedPlans".equals(fieldName)) {
                    List<MicrosoftGraphProvisionedPlan> provisionedPlans
                        = reader.readArray(reader1 -> MicrosoftGraphProvisionedPlan.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.provisionedPlans = provisionedPlans;
                } else if ("proxyAddresses".equals(fieldName)) {
                    List<String> proxyAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphUserInner.proxyAddresses = proxyAddresses;
                } else if ("showInAddressList".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.showInAddressList = reader.getNullable(JsonReader::getBoolean);
                } else if ("signInSessionsValidFromDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.signInSessionsValidFromDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("state".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.state = reader.getString();
                } else if ("streetAddress".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.streetAddress = reader.getString();
                } else if ("surname".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.surname = reader.getString();
                } else if ("usageLocation".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.usageLocation = reader.getString();
                } else if ("userPrincipalName".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.userPrincipalName = reader.getString();
                } else if ("userType".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.userType = reader.getString();
                } else if ("mailboxSettings".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.mailboxSettings
                        = MicrosoftGraphMailboxSettings.fromJson(reader);
                } else if ("deviceEnrollmentLimit".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.deviceEnrollmentLimit = reader.getNullable(JsonReader::getInt);
                } else if ("aboutMe".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.aboutMe = reader.getString();
                } else if ("birthday".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.birthday = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("hireDate".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.hireDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("interests".equals(fieldName)) {
                    List<String> interests = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphUserInner.interests = interests;
                } else if ("mySite".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.mySite = reader.getString();
                } else if ("pastProjects".equals(fieldName)) {
                    List<String> pastProjects = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphUserInner.pastProjects = pastProjects;
                } else if ("preferredName".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.preferredName = reader.getString();
                } else if ("responsibilities".equals(fieldName)) {
                    List<String> responsibilities = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphUserInner.responsibilities = responsibilities;
                } else if ("schools".equals(fieldName)) {
                    List<String> schools = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphUserInner.schools = schools;
                } else if ("skills".equals(fieldName)) {
                    List<String> skills = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphUserInner.skills = skills;
                } else if ("appRoleAssignments".equals(fieldName)) {
                    List<MicrosoftGraphAppRoleAssignment> appRoleAssignments
                        = reader.readArray(reader1 -> MicrosoftGraphAppRoleAssignment.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.appRoleAssignments = appRoleAssignments;
                } else if ("createdObjects".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> createdObjects
                        = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.createdObjects = createdObjects;
                } else if ("directReports".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> directReports
                        = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.directReports = directReports;
                } else if ("licenseDetails".equals(fieldName)) {
                    List<MicrosoftGraphLicenseDetails> licenseDetails
                        = reader.readArray(reader1 -> MicrosoftGraphLicenseDetails.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.licenseDetails = licenseDetails;
                } else if ("manager".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.manager = MicrosoftGraphDirectoryObjectInner.fromJson(reader);
                } else if ("memberOf".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> memberOf
                        = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.memberOf = memberOf;
                } else if ("oauth2PermissionGrants".equals(fieldName)) {
                    List<MicrosoftGraphOAuth2PermissionGrant> oauth2PermissionGrants
                        = reader.readArray(reader1 -> MicrosoftGraphOAuth2PermissionGrant.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.oauth2PermissionGrants = oauth2PermissionGrants;
                } else if ("ownedDevices".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> ownedDevices
                        = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.ownedDevices = ownedDevices;
                } else if ("ownedObjects".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> ownedObjects
                        = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.ownedObjects = ownedObjects;
                } else if ("registeredDevices".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> registeredDevices
                        = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.registeredDevices = registeredDevices;
                } else if ("scopedRoleMemberOf".equals(fieldName)) {
                    List<MicrosoftGraphScopedRoleMembership> scopedRoleMemberOf
                        = reader.readArray(reader1 -> MicrosoftGraphScopedRoleMembership.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.scopedRoleMemberOf = scopedRoleMemberOf;
                } else if ("transitiveMemberOf".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> transitiveMemberOf
                        = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.transitiveMemberOf = transitiveMemberOf;
                } else if ("calendar".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.calendar = MicrosoftGraphCalendar.fromJson(reader);
                } else if ("calendarGroups".equals(fieldName)) {
                    List<MicrosoftGraphCalendarGroup> calendarGroups
                        = reader.readArray(reader1 -> MicrosoftGraphCalendarGroup.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.calendarGroups = calendarGroups;
                } else if ("calendars".equals(fieldName)) {
                    List<MicrosoftGraphCalendar> calendars
                        = reader.readArray(reader1 -> MicrosoftGraphCalendar.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.calendars = calendars;
                } else if ("calendarView".equals(fieldName)) {
                    List<MicrosoftGraphEvent> calendarView
                        = reader.readArray(reader1 -> MicrosoftGraphEvent.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.calendarView = calendarView;
                } else if ("contactFolders".equals(fieldName)) {
                    List<MicrosoftGraphContactFolder> contactFolders
                        = reader.readArray(reader1 -> MicrosoftGraphContactFolder.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.contactFolders = contactFolders;
                } else if ("contacts".equals(fieldName)) {
                    List<MicrosoftGraphContact> contacts
                        = reader.readArray(reader1 -> MicrosoftGraphContact.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.contacts = contacts;
                } else if ("events".equals(fieldName)) {
                    List<MicrosoftGraphEvent> events
                        = reader.readArray(reader1 -> MicrosoftGraphEvent.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.events = events;
                } else if ("inferenceClassification".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.inferenceClassification
                        = MicrosoftGraphInferenceClassification.fromJson(reader);
                } else if ("mailFolders".equals(fieldName)) {
                    List<MicrosoftGraphMailFolder> mailFolders
                        = reader.readArray(reader1 -> MicrosoftGraphMailFolder.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.mailFolders = mailFolders;
                } else if ("messages".equals(fieldName)) {
                    List<MicrosoftGraphMessage> messages
                        = reader.readArray(reader1 -> MicrosoftGraphMessage.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.messages = messages;
                } else if ("outlook".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.outlook = MicrosoftGraphOutlookUser.fromJson(reader);
                } else if ("people".equals(fieldName)) {
                    List<MicrosoftGraphPerson> people
                        = reader.readArray(reader1 -> MicrosoftGraphPerson.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.people = people;
                } else if ("photo".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.photo = MicrosoftGraphProfilePhoto.fromJson(reader);
                } else if ("photos".equals(fieldName)) {
                    List<MicrosoftGraphProfilePhoto> photos
                        = reader.readArray(reader1 -> MicrosoftGraphProfilePhoto.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.photos = photos;
                } else if ("drive".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.drive = MicrosoftGraphDrive.fromJson(reader);
                } else if ("drives".equals(fieldName)) {
                    List<MicrosoftGraphDrive> drives
                        = reader.readArray(reader1 -> MicrosoftGraphDrive.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.drives = drives;
                } else if ("followedSites".equals(fieldName)) {
                    List<MicrosoftGraphSite> followedSites
                        = reader.readArray(reader1 -> MicrosoftGraphSite.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.followedSites = followedSites;
                } else if ("extensions".equals(fieldName)) {
                    List<MicrosoftGraphExtension> extensions
                        = reader.readArray(reader1 -> MicrosoftGraphExtension.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.extensions = extensions;
                } else if ("managedDevices".equals(fieldName)) {
                    List<MicrosoftGraphManagedDevice> managedDevices
                        = reader.readArray(reader1 -> MicrosoftGraphManagedDevice.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.managedDevices = managedDevices;
                } else if ("managedAppRegistrations".equals(fieldName)) {
                    List<MicrosoftGraphManagedAppRegistration> managedAppRegistrations
                        = reader.readArray(reader1 -> MicrosoftGraphManagedAppRegistration.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.managedAppRegistrations = managedAppRegistrations;
                } else if ("deviceManagementTroubleshootingEvents".equals(fieldName)) {
                    List<MicrosoftGraphDeviceManagementTroubleshootingEvent> deviceManagementTroubleshootingEvents
                        = reader
                            .readArray(reader1 -> MicrosoftGraphDeviceManagementTroubleshootingEvent.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.deviceManagementTroubleshootingEvents
                        = deviceManagementTroubleshootingEvents;
                } else if ("planner".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.planner = MicrosoftGraphPlannerUser.fromJson(reader);
                } else if ("insights".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.insights = MicrosoftGraphOfficeGraphInsights.fromJson(reader);
                } else if ("settings".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.settings = MicrosoftGraphUserSettings.fromJson(reader);
                } else if ("onenote".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.onenote = MicrosoftGraphOnenote.fromJson(reader);
                } else if ("activities".equals(fieldName)) {
                    List<MicrosoftGraphUserActivity> activities
                        = reader.readArray(reader1 -> MicrosoftGraphUserActivity.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.activities = activities;
                } else if ("onlineMeetings".equals(fieldName)) {
                    List<MicrosoftGraphOnlineMeeting> onlineMeetings
                        = reader.readArray(reader1 -> MicrosoftGraphOnlineMeeting.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.onlineMeetings = onlineMeetings;
                } else if ("presence".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.presence = MicrosoftGraphPresence.fromJson(reader);
                } else if ("joinedTeams".equals(fieldName)) {
                    List<MicrosoftGraphTeamInner> joinedTeams
                        = reader.readArray(reader1 -> MicrosoftGraphTeamInner.fromJson(reader1));
                    deserializedMicrosoftGraphUserInner.joinedTeams = joinedTeams;
                } else if ("teamwork".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.teamwork = MicrosoftGraphUserTeamwork.fromJson(reader);
                } else if ("todo".equals(fieldName)) {
                    deserializedMicrosoftGraphUserInner.todo = MicrosoftGraphTodo.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphUserInner.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphUserInner;
        });
    }
}
