// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.ExpandedProperties;
import com.azure.resourcemanager.authorization.models.PrincipalType;
import com.azure.resourcemanager.authorization.models.RequestType;
import com.azure.resourcemanager.authorization.models.RoleEligibilityScheduleRequestPropertiesScheduleInfo;
import com.azure.resourcemanager.authorization.models.RoleEligibilityScheduleRequestPropertiesTicketInfo;
import com.azure.resourcemanager.authorization.models.Status;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Role Eligibility schedule request.
 */
@Fluent
public final class RoleEligibilityScheduleRequestInner
    implements JsonSerializable<RoleEligibilityScheduleRequestInner> {
    /*
     * The role eligibility schedule request ID.
     */
    private String id;

    /*
     * The role eligibility schedule request name.
     */
    private String name;

    /*
     * The role eligibility schedule request type.
     */
    private String type;

    /*
     * Role eligibility schedule request properties.
     */
    private RoleEligibilityScheduleRequestProperties innerProperties;

    /**
     * Creates an instance of RoleEligibilityScheduleRequestInner class.
     */
    public RoleEligibilityScheduleRequestInner() {
    }

    /**
     * Get the id property: The role eligibility schedule request ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The role eligibility schedule request name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The role eligibility schedule request type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the innerProperties property: Role eligibility schedule request properties.
     * 
     * @return the innerProperties value.
     */
    private RoleEligibilityScheduleRequestProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the scope property: The role eligibility schedule request scope.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    /**
     * Get the roleDefinitionId property: The role definition ID.
     * 
     * @return the roleDefinitionId value.
     */
    public String roleDefinitionId() {
        return this.innerProperties() == null ? null : this.innerProperties().roleDefinitionId();
    }

    /**
     * Set the roleDefinitionId property: The role definition ID.
     * 
     * @param roleDefinitionId the roleDefinitionId value to set.
     * @return the RoleEligibilityScheduleRequestInner object itself.
     */
    public RoleEligibilityScheduleRequestInner withRoleDefinitionId(String roleDefinitionId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleRequestProperties();
        }
        this.innerProperties().withRoleDefinitionId(roleDefinitionId);
        return this;
    }

    /**
     * Get the principalId property: The principal ID.
     * 
     * @return the principalId value.
     */
    public String principalId() {
        return this.innerProperties() == null ? null : this.innerProperties().principalId();
    }

    /**
     * Set the principalId property: The principal ID.
     * 
     * @param principalId the principalId value to set.
     * @return the RoleEligibilityScheduleRequestInner object itself.
     */
    public RoleEligibilityScheduleRequestInner withPrincipalId(String principalId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleRequestProperties();
        }
        this.innerProperties().withPrincipalId(principalId);
        return this;
    }

    /**
     * Get the principalType property: The principal type of the assigned principal ID.
     * 
     * @return the principalType value.
     */
    public PrincipalType principalType() {
        return this.innerProperties() == null ? null : this.innerProperties().principalType();
    }

    /**
     * Get the requestType property: The type of the role assignment schedule request. Eg: SelfActivate, AdminAssign
     * etc.
     * 
     * @return the requestType value.
     */
    public RequestType requestType() {
        return this.innerProperties() == null ? null : this.innerProperties().requestType();
    }

    /**
     * Set the requestType property: The type of the role assignment schedule request. Eg: SelfActivate, AdminAssign
     * etc.
     * 
     * @param requestType the requestType value to set.
     * @return the RoleEligibilityScheduleRequestInner object itself.
     */
    public RoleEligibilityScheduleRequestInner withRequestType(RequestType requestType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleRequestProperties();
        }
        this.innerProperties().withRequestType(requestType);
        return this;
    }

    /**
     * Get the status property: The status of the role eligibility schedule request.
     * 
     * @return the status value.
     */
    public Status status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Get the approvalId property: The approvalId of the role eligibility schedule request.
     * 
     * @return the approvalId value.
     */
    public String approvalId() {
        return this.innerProperties() == null ? null : this.innerProperties().approvalId();
    }

    /**
     * Get the scheduleInfo property: Schedule info of the role eligibility schedule.
     * 
     * @return the scheduleInfo value.
     */
    public RoleEligibilityScheduleRequestPropertiesScheduleInfo scheduleInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().scheduleInfo();
    }

    /**
     * Set the scheduleInfo property: Schedule info of the role eligibility schedule.
     * 
     * @param scheduleInfo the scheduleInfo value to set.
     * @return the RoleEligibilityScheduleRequestInner object itself.
     */
    public RoleEligibilityScheduleRequestInner
        withScheduleInfo(RoleEligibilityScheduleRequestPropertiesScheduleInfo scheduleInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleRequestProperties();
        }
        this.innerProperties().withScheduleInfo(scheduleInfo);
        return this;
    }

    /**
     * Get the targetRoleEligibilityScheduleId property: The resultant role eligibility schedule id or the role
     * eligibility schedule id being updated.
     * 
     * @return the targetRoleEligibilityScheduleId value.
     */
    public String targetRoleEligibilityScheduleId() {
        return this.innerProperties() == null ? null : this.innerProperties().targetRoleEligibilityScheduleId();
    }

    /**
     * Set the targetRoleEligibilityScheduleId property: The resultant role eligibility schedule id or the role
     * eligibility schedule id being updated.
     * 
     * @param targetRoleEligibilityScheduleId the targetRoleEligibilityScheduleId value to set.
     * @return the RoleEligibilityScheduleRequestInner object itself.
     */
    public RoleEligibilityScheduleRequestInner
        withTargetRoleEligibilityScheduleId(String targetRoleEligibilityScheduleId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleRequestProperties();
        }
        this.innerProperties().withTargetRoleEligibilityScheduleId(targetRoleEligibilityScheduleId);
        return this;
    }

    /**
     * Get the targetRoleEligibilityScheduleInstanceId property: The role eligibility schedule instance id being
     * updated.
     * 
     * @return the targetRoleEligibilityScheduleInstanceId value.
     */
    public String targetRoleEligibilityScheduleInstanceId() {
        return this.innerProperties() == null ? null : this.innerProperties().targetRoleEligibilityScheduleInstanceId();
    }

    /**
     * Set the targetRoleEligibilityScheduleInstanceId property: The role eligibility schedule instance id being
     * updated.
     * 
     * @param targetRoleEligibilityScheduleInstanceId the targetRoleEligibilityScheduleInstanceId value to set.
     * @return the RoleEligibilityScheduleRequestInner object itself.
     */
    public RoleEligibilityScheduleRequestInner
        withTargetRoleEligibilityScheduleInstanceId(String targetRoleEligibilityScheduleInstanceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleRequestProperties();
        }
        this.innerProperties().withTargetRoleEligibilityScheduleInstanceId(targetRoleEligibilityScheduleInstanceId);
        return this;
    }

    /**
     * Get the justification property: Justification for the role eligibility.
     * 
     * @return the justification value.
     */
    public String justification() {
        return this.innerProperties() == null ? null : this.innerProperties().justification();
    }

    /**
     * Set the justification property: Justification for the role eligibility.
     * 
     * @param justification the justification value to set.
     * @return the RoleEligibilityScheduleRequestInner object itself.
     */
    public RoleEligibilityScheduleRequestInner withJustification(String justification) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleRequestProperties();
        }
        this.innerProperties().withJustification(justification);
        return this;
    }

    /**
     * Get the ticketInfo property: Ticket Info of the role eligibility.
     * 
     * @return the ticketInfo value.
     */
    public RoleEligibilityScheduleRequestPropertiesTicketInfo ticketInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().ticketInfo();
    }

    /**
     * Set the ticketInfo property: Ticket Info of the role eligibility.
     * 
     * @param ticketInfo the ticketInfo value to set.
     * @return the RoleEligibilityScheduleRequestInner object itself.
     */
    public RoleEligibilityScheduleRequestInner
        withTicketInfo(RoleEligibilityScheduleRequestPropertiesTicketInfo ticketInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleRequestProperties();
        }
        this.innerProperties().withTicketInfo(ticketInfo);
        return this;
    }

    /**
     * Get the condition property: The conditions on the role assignment. This limits the resources it can be assigned
     * to. e.g.: &#064;Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     * StringEqualsIgnoreCase 'foo_storage_container'.
     * 
     * @return the condition value.
     */
    public String condition() {
        return this.innerProperties() == null ? null : this.innerProperties().condition();
    }

    /**
     * Set the condition property: The conditions on the role assignment. This limits the resources it can be assigned
     * to. e.g.: &#064;Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     * StringEqualsIgnoreCase 'foo_storage_container'.
     * 
     * @param condition the condition value to set.
     * @return the RoleEligibilityScheduleRequestInner object itself.
     */
    public RoleEligibilityScheduleRequestInner withCondition(String condition) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleRequestProperties();
        }
        this.innerProperties().withCondition(condition);
        return this;
    }

    /**
     * Get the conditionVersion property: Version of the condition. Currently accepted value is '2.0'.
     * 
     * @return the conditionVersion value.
     */
    public String conditionVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().conditionVersion();
    }

    /**
     * Set the conditionVersion property: Version of the condition. Currently accepted value is '2.0'.
     * 
     * @param conditionVersion the conditionVersion value to set.
     * @return the RoleEligibilityScheduleRequestInner object itself.
     */
    public RoleEligibilityScheduleRequestInner withConditionVersion(String conditionVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleEligibilityScheduleRequestProperties();
        }
        this.innerProperties().withConditionVersion(conditionVersion);
        return this;
    }

    /**
     * Get the createdOn property: DateTime when role eligibility schedule request was created.
     * 
     * @return the createdOn value.
     */
    public OffsetDateTime createdOn() {
        return this.innerProperties() == null ? null : this.innerProperties().createdOn();
    }

    /**
     * Get the requestorId property: Id of the user who created this request.
     * 
     * @return the requestorId value.
     */
    public String requestorId() {
        return this.innerProperties() == null ? null : this.innerProperties().requestorId();
    }

    /**
     * Get the expandedProperties property: Additional properties of principal, scope and role definition.
     * 
     * @return the expandedProperties value.
     */
    public ExpandedProperties expandedProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().expandedProperties();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoleEligibilityScheduleRequestInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoleEligibilityScheduleRequestInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RoleEligibilityScheduleRequestInner.
     */
    public static RoleEligibilityScheduleRequestInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoleEligibilityScheduleRequestInner deserializedRoleEligibilityScheduleRequestInner
                = new RoleEligibilityScheduleRequestInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestInner.innerProperties
                        = RoleEligibilityScheduleRequestProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoleEligibilityScheduleRequestInner;
        });
    }
}
