// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Resource Type.
 */
@Fluent
public final class ResourceType implements JsonSerializable<ResourceType> {
    /*
     * The resource type name.
     */
    private String name;

    /*
     * The resource type display name.
     */
    private String displayName;

    /*
     * The resource type operations.
     */
    private List<ProviderOperation> operations;

    /**
     * Creates an instance of ResourceType class.
     */
    public ResourceType() {
    }

    /**
     * Get the name property: The resource type name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The resource type name.
     * 
     * @param name the name value to set.
     * @return the ResourceType object itself.
     */
    public ResourceType withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the displayName property: The resource type display name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The resource type display name.
     * 
     * @param displayName the displayName value to set.
     * @return the ResourceType object itself.
     */
    public ResourceType withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the operations property: The resource type operations.
     * 
     * @return the operations value.
     */
    public List<ProviderOperation> operations() {
        return this.operations;
    }

    /**
     * Set the operations property: The resource type operations.
     * 
     * @param operations the operations value to set.
     * @return the ResourceType object itself.
     */
    public ResourceType withOperations(List<ProviderOperation> operations) {
        this.operations = operations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (operations() != null) {
            operations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeArrayField("operations", this.operations, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceType from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceType if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceType.
     */
    public static ResourceType fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceType deserializedResourceType = new ResourceType();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedResourceType.name = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedResourceType.displayName = reader.getString();
                } else if ("operations".equals(fieldName)) {
                    List<ProviderOperation> operations
                        = reader.readArray(reader1 -> ProviderOperation.fromJson(reader1));
                    deserializedResourceType.operations = operations;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceType;
        });
    }
}
