/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphResourceSpecificPermissionGrant
extends MicrosoftGraphDirectoryObjectInner {
    private String clientAppId;
    private String clientId;
    private String permission;
    private String permissionType;
    private String resourceAppId;
    private Map<String, Object> additionalProperties;

    public String clientAppId() {
        return this.clientAppId;
    }

    public MicrosoftGraphResourceSpecificPermissionGrant withClientAppId(String clientAppId) {
        this.clientAppId = clientAppId;
        return this;
    }

    public String clientId() {
        return this.clientId;
    }

    public MicrosoftGraphResourceSpecificPermissionGrant withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String permission() {
        return this.permission;
    }

    public MicrosoftGraphResourceSpecificPermissionGrant withPermission(String permission) {
        this.permission = permission;
        return this;
    }

    public String permissionType() {
        return this.permissionType;
    }

    public MicrosoftGraphResourceSpecificPermissionGrant withPermissionType(String permissionType) {
        this.permissionType = permissionType;
        return this;
    }

    public String resourceAppId() {
        return this.resourceAppId;
    }

    public MicrosoftGraphResourceSpecificPermissionGrant withResourceAppId(String resourceAppId) {
        this.resourceAppId = resourceAppId;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphResourceSpecificPermissionGrant withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphResourceSpecificPermissionGrant withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphResourceSpecificPermissionGrant withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("deletedDateTime", this.deletedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deletedDateTime()));
        jsonWriter.writeStringField("clientAppId", this.clientAppId);
        jsonWriter.writeStringField("clientId", this.clientId);
        jsonWriter.writeStringField("permission", this.permission);
        jsonWriter.writeStringField("permissionType", this.permissionType);
        jsonWriter.writeStringField("resourceAppId", this.resourceAppId);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphResourceSpecificPermissionGrant fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphResourceSpecificPermissionGrant)jsonReader.readObject(reader -> {
            MicrosoftGraphResourceSpecificPermissionGrant deserializedMicrosoftGraphResourceSpecificPermissionGrant = new MicrosoftGraphResourceSpecificPermissionGrant();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphResourceSpecificPermissionGrant.withId(reader.getString());
                    continue;
                }
                if ("deletedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphResourceSpecificPermissionGrant.withDeletedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("clientAppId".equals(fieldName)) {
                    deserializedMicrosoftGraphResourceSpecificPermissionGrant.clientAppId = reader.getString();
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedMicrosoftGraphResourceSpecificPermissionGrant.clientId = reader.getString();
                    continue;
                }
                if ("permission".equals(fieldName)) {
                    deserializedMicrosoftGraphResourceSpecificPermissionGrant.permission = reader.getString();
                    continue;
                }
                if ("permissionType".equals(fieldName)) {
                    deserializedMicrosoftGraphResourceSpecificPermissionGrant.permissionType = reader.getString();
                    continue;
                }
                if ("resourceAppId".equals(fieldName)) {
                    deserializedMicrosoftGraphResourceSpecificPermissionGrant.resourceAppId = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphResourceSpecificPermissionGrant.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphResourceSpecificPermissionGrant;
        });
    }
}

