// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * lookupColumn.
 */
@Fluent
public final class MicrosoftGraphLookupColumn implements JsonSerializable<MicrosoftGraphLookupColumn> {
    /*
     * Indicates whether multiple values can be selected from the source.
     */
    private Boolean allowMultipleValues;

    /*
     * Indicates whether values in the column should be able to exceed the standard limit of 255 characters.
     */
    private Boolean allowUnlimitedLength;

    /*
     * The name of the lookup source column.
     */
    private String columnName;

    /*
     * The unique identifier of the lookup source list.
     */
    private String listId;

    /*
     * If specified, this column is a secondary lookup, pulling an additional field from the list item looked up by the
     * primary lookup. Use the list item looked up by the primary as the source for the column named here.
     */
    private String primaryLookupColumnId;

    /*
     * lookupColumn
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphLookupColumn class.
     */
    public MicrosoftGraphLookupColumn() {
    }

    /**
     * Get the allowMultipleValues property: Indicates whether multiple values can be selected from the source.
     * 
     * @return the allowMultipleValues value.
     */
    public Boolean allowMultipleValues() {
        return this.allowMultipleValues;
    }

    /**
     * Set the allowMultipleValues property: Indicates whether multiple values can be selected from the source.
     * 
     * @param allowMultipleValues the allowMultipleValues value to set.
     * @return the MicrosoftGraphLookupColumn object itself.
     */
    public MicrosoftGraphLookupColumn withAllowMultipleValues(Boolean allowMultipleValues) {
        this.allowMultipleValues = allowMultipleValues;
        return this;
    }

    /**
     * Get the allowUnlimitedLength property: Indicates whether values in the column should be able to exceed the
     * standard limit of 255 characters.
     * 
     * @return the allowUnlimitedLength value.
     */
    public Boolean allowUnlimitedLength() {
        return this.allowUnlimitedLength;
    }

    /**
     * Set the allowUnlimitedLength property: Indicates whether values in the column should be able to exceed the
     * standard limit of 255 characters.
     * 
     * @param allowUnlimitedLength the allowUnlimitedLength value to set.
     * @return the MicrosoftGraphLookupColumn object itself.
     */
    public MicrosoftGraphLookupColumn withAllowUnlimitedLength(Boolean allowUnlimitedLength) {
        this.allowUnlimitedLength = allowUnlimitedLength;
        return this;
    }

    /**
     * Get the columnName property: The name of the lookup source column.
     * 
     * @return the columnName value.
     */
    public String columnName() {
        return this.columnName;
    }

    /**
     * Set the columnName property: The name of the lookup source column.
     * 
     * @param columnName the columnName value to set.
     * @return the MicrosoftGraphLookupColumn object itself.
     */
    public MicrosoftGraphLookupColumn withColumnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    /**
     * Get the listId property: The unique identifier of the lookup source list.
     * 
     * @return the listId value.
     */
    public String listId() {
        return this.listId;
    }

    /**
     * Set the listId property: The unique identifier of the lookup source list.
     * 
     * @param listId the listId value to set.
     * @return the MicrosoftGraphLookupColumn object itself.
     */
    public MicrosoftGraphLookupColumn withListId(String listId) {
        this.listId = listId;
        return this;
    }

    /**
     * Get the primaryLookupColumnId property: If specified, this column is a secondary lookup, pulling an additional
     * field from the list item looked up by the primary lookup. Use the list item looked up by the primary as the
     * source for the column named here.
     * 
     * @return the primaryLookupColumnId value.
     */
    public String primaryLookupColumnId() {
        return this.primaryLookupColumnId;
    }

    /**
     * Set the primaryLookupColumnId property: If specified, this column is a secondary lookup, pulling an additional
     * field from the list item looked up by the primary lookup. Use the list item looked up by the primary as the
     * source for the column named here.
     * 
     * @param primaryLookupColumnId the primaryLookupColumnId value to set.
     * @return the MicrosoftGraphLookupColumn object itself.
     */
    public MicrosoftGraphLookupColumn withPrimaryLookupColumnId(String primaryLookupColumnId) {
        this.primaryLookupColumnId = primaryLookupColumnId;
        return this;
    }

    /**
     * Get the additionalProperties property: lookupColumn.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: lookupColumn.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphLookupColumn object itself.
     */
    public MicrosoftGraphLookupColumn withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("allowMultipleValues", this.allowMultipleValues);
        jsonWriter.writeBooleanField("allowUnlimitedLength", this.allowUnlimitedLength);
        jsonWriter.writeStringField("columnName", this.columnName);
        jsonWriter.writeStringField("listId", this.listId);
        jsonWriter.writeStringField("primaryLookupColumnId", this.primaryLookupColumnId);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphLookupColumn from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphLookupColumn if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphLookupColumn.
     */
    public static MicrosoftGraphLookupColumn fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphLookupColumn deserializedMicrosoftGraphLookupColumn = new MicrosoftGraphLookupColumn();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allowMultipleValues".equals(fieldName)) {
                    deserializedMicrosoftGraphLookupColumn.allowMultipleValues
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowUnlimitedLength".equals(fieldName)) {
                    deserializedMicrosoftGraphLookupColumn.allowUnlimitedLength
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("columnName".equals(fieldName)) {
                    deserializedMicrosoftGraphLookupColumn.columnName = reader.getString();
                } else if ("listId".equals(fieldName)) {
                    deserializedMicrosoftGraphLookupColumn.listId = reader.getString();
                } else if ("primaryLookupColumnId".equals(fieldName)) {
                    deserializedMicrosoftGraphLookupColumn.primaryLookupColumnId = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphLookupColumn.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphLookupColumn;
        });
    }
}
