// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * onenotePagePreviewLinks.
 */
@Fluent
public final class MicrosoftGraphOnenotePagePreviewLinks
    implements JsonSerializable<MicrosoftGraphOnenotePagePreviewLinks> {
    /*
     * externalLink
     */
    private MicrosoftGraphExternalLink previewImageUrl;

    /*
     * onenotePagePreviewLinks
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphOnenotePagePreviewLinks class.
     */
    public MicrosoftGraphOnenotePagePreviewLinks() {
    }

    /**
     * Get the previewImageUrl property: externalLink.
     * 
     * @return the previewImageUrl value.
     */
    public MicrosoftGraphExternalLink previewImageUrl() {
        return this.previewImageUrl;
    }

    /**
     * Set the previewImageUrl property: externalLink.
     * 
     * @param previewImageUrl the previewImageUrl value to set.
     * @return the MicrosoftGraphOnenotePagePreviewLinks object itself.
     */
    public MicrosoftGraphOnenotePagePreviewLinks withPreviewImageUrl(MicrosoftGraphExternalLink previewImageUrl) {
        this.previewImageUrl = previewImageUrl;
        return this;
    }

    /**
     * Get the additionalProperties property: onenotePagePreviewLinks.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: onenotePagePreviewLinks.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOnenotePagePreviewLinks object itself.
     */
    public MicrosoftGraphOnenotePagePreviewLinks withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (previewImageUrl() != null) {
            previewImageUrl().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("previewImageUrl", this.previewImageUrl);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphOnenotePagePreviewLinks from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphOnenotePagePreviewLinks if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphOnenotePagePreviewLinks.
     */
    public static MicrosoftGraphOnenotePagePreviewLinks fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphOnenotePagePreviewLinks deserializedMicrosoftGraphOnenotePagePreviewLinks
                = new MicrosoftGraphOnenotePagePreviewLinks();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("previewImageUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePagePreviewLinks.previewImageUrl
                        = MicrosoftGraphExternalLink.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphOnenotePagePreviewLinks.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphOnenotePagePreviewLinks;
        });
    }
}
