// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.AssignmentType;
import com.azure.resourcemanager.authorization.models.ExpandedProperties;
import com.azure.resourcemanager.authorization.models.MemberType;
import com.azure.resourcemanager.authorization.models.PrincipalType;
import com.azure.resourcemanager.authorization.models.Status;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Information about current or upcoming role assignment schedule instance.
 */
@Fluent
public final class RoleAssignmentScheduleInstanceInner
    implements JsonSerializable<RoleAssignmentScheduleInstanceInner> {
    /*
     * The role assignment schedule instance ID.
     */
    private String id;

    /*
     * The role assignment schedule instance name.
     */
    private String name;

    /*
     * The role assignment schedule instance type.
     */
    private String type;

    /*
     * Role assignment schedule instance properties.
     */
    private RoleAssignmentScheduleInstanceProperties innerProperties;

    /**
     * Creates an instance of RoleAssignmentScheduleInstanceInner class.
     */
    public RoleAssignmentScheduleInstanceInner() {
    }

    /**
     * Get the id property: The role assignment schedule instance ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The role assignment schedule instance name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The role assignment schedule instance type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the innerProperties property: Role assignment schedule instance properties.
     * 
     * @return the innerProperties value.
     */
    private RoleAssignmentScheduleInstanceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the scope property: The role assignment schedule scope.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    /**
     * Set the scope property: The role assignment schedule scope.
     * 
     * @param scope the scope value to set.
     * @return the RoleAssignmentScheduleInstanceInner object itself.
     */
    public RoleAssignmentScheduleInstanceInner withScope(String scope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleInstanceProperties();
        }
        this.innerProperties().withScope(scope);
        return this;
    }

    /**
     * Get the roleDefinitionId property: The role definition ID.
     * 
     * @return the roleDefinitionId value.
     */
    public String roleDefinitionId() {
        return this.innerProperties() == null ? null : this.innerProperties().roleDefinitionId();
    }

    /**
     * Set the roleDefinitionId property: The role definition ID.
     * 
     * @param roleDefinitionId the roleDefinitionId value to set.
     * @return the RoleAssignmentScheduleInstanceInner object itself.
     */
    public RoleAssignmentScheduleInstanceInner withRoleDefinitionId(String roleDefinitionId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleInstanceProperties();
        }
        this.innerProperties().withRoleDefinitionId(roleDefinitionId);
        return this;
    }

    /**
     * Get the principalId property: The principal ID.
     * 
     * @return the principalId value.
     */
    public String principalId() {
        return this.innerProperties() == null ? null : this.innerProperties().principalId();
    }

    /**
     * Set the principalId property: The principal ID.
     * 
     * @param principalId the principalId value to set.
     * @return the RoleAssignmentScheduleInstanceInner object itself.
     */
    public RoleAssignmentScheduleInstanceInner withPrincipalId(String principalId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleInstanceProperties();
        }
        this.innerProperties().withPrincipalId(principalId);
        return this;
    }

    /**
     * Get the principalType property: The principal type of the assigned principal ID.
     * 
     * @return the principalType value.
     */
    public PrincipalType principalType() {
        return this.innerProperties() == null ? null : this.innerProperties().principalType();
    }

    /**
     * Set the principalType property: The principal type of the assigned principal ID.
     * 
     * @param principalType the principalType value to set.
     * @return the RoleAssignmentScheduleInstanceInner object itself.
     */
    public RoleAssignmentScheduleInstanceInner withPrincipalType(PrincipalType principalType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleInstanceProperties();
        }
        this.innerProperties().withPrincipalType(principalType);
        return this;
    }

    /**
     * Get the roleAssignmentScheduleId property: Id of the master role assignment schedule.
     * 
     * @return the roleAssignmentScheduleId value.
     */
    public String roleAssignmentScheduleId() {
        return this.innerProperties() == null ? null : this.innerProperties().roleAssignmentScheduleId();
    }

    /**
     * Set the roleAssignmentScheduleId property: Id of the master role assignment schedule.
     * 
     * @param roleAssignmentScheduleId the roleAssignmentScheduleId value to set.
     * @return the RoleAssignmentScheduleInstanceInner object itself.
     */
    public RoleAssignmentScheduleInstanceInner withRoleAssignmentScheduleId(String roleAssignmentScheduleId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleInstanceProperties();
        }
        this.innerProperties().withRoleAssignmentScheduleId(roleAssignmentScheduleId);
        return this;
    }

    /**
     * Get the originRoleAssignmentId property: Role Assignment Id in external system.
     * 
     * @return the originRoleAssignmentId value.
     */
    public String originRoleAssignmentId() {
        return this.innerProperties() == null ? null : this.innerProperties().originRoleAssignmentId();
    }

    /**
     * Set the originRoleAssignmentId property: Role Assignment Id in external system.
     * 
     * @param originRoleAssignmentId the originRoleAssignmentId value to set.
     * @return the RoleAssignmentScheduleInstanceInner object itself.
     */
    public RoleAssignmentScheduleInstanceInner withOriginRoleAssignmentId(String originRoleAssignmentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleInstanceProperties();
        }
        this.innerProperties().withOriginRoleAssignmentId(originRoleAssignmentId);
        return this;
    }

    /**
     * Get the status property: The status of the role assignment schedule instance.
     * 
     * @return the status value.
     */
    public Status status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Set the status property: The status of the role assignment schedule instance.
     * 
     * @param status the status value to set.
     * @return the RoleAssignmentScheduleInstanceInner object itself.
     */
    public RoleAssignmentScheduleInstanceInner withStatus(Status status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleInstanceProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    /**
     * Get the startDateTime property: The startDateTime of the role assignment schedule instance.
     * 
     * @return the startDateTime value.
     */
    public OffsetDateTime startDateTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startDateTime();
    }

    /**
     * Set the startDateTime property: The startDateTime of the role assignment schedule instance.
     * 
     * @param startDateTime the startDateTime value to set.
     * @return the RoleAssignmentScheduleInstanceInner object itself.
     */
    public RoleAssignmentScheduleInstanceInner withStartDateTime(OffsetDateTime startDateTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleInstanceProperties();
        }
        this.innerProperties().withStartDateTime(startDateTime);
        return this;
    }

    /**
     * Get the endDateTime property: The endDateTime of the role assignment schedule instance.
     * 
     * @return the endDateTime value.
     */
    public OffsetDateTime endDateTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endDateTime();
    }

    /**
     * Set the endDateTime property: The endDateTime of the role assignment schedule instance.
     * 
     * @param endDateTime the endDateTime value to set.
     * @return the RoleAssignmentScheduleInstanceInner object itself.
     */
    public RoleAssignmentScheduleInstanceInner withEndDateTime(OffsetDateTime endDateTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleInstanceProperties();
        }
        this.innerProperties().withEndDateTime(endDateTime);
        return this;
    }

    /**
     * Get the linkedRoleEligibilityScheduleId property: roleEligibilityScheduleId used to activate.
     * 
     * @return the linkedRoleEligibilityScheduleId value.
     */
    public String linkedRoleEligibilityScheduleId() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedRoleEligibilityScheduleId();
    }

    /**
     * Set the linkedRoleEligibilityScheduleId property: roleEligibilityScheduleId used to activate.
     * 
     * @param linkedRoleEligibilityScheduleId the linkedRoleEligibilityScheduleId value to set.
     * @return the RoleAssignmentScheduleInstanceInner object itself.
     */
    public RoleAssignmentScheduleInstanceInner
        withLinkedRoleEligibilityScheduleId(String linkedRoleEligibilityScheduleId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleInstanceProperties();
        }
        this.innerProperties().withLinkedRoleEligibilityScheduleId(linkedRoleEligibilityScheduleId);
        return this;
    }

    /**
     * Get the linkedRoleEligibilityScheduleInstanceId property: roleEligibilityScheduleInstanceId linked to this
     * roleAssignmentScheduleInstance.
     * 
     * @return the linkedRoleEligibilityScheduleInstanceId value.
     */
    public String linkedRoleEligibilityScheduleInstanceId() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedRoleEligibilityScheduleInstanceId();
    }

    /**
     * Set the linkedRoleEligibilityScheduleInstanceId property: roleEligibilityScheduleInstanceId linked to this
     * roleAssignmentScheduleInstance.
     * 
     * @param linkedRoleEligibilityScheduleInstanceId the linkedRoleEligibilityScheduleInstanceId value to set.
     * @return the RoleAssignmentScheduleInstanceInner object itself.
     */
    public RoleAssignmentScheduleInstanceInner
        withLinkedRoleEligibilityScheduleInstanceId(String linkedRoleEligibilityScheduleInstanceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleInstanceProperties();
        }
        this.innerProperties().withLinkedRoleEligibilityScheduleInstanceId(linkedRoleEligibilityScheduleInstanceId);
        return this;
    }

    /**
     * Get the assignmentType property: Assignment type of the role assignment schedule.
     * 
     * @return the assignmentType value.
     */
    public AssignmentType assignmentType() {
        return this.innerProperties() == null ? null : this.innerProperties().assignmentType();
    }

    /**
     * Set the assignmentType property: Assignment type of the role assignment schedule.
     * 
     * @param assignmentType the assignmentType value to set.
     * @return the RoleAssignmentScheduleInstanceInner object itself.
     */
    public RoleAssignmentScheduleInstanceInner withAssignmentType(AssignmentType assignmentType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleInstanceProperties();
        }
        this.innerProperties().withAssignmentType(assignmentType);
        return this;
    }

    /**
     * Get the memberType property: Membership type of the role assignment schedule.
     * 
     * @return the memberType value.
     */
    public MemberType memberType() {
        return this.innerProperties() == null ? null : this.innerProperties().memberType();
    }

    /**
     * Set the memberType property: Membership type of the role assignment schedule.
     * 
     * @param memberType the memberType value to set.
     * @return the RoleAssignmentScheduleInstanceInner object itself.
     */
    public RoleAssignmentScheduleInstanceInner withMemberType(MemberType memberType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleInstanceProperties();
        }
        this.innerProperties().withMemberType(memberType);
        return this;
    }

    /**
     * Get the condition property: The conditions on the role assignment. This limits the resources it can be assigned
     * to. e.g.: &#064;Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     * StringEqualsIgnoreCase 'foo_storage_container'.
     * 
     * @return the condition value.
     */
    public String condition() {
        return this.innerProperties() == null ? null : this.innerProperties().condition();
    }

    /**
     * Set the condition property: The conditions on the role assignment. This limits the resources it can be assigned
     * to. e.g.: &#064;Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     * StringEqualsIgnoreCase 'foo_storage_container'.
     * 
     * @param condition the condition value to set.
     * @return the RoleAssignmentScheduleInstanceInner object itself.
     */
    public RoleAssignmentScheduleInstanceInner withCondition(String condition) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleInstanceProperties();
        }
        this.innerProperties().withCondition(condition);
        return this;
    }

    /**
     * Get the conditionVersion property: Version of the condition. Currently accepted value is '2.0'.
     * 
     * @return the conditionVersion value.
     */
    public String conditionVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().conditionVersion();
    }

    /**
     * Set the conditionVersion property: Version of the condition. Currently accepted value is '2.0'.
     * 
     * @param conditionVersion the conditionVersion value to set.
     * @return the RoleAssignmentScheduleInstanceInner object itself.
     */
    public RoleAssignmentScheduleInstanceInner withConditionVersion(String conditionVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleInstanceProperties();
        }
        this.innerProperties().withConditionVersion(conditionVersion);
        return this;
    }

    /**
     * Get the createdOn property: DateTime when role assignment schedule was created.
     * 
     * @return the createdOn value.
     */
    public OffsetDateTime createdOn() {
        return this.innerProperties() == null ? null : this.innerProperties().createdOn();
    }

    /**
     * Set the createdOn property: DateTime when role assignment schedule was created.
     * 
     * @param createdOn the createdOn value to set.
     * @return the RoleAssignmentScheduleInstanceInner object itself.
     */
    public RoleAssignmentScheduleInstanceInner withCreatedOn(OffsetDateTime createdOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleInstanceProperties();
        }
        this.innerProperties().withCreatedOn(createdOn);
        return this;
    }

    /**
     * Get the expandedProperties property: Additional properties of principal, scope and role definition.
     * 
     * @return the expandedProperties value.
     */
    public ExpandedProperties expandedProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().expandedProperties();
    }

    /**
     * Set the expandedProperties property: Additional properties of principal, scope and role definition.
     * 
     * @param expandedProperties the expandedProperties value to set.
     * @return the RoleAssignmentScheduleInstanceInner object itself.
     */
    public RoleAssignmentScheduleInstanceInner withExpandedProperties(ExpandedProperties expandedProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleInstanceProperties();
        }
        this.innerProperties().withExpandedProperties(expandedProperties);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoleAssignmentScheduleInstanceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoleAssignmentScheduleInstanceInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RoleAssignmentScheduleInstanceInner.
     */
    public static RoleAssignmentScheduleInstanceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoleAssignmentScheduleInstanceInner deserializedRoleAssignmentScheduleInstanceInner
                = new RoleAssignmentScheduleInstanceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleInstanceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleInstanceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleInstanceInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleInstanceInner.innerProperties
                        = RoleAssignmentScheduleInstanceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoleAssignmentScheduleInstanceInner;
        });
    }
}
