// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.ExpandedProperties;
import com.azure.resourcemanager.authorization.models.PrincipalType;
import com.azure.resourcemanager.authorization.models.RequestType;
import com.azure.resourcemanager.authorization.models.RoleEligibilityScheduleRequestPropertiesScheduleInfo;
import com.azure.resourcemanager.authorization.models.RoleEligibilityScheduleRequestPropertiesTicketInfo;
import com.azure.resourcemanager.authorization.models.Status;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Role eligibility schedule request properties with scope.
 */
@Fluent
public final class RoleEligibilityScheduleRequestProperties
    implements JsonSerializable<RoleEligibilityScheduleRequestProperties> {
    /*
     * The role eligibility schedule request scope.
     */
    private String scope;

    /*
     * The role definition ID.
     */
    private String roleDefinitionId;

    /*
     * The principal ID.
     */
    private String principalId;

    /*
     * The principal type of the assigned principal ID.
     */
    private PrincipalType principalType;

    /*
     * The type of the role assignment schedule request. Eg: SelfActivate, AdminAssign etc
     */
    private RequestType requestType;

    /*
     * The status of the role eligibility schedule request.
     */
    private Status status;

    /*
     * The approvalId of the role eligibility schedule request.
     */
    private String approvalId;

    /*
     * Schedule info of the role eligibility schedule
     */
    private RoleEligibilityScheduleRequestPropertiesScheduleInfo scheduleInfo;

    /*
     * The resultant role eligibility schedule id or the role eligibility schedule id being updated
     */
    private String targetRoleEligibilityScheduleId;

    /*
     * The role eligibility schedule instance id being updated
     */
    private String targetRoleEligibilityScheduleInstanceId;

    /*
     * Justification for the role eligibility
     */
    private String justification;

    /*
     * Ticket Info of the role eligibility
     */
    private RoleEligibilityScheduleRequestPropertiesTicketInfo ticketInfo;

    /*
     * The conditions on the role assignment. This limits the resources it can be assigned to.
     * e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase
     * 'foo_storage_container'
     */
    private String condition;

    /*
     * Version of the condition. Currently accepted value is '2.0'
     */
    private String conditionVersion;

    /*
     * DateTime when role eligibility schedule request was created
     */
    private OffsetDateTime createdOn;

    /*
     * Id of the user who created this request
     */
    private String requestorId;

    /*
     * Additional properties of principal, scope and role definition
     */
    private ExpandedProperties expandedProperties;

    /**
     * Creates an instance of RoleEligibilityScheduleRequestProperties class.
     */
    public RoleEligibilityScheduleRequestProperties() {
    }

    /**
     * Get the scope property: The role eligibility schedule request scope.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.scope;
    }

    /**
     * Get the roleDefinitionId property: The role definition ID.
     * 
     * @return the roleDefinitionId value.
     */
    public String roleDefinitionId() {
        return this.roleDefinitionId;
    }

    /**
     * Set the roleDefinitionId property: The role definition ID.
     * 
     * @param roleDefinitionId the roleDefinitionId value to set.
     * @return the RoleEligibilityScheduleRequestProperties object itself.
     */
    public RoleEligibilityScheduleRequestProperties withRoleDefinitionId(String roleDefinitionId) {
        this.roleDefinitionId = roleDefinitionId;
        return this;
    }

    /**
     * Get the principalId property: The principal ID.
     * 
     * @return the principalId value.
     */
    public String principalId() {
        return this.principalId;
    }

    /**
     * Set the principalId property: The principal ID.
     * 
     * @param principalId the principalId value to set.
     * @return the RoleEligibilityScheduleRequestProperties object itself.
     */
    public RoleEligibilityScheduleRequestProperties withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    /**
     * Get the principalType property: The principal type of the assigned principal ID.
     * 
     * @return the principalType value.
     */
    public PrincipalType principalType() {
        return this.principalType;
    }

    /**
     * Get the requestType property: The type of the role assignment schedule request. Eg: SelfActivate, AdminAssign
     * etc.
     * 
     * @return the requestType value.
     */
    public RequestType requestType() {
        return this.requestType;
    }

    /**
     * Set the requestType property: The type of the role assignment schedule request. Eg: SelfActivate, AdminAssign
     * etc.
     * 
     * @param requestType the requestType value to set.
     * @return the RoleEligibilityScheduleRequestProperties object itself.
     */
    public RoleEligibilityScheduleRequestProperties withRequestType(RequestType requestType) {
        this.requestType = requestType;
        return this;
    }

    /**
     * Get the status property: The status of the role eligibility schedule request.
     * 
     * @return the status value.
     */
    public Status status() {
        return this.status;
    }

    /**
     * Get the approvalId property: The approvalId of the role eligibility schedule request.
     * 
     * @return the approvalId value.
     */
    public String approvalId() {
        return this.approvalId;
    }

    /**
     * Get the scheduleInfo property: Schedule info of the role eligibility schedule.
     * 
     * @return the scheduleInfo value.
     */
    public RoleEligibilityScheduleRequestPropertiesScheduleInfo scheduleInfo() {
        return this.scheduleInfo;
    }

    /**
     * Set the scheduleInfo property: Schedule info of the role eligibility schedule.
     * 
     * @param scheduleInfo the scheduleInfo value to set.
     * @return the RoleEligibilityScheduleRequestProperties object itself.
     */
    public RoleEligibilityScheduleRequestProperties
        withScheduleInfo(RoleEligibilityScheduleRequestPropertiesScheduleInfo scheduleInfo) {
        this.scheduleInfo = scheduleInfo;
        return this;
    }

    /**
     * Get the targetRoleEligibilityScheduleId property: The resultant role eligibility schedule id or the role
     * eligibility schedule id being updated.
     * 
     * @return the targetRoleEligibilityScheduleId value.
     */
    public String targetRoleEligibilityScheduleId() {
        return this.targetRoleEligibilityScheduleId;
    }

    /**
     * Set the targetRoleEligibilityScheduleId property: The resultant role eligibility schedule id or the role
     * eligibility schedule id being updated.
     * 
     * @param targetRoleEligibilityScheduleId the targetRoleEligibilityScheduleId value to set.
     * @return the RoleEligibilityScheduleRequestProperties object itself.
     */
    public RoleEligibilityScheduleRequestProperties
        withTargetRoleEligibilityScheduleId(String targetRoleEligibilityScheduleId) {
        this.targetRoleEligibilityScheduleId = targetRoleEligibilityScheduleId;
        return this;
    }

    /**
     * Get the targetRoleEligibilityScheduleInstanceId property: The role eligibility schedule instance id being
     * updated.
     * 
     * @return the targetRoleEligibilityScheduleInstanceId value.
     */
    public String targetRoleEligibilityScheduleInstanceId() {
        return this.targetRoleEligibilityScheduleInstanceId;
    }

    /**
     * Set the targetRoleEligibilityScheduleInstanceId property: The role eligibility schedule instance id being
     * updated.
     * 
     * @param targetRoleEligibilityScheduleInstanceId the targetRoleEligibilityScheduleInstanceId value to set.
     * @return the RoleEligibilityScheduleRequestProperties object itself.
     */
    public RoleEligibilityScheduleRequestProperties
        withTargetRoleEligibilityScheduleInstanceId(String targetRoleEligibilityScheduleInstanceId) {
        this.targetRoleEligibilityScheduleInstanceId = targetRoleEligibilityScheduleInstanceId;
        return this;
    }

    /**
     * Get the justification property: Justification for the role eligibility.
     * 
     * @return the justification value.
     */
    public String justification() {
        return this.justification;
    }

    /**
     * Set the justification property: Justification for the role eligibility.
     * 
     * @param justification the justification value to set.
     * @return the RoleEligibilityScheduleRequestProperties object itself.
     */
    public RoleEligibilityScheduleRequestProperties withJustification(String justification) {
        this.justification = justification;
        return this;
    }

    /**
     * Get the ticketInfo property: Ticket Info of the role eligibility.
     * 
     * @return the ticketInfo value.
     */
    public RoleEligibilityScheduleRequestPropertiesTicketInfo ticketInfo() {
        return this.ticketInfo;
    }

    /**
     * Set the ticketInfo property: Ticket Info of the role eligibility.
     * 
     * @param ticketInfo the ticketInfo value to set.
     * @return the RoleEligibilityScheduleRequestProperties object itself.
     */
    public RoleEligibilityScheduleRequestProperties
        withTicketInfo(RoleEligibilityScheduleRequestPropertiesTicketInfo ticketInfo) {
        this.ticketInfo = ticketInfo;
        return this;
    }

    /**
     * Get the condition property: The conditions on the role assignment. This limits the resources it can be assigned
     * to. e.g.: &#064;Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     * StringEqualsIgnoreCase 'foo_storage_container'.
     * 
     * @return the condition value.
     */
    public String condition() {
        return this.condition;
    }

    /**
     * Set the condition property: The conditions on the role assignment. This limits the resources it can be assigned
     * to. e.g.: &#064;Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     * StringEqualsIgnoreCase 'foo_storage_container'.
     * 
     * @param condition the condition value to set.
     * @return the RoleEligibilityScheduleRequestProperties object itself.
     */
    public RoleEligibilityScheduleRequestProperties withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    /**
     * Get the conditionVersion property: Version of the condition. Currently accepted value is '2.0'.
     * 
     * @return the conditionVersion value.
     */
    public String conditionVersion() {
        return this.conditionVersion;
    }

    /**
     * Set the conditionVersion property: Version of the condition. Currently accepted value is '2.0'.
     * 
     * @param conditionVersion the conditionVersion value to set.
     * @return the RoleEligibilityScheduleRequestProperties object itself.
     */
    public RoleEligibilityScheduleRequestProperties withConditionVersion(String conditionVersion) {
        this.conditionVersion = conditionVersion;
        return this;
    }

    /**
     * Get the createdOn property: DateTime when role eligibility schedule request was created.
     * 
     * @return the createdOn value.
     */
    public OffsetDateTime createdOn() {
        return this.createdOn;
    }

    /**
     * Get the requestorId property: Id of the user who created this request.
     * 
     * @return the requestorId value.
     */
    public String requestorId() {
        return this.requestorId;
    }

    /**
     * Get the expandedProperties property: Additional properties of principal, scope and role definition.
     * 
     * @return the expandedProperties value.
     */
    public ExpandedProperties expandedProperties() {
        return this.expandedProperties;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (roleDefinitionId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property roleDefinitionId in model RoleEligibilityScheduleRequestProperties"));
        }
        if (principalId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property principalId in model RoleEligibilityScheduleRequestProperties"));
        }
        if (requestType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property requestType in model RoleEligibilityScheduleRequestProperties"));
        }
        if (scheduleInfo() != null) {
            scheduleInfo().validate();
        }
        if (ticketInfo() != null) {
            ticketInfo().validate();
        }
        if (expandedProperties() != null) {
            expandedProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RoleEligibilityScheduleRequestProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("roleDefinitionId", this.roleDefinitionId);
        jsonWriter.writeStringField("principalId", this.principalId);
        jsonWriter.writeStringField("requestType", this.requestType == null ? null : this.requestType.toString());
        jsonWriter.writeJsonField("scheduleInfo", this.scheduleInfo);
        jsonWriter.writeStringField("targetRoleEligibilityScheduleId", this.targetRoleEligibilityScheduleId);
        jsonWriter.writeStringField("targetRoleEligibilityScheduleInstanceId",
            this.targetRoleEligibilityScheduleInstanceId);
        jsonWriter.writeStringField("justification", this.justification);
        jsonWriter.writeJsonField("ticketInfo", this.ticketInfo);
        jsonWriter.writeStringField("condition", this.condition);
        jsonWriter.writeStringField("conditionVersion", this.conditionVersion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoleEligibilityScheduleRequestProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoleEligibilityScheduleRequestProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RoleEligibilityScheduleRequestProperties.
     */
    public static RoleEligibilityScheduleRequestProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoleEligibilityScheduleRequestProperties deserializedRoleEligibilityScheduleRequestProperties
                = new RoleEligibilityScheduleRequestProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("roleDefinitionId".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.roleDefinitionId = reader.getString();
                } else if ("principalId".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.principalId = reader.getString();
                } else if ("requestType".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.requestType
                        = RequestType.fromString(reader.getString());
                } else if ("scope".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.scope = reader.getString();
                } else if ("principalType".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.principalType
                        = PrincipalType.fromString(reader.getString());
                } else if ("status".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.status = Status.fromString(reader.getString());
                } else if ("approvalId".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.approvalId = reader.getString();
                } else if ("scheduleInfo".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.scheduleInfo
                        = RoleEligibilityScheduleRequestPropertiesScheduleInfo.fromJson(reader);
                } else if ("targetRoleEligibilityScheduleId".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.targetRoleEligibilityScheduleId
                        = reader.getString();
                } else if ("targetRoleEligibilityScheduleInstanceId".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.targetRoleEligibilityScheduleInstanceId
                        = reader.getString();
                } else if ("justification".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.justification = reader.getString();
                } else if ("ticketInfo".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.ticketInfo
                        = RoleEligibilityScheduleRequestPropertiesTicketInfo.fromJson(reader);
                } else if ("condition".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.condition = reader.getString();
                } else if ("conditionVersion".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.conditionVersion = reader.getString();
                } else if ("createdOn".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.createdOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("requestorId".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.requestorId = reader.getString();
                } else if ("expandedProperties".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.expandedProperties
                        = ExpandedProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoleEligibilityScheduleRequestProperties;
        });
    }
}
