// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * teamsAppDefinition.
 */
@Fluent
public final class MicrosoftGraphTeamsAppDefinition extends MicrosoftGraphEntity {
    /*
     * The name of the app provided by the app developer.
     */
    private String displayName;

    /*
     * The ID from the Teams app manifest.
     */
    private String teamsAppId;

    /*
     * The version number of the application.
     */
    private String version;

    /*
     * teamsAppDefinition
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphTeamsAppDefinition class.
     */
    public MicrosoftGraphTeamsAppDefinition() {
    }

    /**
     * Get the displayName property: The name of the app provided by the app developer.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The name of the app provided by the app developer.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphTeamsAppDefinition object itself.
     */
    public MicrosoftGraphTeamsAppDefinition withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the teamsAppId property: The ID from the Teams app manifest.
     * 
     * @return the teamsAppId value.
     */
    public String teamsAppId() {
        return this.teamsAppId;
    }

    /**
     * Set the teamsAppId property: The ID from the Teams app manifest.
     * 
     * @param teamsAppId the teamsAppId value to set.
     * @return the MicrosoftGraphTeamsAppDefinition object itself.
     */
    public MicrosoftGraphTeamsAppDefinition withTeamsAppId(String teamsAppId) {
        this.teamsAppId = teamsAppId;
        return this;
    }

    /**
     * Get the version property: The version number of the application.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: The version number of the application.
     * 
     * @param version the version value to set.
     * @return the MicrosoftGraphTeamsAppDefinition object itself.
     */
    public MicrosoftGraphTeamsAppDefinition withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the additionalProperties property: teamsAppDefinition.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: teamsAppDefinition.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTeamsAppDefinition object itself.
     */
    public MicrosoftGraphTeamsAppDefinition withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphTeamsAppDefinition withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("teamsAppId", this.teamsAppId);
        jsonWriter.writeStringField("version", this.version);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphTeamsAppDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphTeamsAppDefinition if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphTeamsAppDefinition.
     */
    public static MicrosoftGraphTeamsAppDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphTeamsAppDefinition deserializedMicrosoftGraphTeamsAppDefinition
                = new MicrosoftGraphTeamsAppDefinition();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsAppDefinition.withId(reader.getString());
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsAppDefinition.displayName = reader.getString();
                } else if ("teamsAppId".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsAppDefinition.teamsAppId = reader.getString();
                } else if ("version".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsAppDefinition.version = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphTeamsAppDefinition.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphTeamsAppDefinition;
        });
    }
}
