// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Classic Administrator properties.
 */
@Fluent
public final class ClassicAdministratorProperties implements JsonSerializable<ClassicAdministratorProperties> {
    /*
     * The email address of the administrator.
     */
    private String emailAddress;

    /*
     * The role of the administrator.
     */
    private String role;

    /**
     * Creates an instance of ClassicAdministratorProperties class.
     */
    public ClassicAdministratorProperties() {
    }

    /**
     * Get the emailAddress property: The email address of the administrator.
     * 
     * @return the emailAddress value.
     */
    public String emailAddress() {
        return this.emailAddress;
    }

    /**
     * Set the emailAddress property: The email address of the administrator.
     * 
     * @param emailAddress the emailAddress value to set.
     * @return the ClassicAdministratorProperties object itself.
     */
    public ClassicAdministratorProperties withEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    /**
     * Get the role property: The role of the administrator.
     * 
     * @return the role value.
     */
    public String role() {
        return this.role;
    }

    /**
     * Set the role property: The role of the administrator.
     * 
     * @param role the role value to set.
     * @return the ClassicAdministratorProperties object itself.
     */
    public ClassicAdministratorProperties withRole(String role) {
        this.role = role;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("emailAddress", this.emailAddress);
        jsonWriter.writeStringField("role", this.role);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClassicAdministratorProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClassicAdministratorProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ClassicAdministratorProperties.
     */
    public static ClassicAdministratorProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClassicAdministratorProperties deserializedClassicAdministratorProperties
                = new ClassicAdministratorProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("emailAddress".equals(fieldName)) {
                    deserializedClassicAdministratorProperties.emailAddress = reader.getString();
                } else if ("role".equals(fieldName)) {
                    deserializedClassicAdministratorProperties.role = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClassicAdministratorProperties;
        });
    }
}
