// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.DenyAssignmentPermission;
import com.azure.resourcemanager.authorization.models.Principal;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Deny assignment properties.
 */
@Fluent
public final class DenyAssignmentProperties implements JsonSerializable<DenyAssignmentProperties> {
    /*
     * The display name of the deny assignment.
     */
    private String denyAssignmentName;

    /*
     * The description of the deny assignment.
     */
    private String description;

    /*
     * An array of permissions that are denied by the deny assignment.
     */
    private List<DenyAssignmentPermission> permissions;

    /*
     * The deny assignment scope.
     */
    private String scope;

    /*
     * Determines if the deny assignment applies to child scopes. Default value is false.
     */
    private Boolean doNotApplyToChildScopes;

    /*
     * Array of principals to which the deny assignment applies.
     */
    private List<Principal> principals;

    /*
     * Array of principals to which the deny assignment does not apply.
     */
    private List<Principal> excludePrincipals;

    /*
     * Specifies whether this deny assignment was created by Azure and cannot be edited or deleted.
     */
    private Boolean isSystemProtected;

    /*
     * The conditions on the deny assignment. This limits the resources it can be assigned to.
     * e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase
     * 'foo_storage_container'
     */
    private String condition;

    /*
     * Version of the condition.
     */
    private String conditionVersion;

    /*
     * Time it was created
     */
    private OffsetDateTime createdOn;

    /*
     * Time it was updated
     */
    private OffsetDateTime updatedOn;

    /*
     * Id of the user who created the assignment
     */
    private String createdBy;

    /*
     * Id of the user who updated the assignment
     */
    private String updatedBy;

    /**
     * Creates an instance of DenyAssignmentProperties class.
     */
    public DenyAssignmentProperties() {
    }

    /**
     * Get the denyAssignmentName property: The display name of the deny assignment.
     * 
     * @return the denyAssignmentName value.
     */
    public String denyAssignmentName() {
        return this.denyAssignmentName;
    }

    /**
     * Set the denyAssignmentName property: The display name of the deny assignment.
     * 
     * @param denyAssignmentName the denyAssignmentName value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withDenyAssignmentName(String denyAssignmentName) {
        this.denyAssignmentName = denyAssignmentName;
        return this;
    }

    /**
     * Get the description property: The description of the deny assignment.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description of the deny assignment.
     * 
     * @param description the description value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the permissions property: An array of permissions that are denied by the deny assignment.
     * 
     * @return the permissions value.
     */
    public List<DenyAssignmentPermission> permissions() {
        return this.permissions;
    }

    /**
     * Set the permissions property: An array of permissions that are denied by the deny assignment.
     * 
     * @param permissions the permissions value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withPermissions(List<DenyAssignmentPermission> permissions) {
        this.permissions = permissions;
        return this;
    }

    /**
     * Get the scope property: The deny assignment scope.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.scope;
    }

    /**
     * Set the scope property: The deny assignment scope.
     * 
     * @param scope the scope value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the doNotApplyToChildScopes property: Determines if the deny assignment applies to child scopes. Default
     * value is false.
     * 
     * @return the doNotApplyToChildScopes value.
     */
    public Boolean doNotApplyToChildScopes() {
        return this.doNotApplyToChildScopes;
    }

    /**
     * Set the doNotApplyToChildScopes property: Determines if the deny assignment applies to child scopes. Default
     * value is false.
     * 
     * @param doNotApplyToChildScopes the doNotApplyToChildScopes value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withDoNotApplyToChildScopes(Boolean doNotApplyToChildScopes) {
        this.doNotApplyToChildScopes = doNotApplyToChildScopes;
        return this;
    }

    /**
     * Get the principals property: Array of principals to which the deny assignment applies.
     * 
     * @return the principals value.
     */
    public List<Principal> principals() {
        return this.principals;
    }

    /**
     * Set the principals property: Array of principals to which the deny assignment applies.
     * 
     * @param principals the principals value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withPrincipals(List<Principal> principals) {
        this.principals = principals;
        return this;
    }

    /**
     * Get the excludePrincipals property: Array of principals to which the deny assignment does not apply.
     * 
     * @return the excludePrincipals value.
     */
    public List<Principal> excludePrincipals() {
        return this.excludePrincipals;
    }

    /**
     * Set the excludePrincipals property: Array of principals to which the deny assignment does not apply.
     * 
     * @param excludePrincipals the excludePrincipals value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withExcludePrincipals(List<Principal> excludePrincipals) {
        this.excludePrincipals = excludePrincipals;
        return this;
    }

    /**
     * Get the isSystemProtected property: Specifies whether this deny assignment was created by Azure and cannot be
     * edited or deleted.
     * 
     * @return the isSystemProtected value.
     */
    public Boolean isSystemProtected() {
        return this.isSystemProtected;
    }

    /**
     * Set the isSystemProtected property: Specifies whether this deny assignment was created by Azure and cannot be
     * edited or deleted.
     * 
     * @param isSystemProtected the isSystemProtected value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withIsSystemProtected(Boolean isSystemProtected) {
        this.isSystemProtected = isSystemProtected;
        return this;
    }

    /**
     * Get the condition property: The conditions on the deny assignment. This limits the resources it can be assigned
     * to. e.g.: &#064;Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     * StringEqualsIgnoreCase 'foo_storage_container'.
     * 
     * @return the condition value.
     */
    public String condition() {
        return this.condition;
    }

    /**
     * Set the condition property: The conditions on the deny assignment. This limits the resources it can be assigned
     * to. e.g.: &#064;Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     * StringEqualsIgnoreCase 'foo_storage_container'.
     * 
     * @param condition the condition value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    /**
     * Get the conditionVersion property: Version of the condition.
     * 
     * @return the conditionVersion value.
     */
    public String conditionVersion() {
        return this.conditionVersion;
    }

    /**
     * Set the conditionVersion property: Version of the condition.
     * 
     * @param conditionVersion the conditionVersion value to set.
     * @return the DenyAssignmentProperties object itself.
     */
    public DenyAssignmentProperties withConditionVersion(String conditionVersion) {
        this.conditionVersion = conditionVersion;
        return this;
    }

    /**
     * Get the createdOn property: Time it was created.
     * 
     * @return the createdOn value.
     */
    public OffsetDateTime createdOn() {
        return this.createdOn;
    }

    /**
     * Get the updatedOn property: Time it was updated.
     * 
     * @return the updatedOn value.
     */
    public OffsetDateTime updatedOn() {
        return this.updatedOn;
    }

    /**
     * Get the createdBy property: Id of the user who created the assignment.
     * 
     * @return the createdBy value.
     */
    public String createdBy() {
        return this.createdBy;
    }

    /**
     * Get the updatedBy property: Id of the user who updated the assignment.
     * 
     * @return the updatedBy value.
     */
    public String updatedBy() {
        return this.updatedBy;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (permissions() != null) {
            permissions().forEach(e -> e.validate());
        }
        if (principals() != null) {
            principals().forEach(e -> e.validate());
        }
        if (excludePrincipals() != null) {
            excludePrincipals().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("denyAssignmentName", this.denyAssignmentName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("permissions", this.permissions, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeBooleanField("doNotApplyToChildScopes", this.doNotApplyToChildScopes);
        jsonWriter.writeArrayField("principals", this.principals, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("excludePrincipals", this.excludePrincipals,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("isSystemProtected", this.isSystemProtected);
        jsonWriter.writeStringField("condition", this.condition);
        jsonWriter.writeStringField("conditionVersion", this.conditionVersion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DenyAssignmentProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DenyAssignmentProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DenyAssignmentProperties.
     */
    public static DenyAssignmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DenyAssignmentProperties deserializedDenyAssignmentProperties = new DenyAssignmentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("denyAssignmentName".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.denyAssignmentName = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.description = reader.getString();
                } else if ("permissions".equals(fieldName)) {
                    List<DenyAssignmentPermission> permissions
                        = reader.readArray(reader1 -> DenyAssignmentPermission.fromJson(reader1));
                    deserializedDenyAssignmentProperties.permissions = permissions;
                } else if ("scope".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.scope = reader.getString();
                } else if ("doNotApplyToChildScopes".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.doNotApplyToChildScopes
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("principals".equals(fieldName)) {
                    List<Principal> principals = reader.readArray(reader1 -> Principal.fromJson(reader1));
                    deserializedDenyAssignmentProperties.principals = principals;
                } else if ("excludePrincipals".equals(fieldName)) {
                    List<Principal> excludePrincipals = reader.readArray(reader1 -> Principal.fromJson(reader1));
                    deserializedDenyAssignmentProperties.excludePrincipals = excludePrincipals;
                } else if ("isSystemProtected".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.isSystemProtected = reader.getNullable(JsonReader::getBoolean);
                } else if ("condition".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.condition = reader.getString();
                } else if ("conditionVersion".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.conditionVersion = reader.getString();
                } else if ("createdOn".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.createdOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("updatedOn".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.updatedOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("createdBy".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.createdBy = reader.getString();
                } else if ("updatedBy".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.updatedBy = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDenyAssignmentProperties;
        });
    }
}
