// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * chatMessagePolicyViolationPolicyTip.
 */
@Fluent
public final class MicrosoftGraphChatMessagePolicyViolationPolicyTip
    implements JsonSerializable<MicrosoftGraphChatMessagePolicyViolationPolicyTip> {
    /*
     * The URL a user can visit to read about the data loss prevention policies for the organization. (ie, policies
     * about what users shouldn't say in chats)
     */
    private String complianceUrl;

    /*
     * Explanatory text shown to the sender of the message.
     */
    private String generalText;

    /*
     * The list of improper data in the message that was detected by the data loss prevention app. Each DLP app defines
     * its own conditions, examples include 'Credit Card Number' and 'Social Security Number'.
     */
    private List<String> matchedConditionDescriptions;

    /*
     * chatMessagePolicyViolationPolicyTip
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphChatMessagePolicyViolationPolicyTip class.
     */
    public MicrosoftGraphChatMessagePolicyViolationPolicyTip() {
    }

    /**
     * Get the complianceUrl property: The URL a user can visit to read about the data loss prevention policies for the
     * organization. (ie, policies about what users shouldn't say in chats).
     * 
     * @return the complianceUrl value.
     */
    public String complianceUrl() {
        return this.complianceUrl;
    }

    /**
     * Set the complianceUrl property: The URL a user can visit to read about the data loss prevention policies for the
     * organization. (ie, policies about what users shouldn't say in chats).
     * 
     * @param complianceUrl the complianceUrl value to set.
     * @return the MicrosoftGraphChatMessagePolicyViolationPolicyTip object itself.
     */
    public MicrosoftGraphChatMessagePolicyViolationPolicyTip withComplianceUrl(String complianceUrl) {
        this.complianceUrl = complianceUrl;
        return this;
    }

    /**
     * Get the generalText property: Explanatory text shown to the sender of the message.
     * 
     * @return the generalText value.
     */
    public String generalText() {
        return this.generalText;
    }

    /**
     * Set the generalText property: Explanatory text shown to the sender of the message.
     * 
     * @param generalText the generalText value to set.
     * @return the MicrosoftGraphChatMessagePolicyViolationPolicyTip object itself.
     */
    public MicrosoftGraphChatMessagePolicyViolationPolicyTip withGeneralText(String generalText) {
        this.generalText = generalText;
        return this;
    }

    /**
     * Get the matchedConditionDescriptions property: The list of improper data in the message that was detected by the
     * data loss prevention app. Each DLP app defines its own conditions, examples include 'Credit Card Number' and
     * 'Social Security Number'.
     * 
     * @return the matchedConditionDescriptions value.
     */
    public List<String> matchedConditionDescriptions() {
        return this.matchedConditionDescriptions;
    }

    /**
     * Set the matchedConditionDescriptions property: The list of improper data in the message that was detected by the
     * data loss prevention app. Each DLP app defines its own conditions, examples include 'Credit Card Number' and
     * 'Social Security Number'.
     * 
     * @param matchedConditionDescriptions the matchedConditionDescriptions value to set.
     * @return the MicrosoftGraphChatMessagePolicyViolationPolicyTip object itself.
     */
    public MicrosoftGraphChatMessagePolicyViolationPolicyTip
        withMatchedConditionDescriptions(List<String> matchedConditionDescriptions) {
        this.matchedConditionDescriptions = matchedConditionDescriptions;
        return this;
    }

    /**
     * Get the additionalProperties property: chatMessagePolicyViolationPolicyTip.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: chatMessagePolicyViolationPolicyTip.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphChatMessagePolicyViolationPolicyTip object itself.
     */
    public MicrosoftGraphChatMessagePolicyViolationPolicyTip
        withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("complianceUrl", this.complianceUrl);
        jsonWriter.writeStringField("generalText", this.generalText);
        jsonWriter.writeArrayField("matchedConditionDescriptions", this.matchedConditionDescriptions,
            (writer, element) -> writer.writeString(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphChatMessagePolicyViolationPolicyTip from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphChatMessagePolicyViolationPolicyTip if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphChatMessagePolicyViolationPolicyTip.
     */
    public static MicrosoftGraphChatMessagePolicyViolationPolicyTip fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphChatMessagePolicyViolationPolicyTip deserializedMicrosoftGraphChatMessagePolicyViolationPolicyTip
                = new MicrosoftGraphChatMessagePolicyViolationPolicyTip();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("complianceUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessagePolicyViolationPolicyTip.complianceUrl = reader.getString();
                } else if ("generalText".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessagePolicyViolationPolicyTip.generalText = reader.getString();
                } else if ("matchedConditionDescriptions".equals(fieldName)) {
                    List<String> matchedConditionDescriptions = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphChatMessagePolicyViolationPolicyTip.matchedConditionDescriptions
                        = matchedConditionDescriptions;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphChatMessagePolicyViolationPolicyTip.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphChatMessagePolicyViolationPolicyTip;
        });
    }
}
