// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * contentTypeInfo.
 */
@Fluent
public final class MicrosoftGraphContentTypeInfo implements JsonSerializable<MicrosoftGraphContentTypeInfo> {
    /*
     * The id of the content type.
     */
    private String id;

    /*
     * The name of the content type.
     */
    private String name;

    /*
     * contentTypeInfo
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphContentTypeInfo class.
     */
    public MicrosoftGraphContentTypeInfo() {
    }

    /**
     * Get the id property: The id of the content type.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The id of the content type.
     * 
     * @param id the id value to set.
     * @return the MicrosoftGraphContentTypeInfo object itself.
     */
    public MicrosoftGraphContentTypeInfo withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The name of the content type.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the content type.
     * 
     * @param name the name value to set.
     * @return the MicrosoftGraphContentTypeInfo object itself.
     */
    public MicrosoftGraphContentTypeInfo withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the additionalProperties property: contentTypeInfo.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: contentTypeInfo.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphContentTypeInfo object itself.
     */
    public MicrosoftGraphContentTypeInfo withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphContentTypeInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphContentTypeInfo if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphContentTypeInfo.
     */
    public static MicrosoftGraphContentTypeInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphContentTypeInfo deserializedMicrosoftGraphContentTypeInfo
                = new MicrosoftGraphContentTypeInfo();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphContentTypeInfo.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphContentTypeInfo.name = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphContentTypeInfo.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphContentTypeInfo;
        });
    }
}
