// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * directoryRole
 * 
 * Represents an Azure Active Directory object. The directoryObject type is the base type for many other directory
 * entity types.
 */
@Fluent
public final class MicrosoftGraphDirectoryRole extends MicrosoftGraphDirectoryObjectInner {
    /*
     * The description for the directory role. Read-only.
     */
    private String description;

    /*
     * The display name for the directory role. Read-only.
     */
    private String displayName;

    /*
     * The id of the directoryRoleTemplate that this role is based on. The property must be specified when activating a
     * directory role in a tenant with a POST operation. After the directory role has been activated, the property is
     * read only.
     */
    private String roleTemplateId;

    /*
     * Users that are members of this directory role. HTTP Methods: GET, POST, DELETE. Read-only. Nullable.
     */
    private List<MicrosoftGraphDirectoryObjectInner> members;

    /*
     * The scopedMembers property.
     */
    private List<MicrosoftGraphScopedRoleMembership> scopedMembers;

    /*
     * Represents an Azure Active Directory object. The directoryObject type is the base type for many other directory
     * entity types.
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphDirectoryRole class.
     */
    public MicrosoftGraphDirectoryRole() {
    }

    /**
     * Get the description property: The description for the directory role. Read-only.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description for the directory role. Read-only.
     * 
     * @param description the description value to set.
     * @return the MicrosoftGraphDirectoryRole object itself.
     */
    public MicrosoftGraphDirectoryRole withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the displayName property: The display name for the directory role. Read-only.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name for the directory role. Read-only.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphDirectoryRole object itself.
     */
    public MicrosoftGraphDirectoryRole withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the roleTemplateId property: The id of the directoryRoleTemplate that this role is based on. The property
     * must be specified when activating a directory role in a tenant with a POST operation. After the directory role
     * has been activated, the property is read only.
     * 
     * @return the roleTemplateId value.
     */
    public String roleTemplateId() {
        return this.roleTemplateId;
    }

    /**
     * Set the roleTemplateId property: The id of the directoryRoleTemplate that this role is based on. The property
     * must be specified when activating a directory role in a tenant with a POST operation. After the directory role
     * has been activated, the property is read only.
     * 
     * @param roleTemplateId the roleTemplateId value to set.
     * @return the MicrosoftGraphDirectoryRole object itself.
     */
    public MicrosoftGraphDirectoryRole withRoleTemplateId(String roleTemplateId) {
        this.roleTemplateId = roleTemplateId;
        return this;
    }

    /**
     * Get the members property: Users that are members of this directory role. HTTP Methods: GET, POST, DELETE.
     * Read-only. Nullable.
     * 
     * @return the members value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> members() {
        return this.members;
    }

    /**
     * Set the members property: Users that are members of this directory role. HTTP Methods: GET, POST, DELETE.
     * Read-only. Nullable.
     * 
     * @param members the members value to set.
     * @return the MicrosoftGraphDirectoryRole object itself.
     */
    public MicrosoftGraphDirectoryRole withMembers(List<MicrosoftGraphDirectoryObjectInner> members) {
        this.members = members;
        return this;
    }

    /**
     * Get the scopedMembers property: The scopedMembers property.
     * 
     * @return the scopedMembers value.
     */
    public List<MicrosoftGraphScopedRoleMembership> scopedMembers() {
        return this.scopedMembers;
    }

    /**
     * Set the scopedMembers property: The scopedMembers property.
     * 
     * @param scopedMembers the scopedMembers value to set.
     * @return the MicrosoftGraphDirectoryRole object itself.
     */
    public MicrosoftGraphDirectoryRole withScopedMembers(List<MicrosoftGraphScopedRoleMembership> scopedMembers) {
        this.scopedMembers = scopedMembers;
        return this;
    }

    /**
     * Get the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphDirectoryRole object itself.
     */
    public MicrosoftGraphDirectoryRole withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDirectoryRole withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDirectoryRole withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (members() != null) {
            members().forEach(e -> e.validate());
        }
        if (scopedMembers() != null) {
            scopedMembers().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("deletedDateTime",
            deletedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(deletedDateTime()));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("roleTemplateId", this.roleTemplateId);
        jsonWriter.writeArrayField("members", this.members, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("scopedMembers", this.scopedMembers, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphDirectoryRole from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphDirectoryRole if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphDirectoryRole.
     */
    public static MicrosoftGraphDirectoryRole fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphDirectoryRole deserializedMicrosoftGraphDirectoryRole = new MicrosoftGraphDirectoryRole();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphDirectoryRole.withId(reader.getString());
                } else if ("deletedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphDirectoryRole.withDeletedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphDirectoryRole.description = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphDirectoryRole.displayName = reader.getString();
                } else if ("roleTemplateId".equals(fieldName)) {
                    deserializedMicrosoftGraphDirectoryRole.roleTemplateId = reader.getString();
                } else if ("members".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> members
                        = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphDirectoryRole.members = members;
                } else if ("scopedMembers".equals(fieldName)) {
                    List<MicrosoftGraphScopedRoleMembership> scopedMembers
                        = reader.readArray(reader1 -> MicrosoftGraphScopedRoleMembership.fromJson(reader1));
                    deserializedMicrosoftGraphDirectoryRole.scopedMembers = scopedMembers;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphDirectoryRole.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphDirectoryRole;
        });
    }
}
