// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * permission.
 */
@Fluent
public final class MicrosoftGraphPermission extends MicrosoftGraphEntity {
    /*
     * A format of yyyy-MM-ddTHH:mm:ssZ of DateTimeOffset indicates the expiration time of the permission.
     * DateTime.MinValue indicates there is no expiration set for this permission. Optional.
     */
    private OffsetDateTime expirationDateTime;

    /*
     * identitySet
     */
    private MicrosoftGraphIdentitySet grantedTo;

    /*
     * For link type permissions, the details of the users to whom permission was granted. Read-only.
     */
    private List<MicrosoftGraphIdentitySet> grantedToIdentities;

    /*
     * This indicates whether password is set for this permission, it's only showing in response. Optional and Read-only
     * and for OneDrive Personal only.
     */
    private Boolean hasPassword;

    /*
     * itemReference
     */
    private MicrosoftGraphItemReference inheritedFrom;

    /*
     * sharingInvitation
     */
    private MicrosoftGraphSharingInvitation invitation;

    /*
     * sharingLink
     */
    private MicrosoftGraphSharingLink link;

    /*
     * The type of permission, e.g. read. See below for the full list of roles. Read-only.
     */
    private List<String> roles;

    /*
     * A unique token that can be used to access this shared item via the **shares** API. Read-only.
     */
    private String shareId;

    /*
     * permission
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPermission class.
     */
    public MicrosoftGraphPermission() {
    }

    /**
     * Get the expirationDateTime property: A format of yyyy-MM-ddTHH:mm:ssZ of DateTimeOffset indicates the expiration
     * time of the permission. DateTime.MinValue indicates there is no expiration set for this permission. Optional.
     * 
     * @return the expirationDateTime value.
     */
    public OffsetDateTime expirationDateTime() {
        return this.expirationDateTime;
    }

    /**
     * Set the expirationDateTime property: A format of yyyy-MM-ddTHH:mm:ssZ of DateTimeOffset indicates the expiration
     * time of the permission. DateTime.MinValue indicates there is no expiration set for this permission. Optional.
     * 
     * @param expirationDateTime the expirationDateTime value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withExpirationDateTime(OffsetDateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    /**
     * Get the grantedTo property: identitySet.
     * 
     * @return the grantedTo value.
     */
    public MicrosoftGraphIdentitySet grantedTo() {
        return this.grantedTo;
    }

    /**
     * Set the grantedTo property: identitySet.
     * 
     * @param grantedTo the grantedTo value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withGrantedTo(MicrosoftGraphIdentitySet grantedTo) {
        this.grantedTo = grantedTo;
        return this;
    }

    /**
     * Get the grantedToIdentities property: For link type permissions, the details of the users to whom permission was
     * granted. Read-only.
     * 
     * @return the grantedToIdentities value.
     */
    public List<MicrosoftGraphIdentitySet> grantedToIdentities() {
        return this.grantedToIdentities;
    }

    /**
     * Set the grantedToIdentities property: For link type permissions, the details of the users to whom permission was
     * granted. Read-only.
     * 
     * @param grantedToIdentities the grantedToIdentities value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withGrantedToIdentities(List<MicrosoftGraphIdentitySet> grantedToIdentities) {
        this.grantedToIdentities = grantedToIdentities;
        return this;
    }

    /**
     * Get the hasPassword property: This indicates whether password is set for this permission, it's only showing in
     * response. Optional and Read-only and for OneDrive Personal only.
     * 
     * @return the hasPassword value.
     */
    public Boolean hasPassword() {
        return this.hasPassword;
    }

    /**
     * Set the hasPassword property: This indicates whether password is set for this permission, it's only showing in
     * response. Optional and Read-only and for OneDrive Personal only.
     * 
     * @param hasPassword the hasPassword value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withHasPassword(Boolean hasPassword) {
        this.hasPassword = hasPassword;
        return this;
    }

    /**
     * Get the inheritedFrom property: itemReference.
     * 
     * @return the inheritedFrom value.
     */
    public MicrosoftGraphItemReference inheritedFrom() {
        return this.inheritedFrom;
    }

    /**
     * Set the inheritedFrom property: itemReference.
     * 
     * @param inheritedFrom the inheritedFrom value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withInheritedFrom(MicrosoftGraphItemReference inheritedFrom) {
        this.inheritedFrom = inheritedFrom;
        return this;
    }

    /**
     * Get the invitation property: sharingInvitation.
     * 
     * @return the invitation value.
     */
    public MicrosoftGraphSharingInvitation invitation() {
        return this.invitation;
    }

    /**
     * Set the invitation property: sharingInvitation.
     * 
     * @param invitation the invitation value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withInvitation(MicrosoftGraphSharingInvitation invitation) {
        this.invitation = invitation;
        return this;
    }

    /**
     * Get the link property: sharingLink.
     * 
     * @return the link value.
     */
    public MicrosoftGraphSharingLink link() {
        return this.link;
    }

    /**
     * Set the link property: sharingLink.
     * 
     * @param link the link value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withLink(MicrosoftGraphSharingLink link) {
        this.link = link;
        return this;
    }

    /**
     * Get the roles property: The type of permission, e.g. read. See below for the full list of roles. Read-only.
     * 
     * @return the roles value.
     */
    public List<String> roles() {
        return this.roles;
    }

    /**
     * Set the roles property: The type of permission, e.g. read. See below for the full list of roles. Read-only.
     * 
     * @param roles the roles value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withRoles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    /**
     * Get the shareId property: A unique token that can be used to access this shared item via the **shares** API.
     * Read-only.
     * 
     * @return the shareId value.
     */
    public String shareId() {
        return this.shareId;
    }

    /**
     * Set the shareId property: A unique token that can be used to access this shared item via the **shares** API.
     * Read-only.
     * 
     * @param shareId the shareId value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withShareId(String shareId) {
        this.shareId = shareId;
        return this;
    }

    /**
     * Get the additionalProperties property: permission.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: permission.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphPermission withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (grantedTo() != null) {
            grantedTo().validate();
        }
        if (grantedToIdentities() != null) {
            grantedToIdentities().forEach(e -> e.validate());
        }
        if (inheritedFrom() != null) {
            inheritedFrom().validate();
        }
        if (invitation() != null) {
            invitation().validate();
        }
        if (link() != null) {
            link().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("expirationDateTime",
            this.expirationDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDateTime));
        jsonWriter.writeJsonField("grantedTo", this.grantedTo);
        jsonWriter.writeArrayField("grantedToIdentities", this.grantedToIdentities,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("hasPassword", this.hasPassword);
        jsonWriter.writeJsonField("inheritedFrom", this.inheritedFrom);
        jsonWriter.writeJsonField("invitation", this.invitation);
        jsonWriter.writeJsonField("link", this.link);
        jsonWriter.writeArrayField("roles", this.roles, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("shareId", this.shareId);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPermission from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPermission if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPermission.
     */
    public static MicrosoftGraphPermission fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPermission deserializedMicrosoftGraphPermission = new MicrosoftGraphPermission();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphPermission.withId(reader.getString());
                } else if ("expirationDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphPermission.expirationDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("grantedTo".equals(fieldName)) {
                    deserializedMicrosoftGraphPermission.grantedTo = MicrosoftGraphIdentitySet.fromJson(reader);
                } else if ("grantedToIdentities".equals(fieldName)) {
                    List<MicrosoftGraphIdentitySet> grantedToIdentities
                        = reader.readArray(reader1 -> MicrosoftGraphIdentitySet.fromJson(reader1));
                    deserializedMicrosoftGraphPermission.grantedToIdentities = grantedToIdentities;
                } else if ("hasPassword".equals(fieldName)) {
                    deserializedMicrosoftGraphPermission.hasPassword = reader.getNullable(JsonReader::getBoolean);
                } else if ("inheritedFrom".equals(fieldName)) {
                    deserializedMicrosoftGraphPermission.inheritedFrom = MicrosoftGraphItemReference.fromJson(reader);
                } else if ("invitation".equals(fieldName)) {
                    deserializedMicrosoftGraphPermission.invitation = MicrosoftGraphSharingInvitation.fromJson(reader);
                } else if ("link".equals(fieldName)) {
                    deserializedMicrosoftGraphPermission.link = MicrosoftGraphSharingLink.fromJson(reader);
                } else if ("roles".equals(fieldName)) {
                    List<String> roles = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphPermission.roles = roles;
                } else if ("shareId".equals(fieldName)) {
                    deserializedMicrosoftGraphPermission.shareId = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPermission.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPermission;
        });
    }
}
