// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * privacyProfile.
 */
@Fluent
public final class MicrosoftGraphPrivacyProfile implements JsonSerializable<MicrosoftGraphPrivacyProfile> {
    /*
     * A valid smtp email address for the privacy statement contact. Not required.
     */
    private String contactEmail;

    /*
     * A valid URL format that begins with http:// or https://. Maximum length is 255 characters. The URL that directs
     * to the company's privacy statement. Not required.
     */
    private String statementUrl;

    /*
     * privacyProfile
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPrivacyProfile class.
     */
    public MicrosoftGraphPrivacyProfile() {
    }

    /**
     * Get the contactEmail property: A valid smtp email address for the privacy statement contact. Not required.
     * 
     * @return the contactEmail value.
     */
    public String contactEmail() {
        return this.contactEmail;
    }

    /**
     * Set the contactEmail property: A valid smtp email address for the privacy statement contact. Not required.
     * 
     * @param contactEmail the contactEmail value to set.
     * @return the MicrosoftGraphPrivacyProfile object itself.
     */
    public MicrosoftGraphPrivacyProfile withContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
        return this;
    }

    /**
     * Get the statementUrl property: A valid URL format that begins with http:// or https://. Maximum length is 255
     * characters. The URL that directs to the company's privacy statement. Not required.
     * 
     * @return the statementUrl value.
     */
    public String statementUrl() {
        return this.statementUrl;
    }

    /**
     * Set the statementUrl property: A valid URL format that begins with http:// or https://. Maximum length is 255
     * characters. The URL that directs to the company's privacy statement. Not required.
     * 
     * @param statementUrl the statementUrl value to set.
     * @return the MicrosoftGraphPrivacyProfile object itself.
     */
    public MicrosoftGraphPrivacyProfile withStatementUrl(String statementUrl) {
        this.statementUrl = statementUrl;
        return this;
    }

    /**
     * Get the additionalProperties property: privacyProfile.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: privacyProfile.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPrivacyProfile object itself.
     */
    public MicrosoftGraphPrivacyProfile withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contactEmail", this.contactEmail);
        jsonWriter.writeStringField("statementUrl", this.statementUrl);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPrivacyProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPrivacyProfile if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPrivacyProfile.
     */
    public static MicrosoftGraphPrivacyProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPrivacyProfile deserializedMicrosoftGraphPrivacyProfile = new MicrosoftGraphPrivacyProfile();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("contactEmail".equals(fieldName)) {
                    deserializedMicrosoftGraphPrivacyProfile.contactEmail = reader.getString();
                } else if ("statementUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphPrivacyProfile.statementUrl = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPrivacyProfile.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPrivacyProfile;
        });
    }
}
