// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * provisionedPlan.
 */
@Fluent
public final class MicrosoftGraphProvisionedPlan implements JsonSerializable<MicrosoftGraphProvisionedPlan> {
    /*
     * For example, 'Enabled'.
     */
    private String capabilityStatus;

    /*
     * For example, 'Success'.
     */
    private String provisioningStatus;

    /*
     * The name of the service; for example, 'AccessControlS2S'
     */
    private String service;

    /*
     * provisionedPlan
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphProvisionedPlan class.
     */
    public MicrosoftGraphProvisionedPlan() {
    }

    /**
     * Get the capabilityStatus property: For example, 'Enabled'.
     * 
     * @return the capabilityStatus value.
     */
    public String capabilityStatus() {
        return this.capabilityStatus;
    }

    /**
     * Set the capabilityStatus property: For example, 'Enabled'.
     * 
     * @param capabilityStatus the capabilityStatus value to set.
     * @return the MicrosoftGraphProvisionedPlan object itself.
     */
    public MicrosoftGraphProvisionedPlan withCapabilityStatus(String capabilityStatus) {
        this.capabilityStatus = capabilityStatus;
        return this;
    }

    /**
     * Get the provisioningStatus property: For example, 'Success'.
     * 
     * @return the provisioningStatus value.
     */
    public String provisioningStatus() {
        return this.provisioningStatus;
    }

    /**
     * Set the provisioningStatus property: For example, 'Success'.
     * 
     * @param provisioningStatus the provisioningStatus value to set.
     * @return the MicrosoftGraphProvisionedPlan object itself.
     */
    public MicrosoftGraphProvisionedPlan withProvisioningStatus(String provisioningStatus) {
        this.provisioningStatus = provisioningStatus;
        return this;
    }

    /**
     * Get the service property: The name of the service; for example, 'AccessControlS2S'.
     * 
     * @return the service value.
     */
    public String service() {
        return this.service;
    }

    /**
     * Set the service property: The name of the service; for example, 'AccessControlS2S'.
     * 
     * @param service the service value to set.
     * @return the MicrosoftGraphProvisionedPlan object itself.
     */
    public MicrosoftGraphProvisionedPlan withService(String service) {
        this.service = service;
        return this;
    }

    /**
     * Get the additionalProperties property: provisionedPlan.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: provisionedPlan.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphProvisionedPlan object itself.
     */
    public MicrosoftGraphProvisionedPlan withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("capabilityStatus", this.capabilityStatus);
        jsonWriter.writeStringField("provisioningStatus", this.provisioningStatus);
        jsonWriter.writeStringField("service", this.service);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphProvisionedPlan from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphProvisionedPlan if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphProvisionedPlan.
     */
    public static MicrosoftGraphProvisionedPlan fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphProvisionedPlan deserializedMicrosoftGraphProvisionedPlan
                = new MicrosoftGraphProvisionedPlan();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("capabilityStatus".equals(fieldName)) {
                    deserializedMicrosoftGraphProvisionedPlan.capabilityStatus = reader.getString();
                } else if ("provisioningStatus".equals(fieldName)) {
                    deserializedMicrosoftGraphProvisionedPlan.provisioningStatus = reader.getString();
                } else if ("service".equals(fieldName)) {
                    deserializedMicrosoftGraphProvisionedPlan.service = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphProvisionedPlan.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphProvisionedPlan;
        });
    }
}
