// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

/**
 * resourceAccess.
 */
@Fluent
public final class MicrosoftGraphResourceAccess implements JsonSerializable<MicrosoftGraphResourceAccess> {
    /*
     * The unique identifier for one of the oauth2PermissionScopes or appRole instances that the resource application
     * exposes.
     */
    private UUID id;

    /*
     * Specifies whether the id property references an oauth2PermissionScopes or an appRole. Possible values are Scope
     * or Role.
     */
    private String type;

    /*
     * resourceAccess
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphResourceAccess class.
     */
    public MicrosoftGraphResourceAccess() {
    }

    /**
     * Get the id property: The unique identifier for one of the oauth2PermissionScopes or appRole instances that the
     * resource application exposes.
     * 
     * @return the id value.
     */
    public UUID id() {
        return this.id;
    }

    /**
     * Set the id property: The unique identifier for one of the oauth2PermissionScopes or appRole instances that the
     * resource application exposes.
     * 
     * @param id the id value to set.
     * @return the MicrosoftGraphResourceAccess object itself.
     */
    public MicrosoftGraphResourceAccess withId(UUID id) {
        this.id = id;
        return this;
    }

    /**
     * Get the type property: Specifies whether the id property references an oauth2PermissionScopes or an appRole.
     * Possible values are Scope or Role.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Specifies whether the id property references an oauth2PermissionScopes or an appRole.
     * Possible values are Scope or Role.
     * 
     * @param type the type value to set.
     * @return the MicrosoftGraphResourceAccess object itself.
     */
    public MicrosoftGraphResourceAccess withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the additionalProperties property: resourceAccess.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: resourceAccess.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphResourceAccess object itself.
     */
    public MicrosoftGraphResourceAccess withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", Objects.toString(this.id, null));
        jsonWriter.writeStringField("type", this.type);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphResourceAccess from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphResourceAccess if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphResourceAccess.
     */
    public static MicrosoftGraphResourceAccess fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphResourceAccess deserializedMicrosoftGraphResourceAccess = new MicrosoftGraphResourceAccess();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphResourceAccess.id
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("type".equals(fieldName)) {
                    deserializedMicrosoftGraphResourceAccess.type = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphResourceAccess.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphResourceAccess;
        });
    }
}
