// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * site.
 */
@Fluent
public final class MicrosoftGraphSite extends MicrosoftGraphBaseItemInner {
    /*
     * The full title for the site. Read-only.
     */
    private String displayName;

    /*
     * publicError
     */
    private MicrosoftGraphPublicError error;

    /*
     * root
     */
    private Map<String, Object> root;

    /*
     * sharepointIds
     */
    private MicrosoftGraphSharepointIds sharepointIds;

    /*
     * siteCollection
     */
    private MicrosoftGraphSiteCollection siteCollection;

    /*
     * itemAnalytics
     */
    private MicrosoftGraphItemAnalytics analytics;

    /*
     * The collection of column definitions reusable across lists under this site.
     */
    private List<MicrosoftGraphColumnDefinition> columns;

    /*
     * The collection of content types defined for this site.
     */
    private List<MicrosoftGraphContentType> contentTypes;

    /*
     * drive
     */
    private MicrosoftGraphDrive drive;

    /*
     * The collection of drives (document libraries) under this site.
     */
    private List<MicrosoftGraphDrive> drives;

    /*
     * Used to address any item contained in this site. This collection cannot be enumerated.
     */
    private List<MicrosoftGraphBaseItemInner> items;

    /*
     * The collection of lists under this site.
     */
    private List<MicrosoftGraphList> lists;

    /*
     * The collection of the sub-sites under this site.
     */
    private List<MicrosoftGraphSite> sites;

    /*
     * onenote
     */
    private MicrosoftGraphOnenote onenote;

    /*
     * site
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphSite class.
     */
    public MicrosoftGraphSite() {
    }

    /**
     * Get the displayName property: The full title for the site. Read-only.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The full title for the site. Read-only.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the error property: publicError.
     * 
     * @return the error value.
     */
    public MicrosoftGraphPublicError error() {
        return this.error;
    }

    /**
     * Set the error property: publicError.
     * 
     * @param error the error value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withError(MicrosoftGraphPublicError error) {
        this.error = error;
        return this;
    }

    /**
     * Get the root property: root.
     * 
     * @return the root value.
     */
    public Map<String, Object> root() {
        return this.root;
    }

    /**
     * Set the root property: root.
     * 
     * @param root the root value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withRoot(Map<String, Object> root) {
        this.root = root;
        return this;
    }

    /**
     * Get the sharepointIds property: sharepointIds.
     * 
     * @return the sharepointIds value.
     */
    public MicrosoftGraphSharepointIds sharepointIds() {
        return this.sharepointIds;
    }

    /**
     * Set the sharepointIds property: sharepointIds.
     * 
     * @param sharepointIds the sharepointIds value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withSharepointIds(MicrosoftGraphSharepointIds sharepointIds) {
        this.sharepointIds = sharepointIds;
        return this;
    }

    /**
     * Get the siteCollection property: siteCollection.
     * 
     * @return the siteCollection value.
     */
    public MicrosoftGraphSiteCollection siteCollection() {
        return this.siteCollection;
    }

    /**
     * Set the siteCollection property: siteCollection.
     * 
     * @param siteCollection the siteCollection value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withSiteCollection(MicrosoftGraphSiteCollection siteCollection) {
        this.siteCollection = siteCollection;
        return this;
    }

    /**
     * Get the analytics property: itemAnalytics.
     * 
     * @return the analytics value.
     */
    public MicrosoftGraphItemAnalytics analytics() {
        return this.analytics;
    }

    /**
     * Set the analytics property: itemAnalytics.
     * 
     * @param analytics the analytics value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withAnalytics(MicrosoftGraphItemAnalytics analytics) {
        this.analytics = analytics;
        return this;
    }

    /**
     * Get the columns property: The collection of column definitions reusable across lists under this site.
     * 
     * @return the columns value.
     */
    public List<MicrosoftGraphColumnDefinition> columns() {
        return this.columns;
    }

    /**
     * Set the columns property: The collection of column definitions reusable across lists under this site.
     * 
     * @param columns the columns value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withColumns(List<MicrosoftGraphColumnDefinition> columns) {
        this.columns = columns;
        return this;
    }

    /**
     * Get the contentTypes property: The collection of content types defined for this site.
     * 
     * @return the contentTypes value.
     */
    public List<MicrosoftGraphContentType> contentTypes() {
        return this.contentTypes;
    }

    /**
     * Set the contentTypes property: The collection of content types defined for this site.
     * 
     * @param contentTypes the contentTypes value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withContentTypes(List<MicrosoftGraphContentType> contentTypes) {
        this.contentTypes = contentTypes;
        return this;
    }

    /**
     * Get the drive property: drive.
     * 
     * @return the drive value.
     */
    public MicrosoftGraphDrive drive() {
        return this.drive;
    }

    /**
     * Set the drive property: drive.
     * 
     * @param drive the drive value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withDrive(MicrosoftGraphDrive drive) {
        this.drive = drive;
        return this;
    }

    /**
     * Get the drives property: The collection of drives (document libraries) under this site.
     * 
     * @return the drives value.
     */
    public List<MicrosoftGraphDrive> drives() {
        return this.drives;
    }

    /**
     * Set the drives property: The collection of drives (document libraries) under this site.
     * 
     * @param drives the drives value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withDrives(List<MicrosoftGraphDrive> drives) {
        this.drives = drives;
        return this;
    }

    /**
     * Get the items property: Used to address any item contained in this site. This collection cannot be enumerated.
     * 
     * @return the items value.
     */
    public List<MicrosoftGraphBaseItemInner> items() {
        return this.items;
    }

    /**
     * Set the items property: Used to address any item contained in this site. This collection cannot be enumerated.
     * 
     * @param items the items value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withItems(List<MicrosoftGraphBaseItemInner> items) {
        this.items = items;
        return this;
    }

    /**
     * Get the lists property: The collection of lists under this site.
     * 
     * @return the lists value.
     */
    public List<MicrosoftGraphList> lists() {
        return this.lists;
    }

    /**
     * Set the lists property: The collection of lists under this site.
     * 
     * @param lists the lists value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withLists(List<MicrosoftGraphList> lists) {
        this.lists = lists;
        return this;
    }

    /**
     * Get the sites property: The collection of the sub-sites under this site.
     * 
     * @return the sites value.
     */
    public List<MicrosoftGraphSite> sites() {
        return this.sites;
    }

    /**
     * Set the sites property: The collection of the sub-sites under this site.
     * 
     * @param sites the sites value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withSites(List<MicrosoftGraphSite> sites) {
        this.sites = sites;
        return this;
    }

    /**
     * Get the onenote property: onenote.
     * 
     * @return the onenote value.
     */
    public MicrosoftGraphOnenote onenote() {
        return this.onenote;
    }

    /**
     * Set the onenote property: onenote.
     * 
     * @param onenote the onenote value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withOnenote(MicrosoftGraphOnenote onenote) {
        this.onenote = onenote;
        return this;
    }

    /**
     * Get the additionalProperties property: site.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: site.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSite withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        super.withCreatedBy(createdBy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSite withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSite withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSite withEtag(String etag) {
        super.withEtag(etag);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSite withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSite withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSite withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSite withParentReference(MicrosoftGraphItemReference parentReference) {
        super.withParentReference(parentReference);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSite withWebUrl(String webUrl) {
        super.withWebUrl(webUrl);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSite withCreatedByUser(MicrosoftGraphUserInner createdByUser) {
        super.withCreatedByUser(createdByUser);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSite withLastModifiedByUser(MicrosoftGraphUserInner lastModifiedByUser) {
        super.withLastModifiedByUser(lastModifiedByUser);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSite withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (error() != null) {
            error().validate();
        }
        if (sharepointIds() != null) {
            sharepointIds().validate();
        }
        if (siteCollection() != null) {
            siteCollection().validate();
        }
        if (analytics() != null) {
            analytics().validate();
        }
        if (columns() != null) {
            columns().forEach(e -> e.validate());
        }
        if (contentTypes() != null) {
            contentTypes().forEach(e -> e.validate());
        }
        if (drive() != null) {
            drive().validate();
        }
        if (drives() != null) {
            drives().forEach(e -> e.validate());
        }
        if (items() != null) {
            items().forEach(e -> e.validate());
        }
        if (lists() != null) {
            lists().forEach(e -> e.validate());
        }
        if (sites() != null) {
            sites().forEach(e -> e.validate());
        }
        if (onenote() != null) {
            onenote().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("createdBy", createdBy());
        jsonWriter.writeStringField("createdDateTime",
            createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(createdDateTime()));
        jsonWriter.writeStringField("description", description());
        jsonWriter.writeStringField("eTag", etag());
        jsonWriter.writeJsonField("lastModifiedBy", lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime",
            lastModifiedDateTime() == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(lastModifiedDateTime()));
        jsonWriter.writeStringField("name", name());
        jsonWriter.writeJsonField("parentReference", parentReference());
        jsonWriter.writeStringField("webUrl", webUrl());
        jsonWriter.writeJsonField("createdByUser", createdByUser());
        jsonWriter.writeJsonField("lastModifiedByUser", lastModifiedByUser());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeJsonField("error", this.error);
        jsonWriter.writeMapField("root", this.root, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("sharepointIds", this.sharepointIds);
        jsonWriter.writeJsonField("siteCollection", this.siteCollection);
        jsonWriter.writeJsonField("analytics", this.analytics);
        jsonWriter.writeArrayField("columns", this.columns, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("contentTypes", this.contentTypes, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("drive", this.drive);
        jsonWriter.writeArrayField("drives", this.drives, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("items", this.items, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("lists", this.lists, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("sites", this.sites, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("onenote", this.onenote);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphSite from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphSite if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphSite.
     */
    public static MicrosoftGraphSite fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphSite deserializedMicrosoftGraphSite = new MicrosoftGraphSite();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withId(reader.getString());
                } else if ("createdBy".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withCreatedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withCreatedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withDescription(reader.getString());
                } else if ("eTag".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withEtag(reader.getString());
                } else if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                } else if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withLastModifiedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withName(reader.getString());
                } else if ("parentReference".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withParentReference(MicrosoftGraphItemReference.fromJson(reader));
                } else if ("webUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withWebUrl(reader.getString());
                } else if ("createdByUser".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withCreatedByUser(MicrosoftGraphUserInner.fromJson(reader));
                } else if ("lastModifiedByUser".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withLastModifiedByUser(MicrosoftGraphUserInner.fromJson(reader));
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.displayName = reader.getString();
                } else if ("error".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.error = MicrosoftGraphPublicError.fromJson(reader);
                } else if ("root".equals(fieldName)) {
                    Map<String, Object> root = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedMicrosoftGraphSite.root = root;
                } else if ("sharepointIds".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.sharepointIds = MicrosoftGraphSharepointIds.fromJson(reader);
                } else if ("siteCollection".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.siteCollection = MicrosoftGraphSiteCollection.fromJson(reader);
                } else if ("analytics".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.analytics = MicrosoftGraphItemAnalytics.fromJson(reader);
                } else if ("columns".equals(fieldName)) {
                    List<MicrosoftGraphColumnDefinition> columns
                        = reader.readArray(reader1 -> MicrosoftGraphColumnDefinition.fromJson(reader1));
                    deserializedMicrosoftGraphSite.columns = columns;
                } else if ("contentTypes".equals(fieldName)) {
                    List<MicrosoftGraphContentType> contentTypes
                        = reader.readArray(reader1 -> MicrosoftGraphContentType.fromJson(reader1));
                    deserializedMicrosoftGraphSite.contentTypes = contentTypes;
                } else if ("drive".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.drive = MicrosoftGraphDrive.fromJson(reader);
                } else if ("drives".equals(fieldName)) {
                    List<MicrosoftGraphDrive> drives
                        = reader.readArray(reader1 -> MicrosoftGraphDrive.fromJson(reader1));
                    deserializedMicrosoftGraphSite.drives = drives;
                } else if ("items".equals(fieldName)) {
                    List<MicrosoftGraphBaseItemInner> items
                        = reader.readArray(reader1 -> MicrosoftGraphBaseItemInner.fromJson(reader1));
                    deserializedMicrosoftGraphSite.items = items;
                } else if ("lists".equals(fieldName)) {
                    List<MicrosoftGraphList> lists = reader.readArray(reader1 -> MicrosoftGraphList.fromJson(reader1));
                    deserializedMicrosoftGraphSite.lists = lists;
                } else if ("sites".equals(fieldName)) {
                    List<MicrosoftGraphSite> sites = reader.readArray(reader1 -> MicrosoftGraphSite.fromJson(reader1));
                    deserializedMicrosoftGraphSite.sites = sites;
                } else if ("onenote".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.onenote = MicrosoftGraphOnenote.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphSite.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphSite;
        });
    }
}
