// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * visualInfo.
 */
@Fluent
public final class MicrosoftGraphVisualInfo implements JsonSerializable<MicrosoftGraphVisualInfo> {
    /*
     * imageInfo
     */
    private MicrosoftGraphImageInfo attribution;

    /*
     * Optional. Background color used to render the activity in the UI - brand color for the application source of the
     * activity. Must be a valid hex color
     */
    private String backgroundColor;

    /*
     * Json
     */
    private Map<String, Object> content;

    /*
     * The description property.
     */
    private String description;

    /*
     * Required. Short text description of the user's unique activity (for example, document name in cases where an
     * activity refers to document creation)
     */
    private String displayText;

    /*
     * visualInfo
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphVisualInfo class.
     */
    public MicrosoftGraphVisualInfo() {
    }

    /**
     * Get the attribution property: imageInfo.
     * 
     * @return the attribution value.
     */
    public MicrosoftGraphImageInfo attribution() {
        return this.attribution;
    }

    /**
     * Set the attribution property: imageInfo.
     * 
     * @param attribution the attribution value to set.
     * @return the MicrosoftGraphVisualInfo object itself.
     */
    public MicrosoftGraphVisualInfo withAttribution(MicrosoftGraphImageInfo attribution) {
        this.attribution = attribution;
        return this;
    }

    /**
     * Get the backgroundColor property: Optional. Background color used to render the activity in the UI - brand color
     * for the application source of the activity. Must be a valid hex color.
     * 
     * @return the backgroundColor value.
     */
    public String backgroundColor() {
        return this.backgroundColor;
    }

    /**
     * Set the backgroundColor property: Optional. Background color used to render the activity in the UI - brand color
     * for the application source of the activity. Must be a valid hex color.
     * 
     * @param backgroundColor the backgroundColor value to set.
     * @return the MicrosoftGraphVisualInfo object itself.
     */
    public MicrosoftGraphVisualInfo withBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    /**
     * Get the content property: Json.
     * 
     * @return the content value.
     */
    public Map<String, Object> content() {
        return this.content;
    }

    /**
     * Set the content property: Json.
     * 
     * @param content the content value to set.
     * @return the MicrosoftGraphVisualInfo object itself.
     */
    public MicrosoftGraphVisualInfo withContent(Map<String, Object> content) {
        this.content = content;
        return this;
    }

    /**
     * Get the description property: The description property.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description property.
     * 
     * @param description the description value to set.
     * @return the MicrosoftGraphVisualInfo object itself.
     */
    public MicrosoftGraphVisualInfo withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the displayText property: Required. Short text description of the user's unique activity (for example,
     * document name in cases where an activity refers to document creation).
     * 
     * @return the displayText value.
     */
    public String displayText() {
        return this.displayText;
    }

    /**
     * Set the displayText property: Required. Short text description of the user's unique activity (for example,
     * document name in cases where an activity refers to document creation).
     * 
     * @param displayText the displayText value to set.
     * @return the MicrosoftGraphVisualInfo object itself.
     */
    public MicrosoftGraphVisualInfo withDisplayText(String displayText) {
        this.displayText = displayText;
        return this;
    }

    /**
     * Get the additionalProperties property: visualInfo.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: visualInfo.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphVisualInfo object itself.
     */
    public MicrosoftGraphVisualInfo withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (attribution() != null) {
            attribution().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("attribution", this.attribution);
        jsonWriter.writeStringField("backgroundColor", this.backgroundColor);
        jsonWriter.writeMapField("content", this.content, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("displayText", this.displayText);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphVisualInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphVisualInfo if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphVisualInfo.
     */
    public static MicrosoftGraphVisualInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphVisualInfo deserializedMicrosoftGraphVisualInfo = new MicrosoftGraphVisualInfo();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("attribution".equals(fieldName)) {
                    deserializedMicrosoftGraphVisualInfo.attribution = MicrosoftGraphImageInfo.fromJson(reader);
                } else if ("backgroundColor".equals(fieldName)) {
                    deserializedMicrosoftGraphVisualInfo.backgroundColor = reader.getString();
                } else if ("content".equals(fieldName)) {
                    Map<String, Object> content = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedMicrosoftGraphVisualInfo.content = content;
                } else if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphVisualInfo.description = reader.getString();
                } else if ("displayText".equals(fieldName)) {
                    deserializedMicrosoftGraphVisualInfo.displayText = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphVisualInfo.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphVisualInfo;
        });
    }
}
