// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * website.
 */
@Fluent
public final class MicrosoftGraphWebsite implements JsonSerializable<MicrosoftGraphWebsite> {
    /*
     * The URL of the website.
     */
    private String address;

    /*
     * The display name of the web site.
     */
    private String displayName;

    /*
     * websiteType
     */
    private MicrosoftGraphWebsiteType type;

    /*
     * website
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWebsite class.
     */
    public MicrosoftGraphWebsite() {
    }

    /**
     * Get the address property: The URL of the website.
     * 
     * @return the address value.
     */
    public String address() {
        return this.address;
    }

    /**
     * Set the address property: The URL of the website.
     * 
     * @param address the address value to set.
     * @return the MicrosoftGraphWebsite object itself.
     */
    public MicrosoftGraphWebsite withAddress(String address) {
        this.address = address;
        return this;
    }

    /**
     * Get the displayName property: The display name of the web site.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name of the web site.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphWebsite object itself.
     */
    public MicrosoftGraphWebsite withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the type property: websiteType.
     * 
     * @return the type value.
     */
    public MicrosoftGraphWebsiteType type() {
        return this.type;
    }

    /**
     * Set the type property: websiteType.
     * 
     * @param type the type value to set.
     * @return the MicrosoftGraphWebsite object itself.
     */
    public MicrosoftGraphWebsite withType(MicrosoftGraphWebsiteType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the additionalProperties property: website.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: website.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWebsite object itself.
     */
    public MicrosoftGraphWebsite withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("address", this.address);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWebsite from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWebsite if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWebsite.
     */
    public static MicrosoftGraphWebsite fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWebsite deserializedMicrosoftGraphWebsite = new MicrosoftGraphWebsite();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("address".equals(fieldName)) {
                    deserializedMicrosoftGraphWebsite.address = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphWebsite.displayName = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedMicrosoftGraphWebsite.type = MicrosoftGraphWebsiteType.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWebsite.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWebsite;
        });
    }
}
