// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * workbookFilterCriteria.
 */
@Fluent
public final class MicrosoftGraphWorkbookFilterCriteria
    implements JsonSerializable<MicrosoftGraphWorkbookFilterCriteria> {
    /*
     * The color property.
     */
    private String color;

    /*
     * The criterion1 property.
     */
    private String criterion1;

    /*
     * The criterion2 property.
     */
    private String criterion2;

    /*
     * The dynamicCriteria property.
     */
    private String dynamicCriteria;

    /*
     * The filterOn property.
     */
    private String filterOn;

    /*
     * workbookIcon
     */
    private MicrosoftGraphWorkbookIcon icon;

    /*
     * The operator property.
     */
    private String operator;

    /*
     * Json
     */
    private Map<String, Object> values;

    /*
     * workbookFilterCriteria
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookFilterCriteria class.
     */
    public MicrosoftGraphWorkbookFilterCriteria() {
    }

    /**
     * Get the color property: The color property.
     * 
     * @return the color value.
     */
    public String color() {
        return this.color;
    }

    /**
     * Set the color property: The color property.
     * 
     * @param color the color value to set.
     * @return the MicrosoftGraphWorkbookFilterCriteria object itself.
     */
    public MicrosoftGraphWorkbookFilterCriteria withColor(String color) {
        this.color = color;
        return this;
    }

    /**
     * Get the criterion1 property: The criterion1 property.
     * 
     * @return the criterion1 value.
     */
    public String criterion1() {
        return this.criterion1;
    }

    /**
     * Set the criterion1 property: The criterion1 property.
     * 
     * @param criterion1 the criterion1 value to set.
     * @return the MicrosoftGraphWorkbookFilterCriteria object itself.
     */
    public MicrosoftGraphWorkbookFilterCriteria withCriterion1(String criterion1) {
        this.criterion1 = criterion1;
        return this;
    }

    /**
     * Get the criterion2 property: The criterion2 property.
     * 
     * @return the criterion2 value.
     */
    public String criterion2() {
        return this.criterion2;
    }

    /**
     * Set the criterion2 property: The criterion2 property.
     * 
     * @param criterion2 the criterion2 value to set.
     * @return the MicrosoftGraphWorkbookFilterCriteria object itself.
     */
    public MicrosoftGraphWorkbookFilterCriteria withCriterion2(String criterion2) {
        this.criterion2 = criterion2;
        return this;
    }

    /**
     * Get the dynamicCriteria property: The dynamicCriteria property.
     * 
     * @return the dynamicCriteria value.
     */
    public String dynamicCriteria() {
        return this.dynamicCriteria;
    }

    /**
     * Set the dynamicCriteria property: The dynamicCriteria property.
     * 
     * @param dynamicCriteria the dynamicCriteria value to set.
     * @return the MicrosoftGraphWorkbookFilterCriteria object itself.
     */
    public MicrosoftGraphWorkbookFilterCriteria withDynamicCriteria(String dynamicCriteria) {
        this.dynamicCriteria = dynamicCriteria;
        return this;
    }

    /**
     * Get the filterOn property: The filterOn property.
     * 
     * @return the filterOn value.
     */
    public String filterOn() {
        return this.filterOn;
    }

    /**
     * Set the filterOn property: The filterOn property.
     * 
     * @param filterOn the filterOn value to set.
     * @return the MicrosoftGraphWorkbookFilterCriteria object itself.
     */
    public MicrosoftGraphWorkbookFilterCriteria withFilterOn(String filterOn) {
        this.filterOn = filterOn;
        return this;
    }

    /**
     * Get the icon property: workbookIcon.
     * 
     * @return the icon value.
     */
    public MicrosoftGraphWorkbookIcon icon() {
        return this.icon;
    }

    /**
     * Set the icon property: workbookIcon.
     * 
     * @param icon the icon value to set.
     * @return the MicrosoftGraphWorkbookFilterCriteria object itself.
     */
    public MicrosoftGraphWorkbookFilterCriteria withIcon(MicrosoftGraphWorkbookIcon icon) {
        this.icon = icon;
        return this;
    }

    /**
     * Get the operator property: The operator property.
     * 
     * @return the operator value.
     */
    public String operator() {
        return this.operator;
    }

    /**
     * Set the operator property: The operator property.
     * 
     * @param operator the operator value to set.
     * @return the MicrosoftGraphWorkbookFilterCriteria object itself.
     */
    public MicrosoftGraphWorkbookFilterCriteria withOperator(String operator) {
        this.operator = operator;
        return this;
    }

    /**
     * Get the values property: Json.
     * 
     * @return the values value.
     */
    public Map<String, Object> values() {
        return this.values;
    }

    /**
     * Set the values property: Json.
     * 
     * @param values the values value to set.
     * @return the MicrosoftGraphWorkbookFilterCriteria object itself.
     */
    public MicrosoftGraphWorkbookFilterCriteria withValues(Map<String, Object> values) {
        this.values = values;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookFilterCriteria.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookFilterCriteria.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookFilterCriteria object itself.
     */
    public MicrosoftGraphWorkbookFilterCriteria withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (icon() != null) {
            icon().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("color", this.color);
        jsonWriter.writeStringField("criterion1", this.criterion1);
        jsonWriter.writeStringField("criterion2", this.criterion2);
        jsonWriter.writeStringField("dynamicCriteria", this.dynamicCriteria);
        jsonWriter.writeStringField("filterOn", this.filterOn);
        jsonWriter.writeJsonField("icon", this.icon);
        jsonWriter.writeStringField("operator", this.operator);
        jsonWriter.writeMapField("values", this.values, (writer, element) -> writer.writeUntyped(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookFilterCriteria from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookFilterCriteria if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookFilterCriteria.
     */
    public static MicrosoftGraphWorkbookFilterCriteria fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookFilterCriteria deserializedMicrosoftGraphWorkbookFilterCriteria
                = new MicrosoftGraphWorkbookFilterCriteria();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("color".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookFilterCriteria.color = reader.getString();
                } else if ("criterion1".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookFilterCriteria.criterion1 = reader.getString();
                } else if ("criterion2".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookFilterCriteria.criterion2 = reader.getString();
                } else if ("dynamicCriteria".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookFilterCriteria.dynamicCriteria = reader.getString();
                } else if ("filterOn".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookFilterCriteria.filterOn = reader.getString();
                } else if ("icon".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookFilterCriteria.icon = MicrosoftGraphWorkbookIcon.fromJson(reader);
                } else if ("operator".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookFilterCriteria.operator = reader.getString();
                } else if ("values".equals(fieldName)) {
                    Map<String, Object> values = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedMicrosoftGraphWorkbookFilterCriteria.values = values;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookFilterCriteria.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookFilterCriteria;
        });
    }
}
