// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.PolicyProperties;
import com.azure.resourcemanager.authorization.models.Principal;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyRule;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Role management policy properties with scope.
 */
@Fluent
public final class RoleManagementPolicyProperties implements JsonSerializable<RoleManagementPolicyProperties> {
    /*
     * The role management policy scope.
     */
    private String scope;

    /*
     * The role management policy display name.
     */
    private String displayName;

    /*
     * The role management policy description.
     */
    private String description;

    /*
     * The role management policy is default policy.
     */
    private Boolean isOrganizationDefault;

    /*
     * The name of the entity last modified it
     */
    private Principal lastModifiedBy;

    /*
     * The last modified date time.
     */
    private OffsetDateTime lastModifiedDateTime;

    /*
     * The rule applied to the policy.
     */
    private List<RoleManagementPolicyRule> rules;

    /*
     * The readonly computed rule applied to the policy.
     */
    private List<RoleManagementPolicyRule> effectiveRules;

    /*
     * Additional properties of scope
     */
    private PolicyProperties policyProperties;

    /**
     * Creates an instance of RoleManagementPolicyProperties class.
     */
    public RoleManagementPolicyProperties() {
    }

    /**
     * Get the scope property: The role management policy scope.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.scope;
    }

    /**
     * Set the scope property: The role management policy scope.
     * 
     * @param scope the scope value to set.
     * @return the RoleManagementPolicyProperties object itself.
     */
    public RoleManagementPolicyProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the displayName property: The role management policy display name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The role management policy display name.
     * 
     * @param displayName the displayName value to set.
     * @return the RoleManagementPolicyProperties object itself.
     */
    public RoleManagementPolicyProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: The role management policy description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The role management policy description.
     * 
     * @param description the description value to set.
     * @return the RoleManagementPolicyProperties object itself.
     */
    public RoleManagementPolicyProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the isOrganizationDefault property: The role management policy is default policy.
     * 
     * @return the isOrganizationDefault value.
     */
    public Boolean isOrganizationDefault() {
        return this.isOrganizationDefault;
    }

    /**
     * Set the isOrganizationDefault property: The role management policy is default policy.
     * 
     * @param isOrganizationDefault the isOrganizationDefault value to set.
     * @return the RoleManagementPolicyProperties object itself.
     */
    public RoleManagementPolicyProperties withIsOrganizationDefault(Boolean isOrganizationDefault) {
        this.isOrganizationDefault = isOrganizationDefault;
        return this;
    }

    /**
     * Get the lastModifiedBy property: The name of the entity last modified it.
     * 
     * @return the lastModifiedBy value.
     */
    public Principal lastModifiedBy() {
        return this.lastModifiedBy;
    }

    /**
     * Get the lastModifiedDateTime property: The last modified date time.
     * 
     * @return the lastModifiedDateTime value.
     */
    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    /**
     * Get the rules property: The rule applied to the policy.
     * 
     * @return the rules value.
     */
    public List<RoleManagementPolicyRule> rules() {
        return this.rules;
    }

    /**
     * Set the rules property: The rule applied to the policy.
     * 
     * @param rules the rules value to set.
     * @return the RoleManagementPolicyProperties object itself.
     */
    public RoleManagementPolicyProperties withRules(List<RoleManagementPolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    /**
     * Get the effectiveRules property: The readonly computed rule applied to the policy.
     * 
     * @return the effectiveRules value.
     */
    public List<RoleManagementPolicyRule> effectiveRules() {
        return this.effectiveRules;
    }

    /**
     * Get the policyProperties property: Additional properties of scope.
     * 
     * @return the policyProperties value.
     */
    public PolicyProperties policyProperties() {
        return this.policyProperties;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (lastModifiedBy() != null) {
            lastModifiedBy().validate();
        }
        if (rules() != null) {
            rules().forEach(e -> e.validate());
        }
        if (effectiveRules() != null) {
            effectiveRules().forEach(e -> e.validate());
        }
        if (policyProperties() != null) {
            policyProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeBooleanField("isOrganizationDefault", this.isOrganizationDefault);
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoleManagementPolicyProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoleManagementPolicyProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RoleManagementPolicyProperties.
     */
    public static RoleManagementPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoleManagementPolicyProperties deserializedRoleManagementPolicyProperties
                = new RoleManagementPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("scope".equals(fieldName)) {
                    deserializedRoleManagementPolicyProperties.scope = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedRoleManagementPolicyProperties.displayName = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedRoleManagementPolicyProperties.description = reader.getString();
                } else if ("isOrganizationDefault".equals(fieldName)) {
                    deserializedRoleManagementPolicyProperties.isOrganizationDefault
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("lastModifiedBy".equals(fieldName)) {
                    deserializedRoleManagementPolicyProperties.lastModifiedBy = Principal.fromJson(reader);
                } else if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedRoleManagementPolicyProperties.lastModifiedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("rules".equals(fieldName)) {
                    List<RoleManagementPolicyRule> rules
                        = reader.readArray(reader1 -> RoleManagementPolicyRule.fromJson(reader1));
                    deserializedRoleManagementPolicyProperties.rules = rules;
                } else if ("effectiveRules".equals(fieldName)) {
                    List<RoleManagementPolicyRule> effectiveRules
                        = reader.readArray(reader1 -> RoleManagementPolicyRule.fromJson(reader1));
                    deserializedRoleManagementPolicyProperties.effectiveRules = effectiveRules;
                } else if ("policyProperties".equals(fieldName)) {
                    deserializedRoleManagementPolicyProperties.policyProperties = PolicyProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoleManagementPolicyProperties;
        });
    }
}
