// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.RoleAssignmentInner;
import java.io.IOException;
import java.util.List;

/**
 * Role assignment list operation result.
 */
@Fluent
public final class RoleAssignmentListResult implements JsonSerializable<RoleAssignmentListResult> {
    /*
     * Role assignment list.
     */
    private List<RoleAssignmentInner> value;

    /*
     * The skipToken to use for getting the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of RoleAssignmentListResult class.
     */
    public RoleAssignmentListResult() {
    }

    /**
     * Get the value property: Role assignment list.
     * 
     * @return the value value.
     */
    public List<RoleAssignmentInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Role assignment list.
     * 
     * @param value the value value to set.
     * @return the RoleAssignmentListResult object itself.
     */
    public RoleAssignmentListResult withValue(List<RoleAssignmentInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The skipToken to use for getting the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoleAssignmentListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoleAssignmentListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RoleAssignmentListResult.
     */
    public static RoleAssignmentListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoleAssignmentListResult deserializedRoleAssignmentListResult = new RoleAssignmentListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<RoleAssignmentInner> value
                        = reader.readArray(reader1 -> RoleAssignmentInner.fromJson(reader1));
                    deserializedRoleAssignmentListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedRoleAssignmentListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoleAssignmentListResult;
        });
    }
}
