// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The role management policy rule target.
 */
@Fluent
public final class RoleManagementPolicyRuleTarget implements JsonSerializable<RoleManagementPolicyRuleTarget> {
    /*
     * The caller of the setting.
     */
    private String caller;

    /*
     * The type of operation.
     */
    private List<String> operations;

    /*
     * The assignment level to which rule is applied.
     */
    private String level;

    /*
     * The list of target objects.
     */
    private List<String> targetObjects;

    /*
     * The list of inheritable settings.
     */
    private List<String> inheritableSettings;

    /*
     * The list of enforced settings.
     */
    private List<String> enforcedSettings;

    /**
     * Creates an instance of RoleManagementPolicyRuleTarget class.
     */
    public RoleManagementPolicyRuleTarget() {
    }

    /**
     * Get the caller property: The caller of the setting.
     * 
     * @return the caller value.
     */
    public String caller() {
        return this.caller;
    }

    /**
     * Set the caller property: The caller of the setting.
     * 
     * @param caller the caller value to set.
     * @return the RoleManagementPolicyRuleTarget object itself.
     */
    public RoleManagementPolicyRuleTarget withCaller(String caller) {
        this.caller = caller;
        return this;
    }

    /**
     * Get the operations property: The type of operation.
     * 
     * @return the operations value.
     */
    public List<String> operations() {
        return this.operations;
    }

    /**
     * Set the operations property: The type of operation.
     * 
     * @param operations the operations value to set.
     * @return the RoleManagementPolicyRuleTarget object itself.
     */
    public RoleManagementPolicyRuleTarget withOperations(List<String> operations) {
        this.operations = operations;
        return this;
    }

    /**
     * Get the level property: The assignment level to which rule is applied.
     * 
     * @return the level value.
     */
    public String level() {
        return this.level;
    }

    /**
     * Set the level property: The assignment level to which rule is applied.
     * 
     * @param level the level value to set.
     * @return the RoleManagementPolicyRuleTarget object itself.
     */
    public RoleManagementPolicyRuleTarget withLevel(String level) {
        this.level = level;
        return this;
    }

    /**
     * Get the targetObjects property: The list of target objects.
     * 
     * @return the targetObjects value.
     */
    public List<String> targetObjects() {
        return this.targetObjects;
    }

    /**
     * Set the targetObjects property: The list of target objects.
     * 
     * @param targetObjects the targetObjects value to set.
     * @return the RoleManagementPolicyRuleTarget object itself.
     */
    public RoleManagementPolicyRuleTarget withTargetObjects(List<String> targetObjects) {
        this.targetObjects = targetObjects;
        return this;
    }

    /**
     * Get the inheritableSettings property: The list of inheritable settings.
     * 
     * @return the inheritableSettings value.
     */
    public List<String> inheritableSettings() {
        return this.inheritableSettings;
    }

    /**
     * Set the inheritableSettings property: The list of inheritable settings.
     * 
     * @param inheritableSettings the inheritableSettings value to set.
     * @return the RoleManagementPolicyRuleTarget object itself.
     */
    public RoleManagementPolicyRuleTarget withInheritableSettings(List<String> inheritableSettings) {
        this.inheritableSettings = inheritableSettings;
        return this;
    }

    /**
     * Get the enforcedSettings property: The list of enforced settings.
     * 
     * @return the enforcedSettings value.
     */
    public List<String> enforcedSettings() {
        return this.enforcedSettings;
    }

    /**
     * Set the enforcedSettings property: The list of enforced settings.
     * 
     * @param enforcedSettings the enforcedSettings value to set.
     * @return the RoleManagementPolicyRuleTarget object itself.
     */
    public RoleManagementPolicyRuleTarget withEnforcedSettings(List<String> enforcedSettings) {
        this.enforcedSettings = enforcedSettings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("caller", this.caller);
        jsonWriter.writeArrayField("operations", this.operations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("level", this.level);
        jsonWriter.writeArrayField("targetObjects", this.targetObjects,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("inheritableSettings", this.inheritableSettings,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("enforcedSettings", this.enforcedSettings,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoleManagementPolicyRuleTarget from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoleManagementPolicyRuleTarget if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RoleManagementPolicyRuleTarget.
     */
    public static RoleManagementPolicyRuleTarget fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoleManagementPolicyRuleTarget deserializedRoleManagementPolicyRuleTarget
                = new RoleManagementPolicyRuleTarget();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("caller".equals(fieldName)) {
                    deserializedRoleManagementPolicyRuleTarget.caller = reader.getString();
                } else if ("operations".equals(fieldName)) {
                    List<String> operations = reader.readArray(reader1 -> reader1.getString());
                    deserializedRoleManagementPolicyRuleTarget.operations = operations;
                } else if ("level".equals(fieldName)) {
                    deserializedRoleManagementPolicyRuleTarget.level = reader.getString();
                } else if ("targetObjects".equals(fieldName)) {
                    List<String> targetObjects = reader.readArray(reader1 -> reader1.getString());
                    deserializedRoleManagementPolicyRuleTarget.targetObjects = targetObjects;
                } else if ("inheritableSettings".equals(fieldName)) {
                    List<String> inheritableSettings = reader.readArray(reader1 -> reader1.getString());
                    deserializedRoleManagementPolicyRuleTarget.inheritableSettings = inheritableSettings;
                } else if ("enforcedSettings".equals(fieldName)) {
                    List<String> enforcedSettings = reader.readArray(reader1 -> reader1.getString());
                    deserializedRoleManagementPolicyRuleTarget.enforcedSettings = enforcedSettings;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoleManagementPolicyRuleTarget;
        });
    }
}
