// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * alternativeSecurityId.
 */
@Fluent
public final class MicrosoftGraphAlternativeSecurityId
    implements JsonSerializable<MicrosoftGraphAlternativeSecurityId> {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    /*
     * For internal use only
     */
    private String identityProvider;

    /*
     * For internal use only
     */
    private Base64Url key;

    /*
     * For internal use only
     */
    private Integer type;

    /*
     * alternativeSecurityId
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphAlternativeSecurityId class.
     */
    public MicrosoftGraphAlternativeSecurityId() {
    }

    /**
     * Get the identityProvider property: For internal use only.
     * 
     * @return the identityProvider value.
     */
    public String identityProvider() {
        return this.identityProvider;
    }

    /**
     * Set the identityProvider property: For internal use only.
     * 
     * @param identityProvider the identityProvider value to set.
     * @return the MicrosoftGraphAlternativeSecurityId object itself.
     */
    public MicrosoftGraphAlternativeSecurityId withIdentityProvider(String identityProvider) {
        this.identityProvider = identityProvider;
        return this;
    }

    /**
     * Get the key property: For internal use only.
     * 
     * @return the key value.
     */
    public byte[] key() {
        if (this.key == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return this.key.decodedBytes();
    }

    /**
     * Set the key property: For internal use only.
     * 
     * @param key the key value to set.
     * @return the MicrosoftGraphAlternativeSecurityId object itself.
     */
    public MicrosoftGraphAlternativeSecurityId withKey(byte[] key) {
        if (key == null) {
            this.key = null;
        } else {
            this.key = Base64Url.encode(CoreUtils.clone(key));
        }
        return this;
    }

    /**
     * Get the type property: For internal use only.
     * 
     * @return the type value.
     */
    public Integer type() {
        return this.type;
    }

    /**
     * Set the type property: For internal use only.
     * 
     * @param type the type value to set.
     * @return the MicrosoftGraphAlternativeSecurityId object itself.
     */
    public MicrosoftGraphAlternativeSecurityId withType(Integer type) {
        this.type = type;
        return this;
    }

    /**
     * Get the additionalProperties property: alternativeSecurityId.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: alternativeSecurityId.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphAlternativeSecurityId object itself.
     */
    public MicrosoftGraphAlternativeSecurityId withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("identityProvider", this.identityProvider);
        jsonWriter.writeStringField("key", Objects.toString(this.key, null));
        jsonWriter.writeNumberField("type", this.type);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphAlternativeSecurityId from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphAlternativeSecurityId if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphAlternativeSecurityId.
     */
    public static MicrosoftGraphAlternativeSecurityId fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphAlternativeSecurityId deserializedMicrosoftGraphAlternativeSecurityId
                = new MicrosoftGraphAlternativeSecurityId();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("identityProvider".equals(fieldName)) {
                    deserializedMicrosoftGraphAlternativeSecurityId.identityProvider = reader.getString();
                } else if ("key".equals(fieldName)) {
                    deserializedMicrosoftGraphAlternativeSecurityId.key
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("type".equals(fieldName)) {
                    deserializedMicrosoftGraphAlternativeSecurityId.type = reader.getNullable(JsonReader::getInt);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphAlternativeSecurityId.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphAlternativeSecurityId;
        });
    }
}
