// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * chatInfo.
 */
@Fluent
public final class MicrosoftGraphChatInfo implements JsonSerializable<MicrosoftGraphChatInfo> {
    /*
     * The unique identifier of a message in a Microsoft Teams channel.
     */
    private String messageId;

    /*
     * The ID of the reply message.
     */
    private String replyChainMessageId;

    /*
     * The unique identifier for a thread in Microsoft Teams.
     */
    private String threadId;

    /*
     * chatInfo
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphChatInfo class.
     */
    public MicrosoftGraphChatInfo() {
    }

    /**
     * Get the messageId property: The unique identifier of a message in a Microsoft Teams channel.
     * 
     * @return the messageId value.
     */
    public String messageId() {
        return this.messageId;
    }

    /**
     * Set the messageId property: The unique identifier of a message in a Microsoft Teams channel.
     * 
     * @param messageId the messageId value to set.
     * @return the MicrosoftGraphChatInfo object itself.
     */
    public MicrosoftGraphChatInfo withMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    /**
     * Get the replyChainMessageId property: The ID of the reply message.
     * 
     * @return the replyChainMessageId value.
     */
    public String replyChainMessageId() {
        return this.replyChainMessageId;
    }

    /**
     * Set the replyChainMessageId property: The ID of the reply message.
     * 
     * @param replyChainMessageId the replyChainMessageId value to set.
     * @return the MicrosoftGraphChatInfo object itself.
     */
    public MicrosoftGraphChatInfo withReplyChainMessageId(String replyChainMessageId) {
        this.replyChainMessageId = replyChainMessageId;
        return this;
    }

    /**
     * Get the threadId property: The unique identifier for a thread in Microsoft Teams.
     * 
     * @return the threadId value.
     */
    public String threadId() {
        return this.threadId;
    }

    /**
     * Set the threadId property: The unique identifier for a thread in Microsoft Teams.
     * 
     * @param threadId the threadId value to set.
     * @return the MicrosoftGraphChatInfo object itself.
     */
    public MicrosoftGraphChatInfo withThreadId(String threadId) {
        this.threadId = threadId;
        return this;
    }

    /**
     * Get the additionalProperties property: chatInfo.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: chatInfo.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphChatInfo object itself.
     */
    public MicrosoftGraphChatInfo withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("messageId", this.messageId);
        jsonWriter.writeStringField("replyChainMessageId", this.replyChainMessageId);
        jsonWriter.writeStringField("threadId", this.threadId);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphChatInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphChatInfo if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphChatInfo.
     */
    public static MicrosoftGraphChatInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphChatInfo deserializedMicrosoftGraphChatInfo = new MicrosoftGraphChatInfo();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("messageId".equals(fieldName)) {
                    deserializedMicrosoftGraphChatInfo.messageId = reader.getString();
                } else if ("replyChainMessageId".equals(fieldName)) {
                    deserializedMicrosoftGraphChatInfo.replyChainMessageId = reader.getString();
                } else if ("threadId".equals(fieldName)) {
                    deserializedMicrosoftGraphChatInfo.threadId = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphChatInfo.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphChatInfo;
        });
    }
}
