// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * inferenceClassification.
 */
@Fluent
public final class MicrosoftGraphInferenceClassification extends MicrosoftGraphEntity {
    /*
     * A set of overrides for a user to always classify messages from specific senders in certain ways: focused, or
     * other. Read-only. Nullable.
     */
    private List<MicrosoftGraphInferenceClassificationOverride> overrides;

    /*
     * inferenceClassification
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphInferenceClassification class.
     */
    public MicrosoftGraphInferenceClassification() {
    }

    /**
     * Get the overrides property: A set of overrides for a user to always classify messages from specific senders in
     * certain ways: focused, or other. Read-only. Nullable.
     * 
     * @return the overrides value.
     */
    public List<MicrosoftGraphInferenceClassificationOverride> overrides() {
        return this.overrides;
    }

    /**
     * Set the overrides property: A set of overrides for a user to always classify messages from specific senders in
     * certain ways: focused, or other. Read-only. Nullable.
     * 
     * @param overrides the overrides value to set.
     * @return the MicrosoftGraphInferenceClassification object itself.
     */
    public MicrosoftGraphInferenceClassification
        withOverrides(List<MicrosoftGraphInferenceClassificationOverride> overrides) {
        this.overrides = overrides;
        return this;
    }

    /**
     * Get the additionalProperties property: inferenceClassification.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: inferenceClassification.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphInferenceClassification object itself.
     */
    public MicrosoftGraphInferenceClassification withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphInferenceClassification withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (overrides() != null) {
            overrides().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeArrayField("overrides", this.overrides, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphInferenceClassification from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphInferenceClassification if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphInferenceClassification.
     */
    public static MicrosoftGraphInferenceClassification fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphInferenceClassification deserializedMicrosoftGraphInferenceClassification
                = new MicrosoftGraphInferenceClassification();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphInferenceClassification.withId(reader.getString());
                } else if ("overrides".equals(fieldName)) {
                    List<MicrosoftGraphInferenceClassificationOverride> overrides
                        = reader.readArray(reader1 -> MicrosoftGraphInferenceClassificationOverride.fromJson(reader1));
                    deserializedMicrosoftGraphInferenceClassification.overrides = overrides;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphInferenceClassification.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphInferenceClassification;
        });
    }
}
