// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * itemActivity.
 */
@Fluent
public final class MicrosoftGraphItemActivity extends MicrosoftGraphEntity {
    /*
     * accessAction
     */
    private Map<String, Object> access;

    /*
     * Details about when the activity took place. Read-only.
     */
    private OffsetDateTime activityDateTime;

    /*
     * identitySet
     */
    private MicrosoftGraphIdentitySet actor;

    /*
     * driveItem
     */
    private MicrosoftGraphDriveItem driveItem;

    /*
     * itemActivity
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphItemActivity class.
     */
    public MicrosoftGraphItemActivity() {
    }

    /**
     * Get the access property: accessAction.
     * 
     * @return the access value.
     */
    public Map<String, Object> access() {
        return this.access;
    }

    /**
     * Set the access property: accessAction.
     * 
     * @param access the access value to set.
     * @return the MicrosoftGraphItemActivity object itself.
     */
    public MicrosoftGraphItemActivity withAccess(Map<String, Object> access) {
        this.access = access;
        return this;
    }

    /**
     * Get the activityDateTime property: Details about when the activity took place. Read-only.
     * 
     * @return the activityDateTime value.
     */
    public OffsetDateTime activityDateTime() {
        return this.activityDateTime;
    }

    /**
     * Set the activityDateTime property: Details about when the activity took place. Read-only.
     * 
     * @param activityDateTime the activityDateTime value to set.
     * @return the MicrosoftGraphItemActivity object itself.
     */
    public MicrosoftGraphItemActivity withActivityDateTime(OffsetDateTime activityDateTime) {
        this.activityDateTime = activityDateTime;
        return this;
    }

    /**
     * Get the actor property: identitySet.
     * 
     * @return the actor value.
     */
    public MicrosoftGraphIdentitySet actor() {
        return this.actor;
    }

    /**
     * Set the actor property: identitySet.
     * 
     * @param actor the actor value to set.
     * @return the MicrosoftGraphItemActivity object itself.
     */
    public MicrosoftGraphItemActivity withActor(MicrosoftGraphIdentitySet actor) {
        this.actor = actor;
        return this;
    }

    /**
     * Get the driveItem property: driveItem.
     * 
     * @return the driveItem value.
     */
    public MicrosoftGraphDriveItem driveItem() {
        return this.driveItem;
    }

    /**
     * Set the driveItem property: driveItem.
     * 
     * @param driveItem the driveItem value to set.
     * @return the MicrosoftGraphItemActivity object itself.
     */
    public MicrosoftGraphItemActivity withDriveItem(MicrosoftGraphDriveItem driveItem) {
        this.driveItem = driveItem;
        return this;
    }

    /**
     * Get the additionalProperties property: itemActivity.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: itemActivity.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphItemActivity object itself.
     */
    public MicrosoftGraphItemActivity withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphItemActivity withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (actor() != null) {
            actor().validate();
        }
        if (driveItem() != null) {
            driveItem().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeMapField("access", this.access, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("activityDateTime",
            this.activityDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.activityDateTime));
        jsonWriter.writeJsonField("actor", this.actor);
        jsonWriter.writeJsonField("driveItem", this.driveItem);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphItemActivity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphItemActivity if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphItemActivity.
     */
    public static MicrosoftGraphItemActivity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphItemActivity deserializedMicrosoftGraphItemActivity = new MicrosoftGraphItemActivity();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActivity.withId(reader.getString());
                } else if ("access".equals(fieldName)) {
                    Map<String, Object> access = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedMicrosoftGraphItemActivity.access = access;
                } else if ("activityDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActivity.activityDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("actor".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActivity.actor = MicrosoftGraphIdentitySet.fromJson(reader);
                } else if ("driveItem".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActivity.driveItem = MicrosoftGraphDriveItem.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphItemActivity.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphItemActivity;
        });
    }
}
