// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * plannerTaskDetails.
 */
@Fluent
public final class MicrosoftGraphPlannerTaskDetails extends MicrosoftGraphEntity {
    /*
     * plannerChecklistItems
     */
    private Map<String, Object> checklist;

    /*
     * Description of the task
     */
    private String description;

    /*
     * plannerPreviewType
     */
    private MicrosoftGraphPlannerPreviewType previewType;

    /*
     * plannerExternalReferences
     */
    private Map<String, Object> references;

    /*
     * plannerTaskDetails
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPlannerTaskDetails class.
     */
    public MicrosoftGraphPlannerTaskDetails() {
    }

    /**
     * Get the checklist property: plannerChecklistItems.
     * 
     * @return the checklist value.
     */
    public Map<String, Object> checklist() {
        return this.checklist;
    }

    /**
     * Set the checklist property: plannerChecklistItems.
     * 
     * @param checklist the checklist value to set.
     * @return the MicrosoftGraphPlannerTaskDetails object itself.
     */
    public MicrosoftGraphPlannerTaskDetails withChecklist(Map<String, Object> checklist) {
        this.checklist = checklist;
        return this;
    }

    /**
     * Get the description property: Description of the task.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the task.
     * 
     * @param description the description value to set.
     * @return the MicrosoftGraphPlannerTaskDetails object itself.
     */
    public MicrosoftGraphPlannerTaskDetails withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the previewType property: plannerPreviewType.
     * 
     * @return the previewType value.
     */
    public MicrosoftGraphPlannerPreviewType previewType() {
        return this.previewType;
    }

    /**
     * Set the previewType property: plannerPreviewType.
     * 
     * @param previewType the previewType value to set.
     * @return the MicrosoftGraphPlannerTaskDetails object itself.
     */
    public MicrosoftGraphPlannerTaskDetails withPreviewType(MicrosoftGraphPlannerPreviewType previewType) {
        this.previewType = previewType;
        return this;
    }

    /**
     * Get the references property: plannerExternalReferences.
     * 
     * @return the references value.
     */
    public Map<String, Object> references() {
        return this.references;
    }

    /**
     * Set the references property: plannerExternalReferences.
     * 
     * @param references the references value to set.
     * @return the MicrosoftGraphPlannerTaskDetails object itself.
     */
    public MicrosoftGraphPlannerTaskDetails withReferences(Map<String, Object> references) {
        this.references = references;
        return this;
    }

    /**
     * Get the additionalProperties property: plannerTaskDetails.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: plannerTaskDetails.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPlannerTaskDetails object itself.
     */
    public MicrosoftGraphPlannerTaskDetails withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphPlannerTaskDetails withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeMapField("checklist", this.checklist, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("previewType", this.previewType == null ? null : this.previewType.toString());
        jsonWriter.writeMapField("references", this.references, (writer, element) -> writer.writeUntyped(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPlannerTaskDetails from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPlannerTaskDetails if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPlannerTaskDetails.
     */
    public static MicrosoftGraphPlannerTaskDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPlannerTaskDetails deserializedMicrosoftGraphPlannerTaskDetails
                = new MicrosoftGraphPlannerTaskDetails();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTaskDetails.withId(reader.getString());
                } else if ("checklist".equals(fieldName)) {
                    Map<String, Object> checklist = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedMicrosoftGraphPlannerTaskDetails.checklist = checklist;
                } else if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTaskDetails.description = reader.getString();
                } else if ("previewType".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTaskDetails.previewType
                        = MicrosoftGraphPlannerPreviewType.fromString(reader.getString());
                } else if ("references".equals(fieldName)) {
                    Map<String, Object> references = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedMicrosoftGraphPlannerTaskDetails.references = references;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPlannerTaskDetails.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPlannerTaskDetails;
        });
    }
}
