// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * sharingDetail.
 */
@Fluent
public final class MicrosoftGraphSharingDetail implements JsonSerializable<MicrosoftGraphSharingDetail> {
    /*
     * insightIdentity
     */
    private MicrosoftGraphInsightIdentity sharedBy;

    /*
     * The date and time the file was last shared. The timestamp represents date and time information using ISO 8601
     * format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * 2014-01-01T00:00:00Z. Read-only.
     */
    private OffsetDateTime sharedDateTime;

    /*
     * resourceReference
     */
    private MicrosoftGraphResourceReference sharingReference;

    /*
     * The subject with which the document was shared.
     */
    private String sharingSubject;

    /*
     * Determines the way the document was shared, can be by a 'Link', 'Attachment', 'Group', 'Site'.
     */
    private String sharingType;

    /*
     * sharingDetail
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphSharingDetail class.
     */
    public MicrosoftGraphSharingDetail() {
    }

    /**
     * Get the sharedBy property: insightIdentity.
     * 
     * @return the sharedBy value.
     */
    public MicrosoftGraphInsightIdentity sharedBy() {
        return this.sharedBy;
    }

    /**
     * Set the sharedBy property: insightIdentity.
     * 
     * @param sharedBy the sharedBy value to set.
     * @return the MicrosoftGraphSharingDetail object itself.
     */
    public MicrosoftGraphSharingDetail withSharedBy(MicrosoftGraphInsightIdentity sharedBy) {
        this.sharedBy = sharedBy;
        return this;
    }

    /**
     * Get the sharedDateTime property: The date and time the file was last shared. The timestamp represents date and
     * time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would
     * look like this: 2014-01-01T00:00:00Z. Read-only.
     * 
     * @return the sharedDateTime value.
     */
    public OffsetDateTime sharedDateTime() {
        return this.sharedDateTime;
    }

    /**
     * Set the sharedDateTime property: The date and time the file was last shared. The timestamp represents date and
     * time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would
     * look like this: 2014-01-01T00:00:00Z. Read-only.
     * 
     * @param sharedDateTime the sharedDateTime value to set.
     * @return the MicrosoftGraphSharingDetail object itself.
     */
    public MicrosoftGraphSharingDetail withSharedDateTime(OffsetDateTime sharedDateTime) {
        this.sharedDateTime = sharedDateTime;
        return this;
    }

    /**
     * Get the sharingReference property: resourceReference.
     * 
     * @return the sharingReference value.
     */
    public MicrosoftGraphResourceReference sharingReference() {
        return this.sharingReference;
    }

    /**
     * Set the sharingReference property: resourceReference.
     * 
     * @param sharingReference the sharingReference value to set.
     * @return the MicrosoftGraphSharingDetail object itself.
     */
    public MicrosoftGraphSharingDetail withSharingReference(MicrosoftGraphResourceReference sharingReference) {
        this.sharingReference = sharingReference;
        return this;
    }

    /**
     * Get the sharingSubject property: The subject with which the document was shared.
     * 
     * @return the sharingSubject value.
     */
    public String sharingSubject() {
        return this.sharingSubject;
    }

    /**
     * Set the sharingSubject property: The subject with which the document was shared.
     * 
     * @param sharingSubject the sharingSubject value to set.
     * @return the MicrosoftGraphSharingDetail object itself.
     */
    public MicrosoftGraphSharingDetail withSharingSubject(String sharingSubject) {
        this.sharingSubject = sharingSubject;
        return this;
    }

    /**
     * Get the sharingType property: Determines the way the document was shared, can be by a 'Link', 'Attachment',
     * 'Group', 'Site'.
     * 
     * @return the sharingType value.
     */
    public String sharingType() {
        return this.sharingType;
    }

    /**
     * Set the sharingType property: Determines the way the document was shared, can be by a 'Link', 'Attachment',
     * 'Group', 'Site'.
     * 
     * @param sharingType the sharingType value to set.
     * @return the MicrosoftGraphSharingDetail object itself.
     */
    public MicrosoftGraphSharingDetail withSharingType(String sharingType) {
        this.sharingType = sharingType;
        return this;
    }

    /**
     * Get the additionalProperties property: sharingDetail.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: sharingDetail.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSharingDetail object itself.
     */
    public MicrosoftGraphSharingDetail withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sharedBy() != null) {
            sharedBy().validate();
        }
        if (sharingReference() != null) {
            sharingReference().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sharedBy", this.sharedBy);
        jsonWriter.writeStringField("sharedDateTime",
            this.sharedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.sharedDateTime));
        jsonWriter.writeJsonField("sharingReference", this.sharingReference);
        jsonWriter.writeStringField("sharingSubject", this.sharingSubject);
        jsonWriter.writeStringField("sharingType", this.sharingType);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphSharingDetail from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphSharingDetail if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphSharingDetail.
     */
    public static MicrosoftGraphSharingDetail fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphSharingDetail deserializedMicrosoftGraphSharingDetail = new MicrosoftGraphSharingDetail();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sharedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphSharingDetail.sharedBy = MicrosoftGraphInsightIdentity.fromJson(reader);
                } else if ("sharedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphSharingDetail.sharedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("sharingReference".equals(fieldName)) {
                    deserializedMicrosoftGraphSharingDetail.sharingReference
                        = MicrosoftGraphResourceReference.fromJson(reader);
                } else if ("sharingSubject".equals(fieldName)) {
                    deserializedMicrosoftGraphSharingDetail.sharingSubject = reader.getString();
                } else if ("sharingType".equals(fieldName)) {
                    deserializedMicrosoftGraphSharingDetail.sharingType = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphSharingDetail.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphSharingDetail;
        });
    }
}
