// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * teamGuestSettings.
 */
@Fluent
public final class MicrosoftGraphTeamGuestSettings implements JsonSerializable<MicrosoftGraphTeamGuestSettings> {
    /*
     * If set to true, guests can add and update channels.
     */
    private Boolean allowCreateUpdateChannels;

    /*
     * If set to true, guests can delete channels.
     */
    private Boolean allowDeleteChannels;

    /*
     * teamGuestSettings
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphTeamGuestSettings class.
     */
    public MicrosoftGraphTeamGuestSettings() {
    }

    /**
     * Get the allowCreateUpdateChannels property: If set to true, guests can add and update channels.
     * 
     * @return the allowCreateUpdateChannels value.
     */
    public Boolean allowCreateUpdateChannels() {
        return this.allowCreateUpdateChannels;
    }

    /**
     * Set the allowCreateUpdateChannels property: If set to true, guests can add and update channels.
     * 
     * @param allowCreateUpdateChannels the allowCreateUpdateChannels value to set.
     * @return the MicrosoftGraphTeamGuestSettings object itself.
     */
    public MicrosoftGraphTeamGuestSettings withAllowCreateUpdateChannels(Boolean allowCreateUpdateChannels) {
        this.allowCreateUpdateChannels = allowCreateUpdateChannels;
        return this;
    }

    /**
     * Get the allowDeleteChannels property: If set to true, guests can delete channels.
     * 
     * @return the allowDeleteChannels value.
     */
    public Boolean allowDeleteChannels() {
        return this.allowDeleteChannels;
    }

    /**
     * Set the allowDeleteChannels property: If set to true, guests can delete channels.
     * 
     * @param allowDeleteChannels the allowDeleteChannels value to set.
     * @return the MicrosoftGraphTeamGuestSettings object itself.
     */
    public MicrosoftGraphTeamGuestSettings withAllowDeleteChannels(Boolean allowDeleteChannels) {
        this.allowDeleteChannels = allowDeleteChannels;
        return this;
    }

    /**
     * Get the additionalProperties property: teamGuestSettings.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: teamGuestSettings.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTeamGuestSettings object itself.
     */
    public MicrosoftGraphTeamGuestSettings withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("allowCreateUpdateChannels", this.allowCreateUpdateChannels);
        jsonWriter.writeBooleanField("allowDeleteChannels", this.allowDeleteChannels);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphTeamGuestSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphTeamGuestSettings if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphTeamGuestSettings.
     */
    public static MicrosoftGraphTeamGuestSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphTeamGuestSettings deserializedMicrosoftGraphTeamGuestSettings
                = new MicrosoftGraphTeamGuestSettings();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allowCreateUpdateChannels".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamGuestSettings.allowCreateUpdateChannels
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowDeleteChannels".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamGuestSettings.allowDeleteChannels
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphTeamGuestSettings.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphTeamGuestSettings;
        });
    }
}
