// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * timeOff.
 */
@Fluent
public final class MicrosoftGraphTimeOff extends MicrosoftGraphChangeTrackedEntity {
    /*
     * timeOffItem
     */
    private MicrosoftGraphTimeOffItem draftTimeOff;

    /*
     * timeOffItem
     */
    private MicrosoftGraphTimeOffItem sharedTimeOff;

    /*
     * ID of the user assigned to the timeOff. Required.
     */
    private String userId;

    /*
     * timeOff
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphTimeOff class.
     */
    public MicrosoftGraphTimeOff() {
    }

    /**
     * Get the draftTimeOff property: timeOffItem.
     * 
     * @return the draftTimeOff value.
     */
    public MicrosoftGraphTimeOffItem draftTimeOff() {
        return this.draftTimeOff;
    }

    /**
     * Set the draftTimeOff property: timeOffItem.
     * 
     * @param draftTimeOff the draftTimeOff value to set.
     * @return the MicrosoftGraphTimeOff object itself.
     */
    public MicrosoftGraphTimeOff withDraftTimeOff(MicrosoftGraphTimeOffItem draftTimeOff) {
        this.draftTimeOff = draftTimeOff;
        return this;
    }

    /**
     * Get the sharedTimeOff property: timeOffItem.
     * 
     * @return the sharedTimeOff value.
     */
    public MicrosoftGraphTimeOffItem sharedTimeOff() {
        return this.sharedTimeOff;
    }

    /**
     * Set the sharedTimeOff property: timeOffItem.
     * 
     * @param sharedTimeOff the sharedTimeOff value to set.
     * @return the MicrosoftGraphTimeOff object itself.
     */
    public MicrosoftGraphTimeOff withSharedTimeOff(MicrosoftGraphTimeOffItem sharedTimeOff) {
        this.sharedTimeOff = sharedTimeOff;
        return this;
    }

    /**
     * Get the userId property: ID of the user assigned to the timeOff. Required.
     * 
     * @return the userId value.
     */
    public String userId() {
        return this.userId;
    }

    /**
     * Set the userId property: ID of the user assigned to the timeOff. Required.
     * 
     * @param userId the userId value to set.
     * @return the MicrosoftGraphTimeOff object itself.
     */
    public MicrosoftGraphTimeOff withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    /**
     * Get the additionalProperties property: timeOff.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: timeOff.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTimeOff object itself.
     */
    public MicrosoftGraphTimeOff withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphTimeOff withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphTimeOff withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphTimeOff withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphTimeOff withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (draftTimeOff() != null) {
            draftTimeOff().validate();
        }
        if (sharedTimeOff() != null) {
            sharedTimeOff().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("createdDateTime",
            createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(createdDateTime()));
        jsonWriter.writeJsonField("lastModifiedBy", lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime",
            lastModifiedDateTime() == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(lastModifiedDateTime()));
        jsonWriter.writeJsonField("draftTimeOff", this.draftTimeOff);
        jsonWriter.writeJsonField("sharedTimeOff", this.sharedTimeOff);
        jsonWriter.writeStringField("userId", this.userId);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphTimeOff from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphTimeOff if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphTimeOff.
     */
    public static MicrosoftGraphTimeOff fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphTimeOff deserializedMicrosoftGraphTimeOff = new MicrosoftGraphTimeOff();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOff.withId(reader.getString());
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOff.withCreatedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOff.withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                } else if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOff.withLastModifiedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("draftTimeOff".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOff.draftTimeOff = MicrosoftGraphTimeOffItem.fromJson(reader);
                } else if ("sharedTimeOff".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOff.sharedTimeOff = MicrosoftGraphTimeOffItem.fromJson(reader);
                } else if ("userId".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOff.userId = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphTimeOff.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphTimeOff;
        });
    }
}
