// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * timeOffItem.
 */
@Fluent
public final class MicrosoftGraphTimeOffItem extends MicrosoftGraphScheduleEntity {
    /*
     * ID of the timeOffReason for this timeOffItem. Required.
     */
    private String timeOffReasonId;

    /*
     * timeOffItem
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphTimeOffItem class.
     */
    public MicrosoftGraphTimeOffItem() {
    }

    /**
     * Get the timeOffReasonId property: ID of the timeOffReason for this timeOffItem. Required.
     * 
     * @return the timeOffReasonId value.
     */
    public String timeOffReasonId() {
        return this.timeOffReasonId;
    }

    /**
     * Set the timeOffReasonId property: ID of the timeOffReason for this timeOffItem. Required.
     * 
     * @param timeOffReasonId the timeOffReasonId value to set.
     * @return the MicrosoftGraphTimeOffItem object itself.
     */
    public MicrosoftGraphTimeOffItem withTimeOffReasonId(String timeOffReasonId) {
        this.timeOffReasonId = timeOffReasonId;
        return this;
    }

    /**
     * Get the additionalProperties property: timeOffItem.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: timeOffItem.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTimeOffItem object itself.
     */
    public MicrosoftGraphTimeOffItem withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphTimeOffItem withEndDateTime(OffsetDateTime endDateTime) {
        super.withEndDateTime(endDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphTimeOffItem withStartDateTime(OffsetDateTime startDateTime) {
        super.withStartDateTime(startDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphTimeOffItem withTheme(MicrosoftGraphScheduleEntityTheme theme) {
        super.withTheme(theme);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endDateTime",
            endDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(endDateTime()));
        jsonWriter.writeStringField("startDateTime",
            startDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(startDateTime()));
        jsonWriter.writeStringField("theme", theme() == null ? null : theme().toString());
        jsonWriter.writeStringField("timeOffReasonId", this.timeOffReasonId);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphTimeOffItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphTimeOffItem if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphTimeOffItem.
     */
    public static MicrosoftGraphTimeOffItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphTimeOffItem deserializedMicrosoftGraphTimeOffItem = new MicrosoftGraphTimeOffItem();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("endDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffItem.withEndDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("startDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffItem.withStartDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("theme".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffItem
                        .withTheme(MicrosoftGraphScheduleEntityTheme.fromString(reader.getString()));
                } else if ("timeOffReasonId".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffItem.timeOffReasonId = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphTimeOffItem.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphTimeOffItem;
        });
    }
}
