// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * workbookPivotTable.
 */
@Fluent
public final class MicrosoftGraphWorkbookPivotTable extends MicrosoftGraphEntity {
    /*
     * Name of the PivotTable.
     */
    private String name;

    /*
     * workbookWorksheet
     */
    private MicrosoftGraphWorkbookWorksheet worksheet;

    /*
     * workbookPivotTable
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookPivotTable class.
     */
    public MicrosoftGraphWorkbookPivotTable() {
    }

    /**
     * Get the name property: Name of the PivotTable.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the PivotTable.
     * 
     * @param name the name value to set.
     * @return the MicrosoftGraphWorkbookPivotTable object itself.
     */
    public MicrosoftGraphWorkbookPivotTable withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the worksheet property: workbookWorksheet.
     * 
     * @return the worksheet value.
     */
    public MicrosoftGraphWorkbookWorksheet worksheet() {
        return this.worksheet;
    }

    /**
     * Set the worksheet property: workbookWorksheet.
     * 
     * @param worksheet the worksheet value to set.
     * @return the MicrosoftGraphWorkbookPivotTable object itself.
     */
    public MicrosoftGraphWorkbookPivotTable withWorksheet(MicrosoftGraphWorkbookWorksheet worksheet) {
        this.worksheet = worksheet;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookPivotTable.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookPivotTable.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookPivotTable object itself.
     */
    public MicrosoftGraphWorkbookPivotTable withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphWorkbookPivotTable withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (worksheet() != null) {
            worksheet().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("worksheet", this.worksheet);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookPivotTable from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookPivotTable if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookPivotTable.
     */
    public static MicrosoftGraphWorkbookPivotTable fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookPivotTable deserializedMicrosoftGraphWorkbookPivotTable
                = new MicrosoftGraphWorkbookPivotTable();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookPivotTable.withId(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookPivotTable.name = reader.getString();
                } else if ("worksheet".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookPivotTable.worksheet
                        = MicrosoftGraphWorkbookWorksheet.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookPivotTable.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookPivotTable;
        });
    }
}
