// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.PolicyAssignmentProperties;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyRule;
import java.io.IOException;
import java.util.List;

/**
 * Role management policy assignment properties with scope.
 */
@Fluent
public final class RoleManagementPolicyAssignmentProperties
    implements JsonSerializable<RoleManagementPolicyAssignmentProperties> {
    /*
     * The role management policy scope.
     */
    private String scope;

    /*
     * The role definition of management policy assignment.
     */
    private String roleDefinitionId;

    /*
     * The policy id role management policy assignment.
     */
    private String policyId;

    /*
     * The readonly computed rule applied to the policy.
     */
    private List<RoleManagementPolicyRule> effectiveRules;

    /*
     * Additional properties of scope, role definition and policy
     */
    private PolicyAssignmentProperties policyAssignmentProperties;

    /**
     * Creates an instance of RoleManagementPolicyAssignmentProperties class.
     */
    public RoleManagementPolicyAssignmentProperties() {
    }

    /**
     * Get the scope property: The role management policy scope.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.scope;
    }

    /**
     * Set the scope property: The role management policy scope.
     * 
     * @param scope the scope value to set.
     * @return the RoleManagementPolicyAssignmentProperties object itself.
     */
    public RoleManagementPolicyAssignmentProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the roleDefinitionId property: The role definition of management policy assignment.
     * 
     * @return the roleDefinitionId value.
     */
    public String roleDefinitionId() {
        return this.roleDefinitionId;
    }

    /**
     * Set the roleDefinitionId property: The role definition of management policy assignment.
     * 
     * @param roleDefinitionId the roleDefinitionId value to set.
     * @return the RoleManagementPolicyAssignmentProperties object itself.
     */
    public RoleManagementPolicyAssignmentProperties withRoleDefinitionId(String roleDefinitionId) {
        this.roleDefinitionId = roleDefinitionId;
        return this;
    }

    /**
     * Get the policyId property: The policy id role management policy assignment.
     * 
     * @return the policyId value.
     */
    public String policyId() {
        return this.policyId;
    }

    /**
     * Set the policyId property: The policy id role management policy assignment.
     * 
     * @param policyId the policyId value to set.
     * @return the RoleManagementPolicyAssignmentProperties object itself.
     */
    public RoleManagementPolicyAssignmentProperties withPolicyId(String policyId) {
        this.policyId = policyId;
        return this;
    }

    /**
     * Get the effectiveRules property: The readonly computed rule applied to the policy.
     * 
     * @return the effectiveRules value.
     */
    public List<RoleManagementPolicyRule> effectiveRules() {
        return this.effectiveRules;
    }

    /**
     * Get the policyAssignmentProperties property: Additional properties of scope, role definition and policy.
     * 
     * @return the policyAssignmentProperties value.
     */
    public PolicyAssignmentProperties policyAssignmentProperties() {
        return this.policyAssignmentProperties;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (effectiveRules() != null) {
            effectiveRules().forEach(e -> e.validate());
        }
        if (policyAssignmentProperties() != null) {
            policyAssignmentProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeStringField("roleDefinitionId", this.roleDefinitionId);
        jsonWriter.writeStringField("policyId", this.policyId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoleManagementPolicyAssignmentProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoleManagementPolicyAssignmentProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RoleManagementPolicyAssignmentProperties.
     */
    public static RoleManagementPolicyAssignmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoleManagementPolicyAssignmentProperties deserializedRoleManagementPolicyAssignmentProperties
                = new RoleManagementPolicyAssignmentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("scope".equals(fieldName)) {
                    deserializedRoleManagementPolicyAssignmentProperties.scope = reader.getString();
                } else if ("roleDefinitionId".equals(fieldName)) {
                    deserializedRoleManagementPolicyAssignmentProperties.roleDefinitionId = reader.getString();
                } else if ("policyId".equals(fieldName)) {
                    deserializedRoleManagementPolicyAssignmentProperties.policyId = reader.getString();
                } else if ("effectiveRules".equals(fieldName)) {
                    List<RoleManagementPolicyRule> effectiveRules
                        = reader.readArray(reader1 -> RoleManagementPolicyRule.fromJson(reader1));
                    deserializedRoleManagementPolicyAssignmentProperties.effectiveRules = effectiveRules;
                } else if ("policyAssignmentProperties".equals(fieldName)) {
                    deserializedRoleManagementPolicyAssignmentProperties.policyAssignmentProperties
                        = PolicyAssignmentProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoleManagementPolicyAssignmentProperties;
        });
    }
}
