// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Expanded info of resource scope, role definition and policy.
 */
@Fluent
public final class PolicyAssignmentProperties implements JsonSerializable<PolicyAssignmentProperties> {
    /*
     * Details of the resource scope
     */
    private PolicyAssignmentPropertiesScope scope;

    /*
     * Details of role definition
     */
    private PolicyAssignmentPropertiesRoleDefinition roleDefinition;

    /*
     * Details of the policy
     */
    private PolicyAssignmentPropertiesPolicy policy;

    /**
     * Creates an instance of PolicyAssignmentProperties class.
     */
    public PolicyAssignmentProperties() {
    }

    /**
     * Get the scope property: Details of the resource scope.
     * 
     * @return the scope value.
     */
    public PolicyAssignmentPropertiesScope scope() {
        return this.scope;
    }

    /**
     * Set the scope property: Details of the resource scope.
     * 
     * @param scope the scope value to set.
     * @return the PolicyAssignmentProperties object itself.
     */
    public PolicyAssignmentProperties withScope(PolicyAssignmentPropertiesScope scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the roleDefinition property: Details of role definition.
     * 
     * @return the roleDefinition value.
     */
    public PolicyAssignmentPropertiesRoleDefinition roleDefinition() {
        return this.roleDefinition;
    }

    /**
     * Set the roleDefinition property: Details of role definition.
     * 
     * @param roleDefinition the roleDefinition value to set.
     * @return the PolicyAssignmentProperties object itself.
     */
    public PolicyAssignmentProperties withRoleDefinition(PolicyAssignmentPropertiesRoleDefinition roleDefinition) {
        this.roleDefinition = roleDefinition;
        return this;
    }

    /**
     * Get the policy property: Details of the policy.
     * 
     * @return the policy value.
     */
    public PolicyAssignmentPropertiesPolicy policy() {
        return this.policy;
    }

    /**
     * Set the policy property: Details of the policy.
     * 
     * @param policy the policy value to set.
     * @return the PolicyAssignmentProperties object itself.
     */
    public PolicyAssignmentProperties withPolicy(PolicyAssignmentPropertiesPolicy policy) {
        this.policy = policy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (scope() != null) {
            scope().validate();
        }
        if (roleDefinition() != null) {
            roleDefinition().validate();
        }
        if (policy() != null) {
            policy().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("scope", this.scope);
        jsonWriter.writeJsonField("roleDefinition", this.roleDefinition);
        jsonWriter.writeJsonField("policy", this.policy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicyAssignmentProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicyAssignmentProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PolicyAssignmentProperties.
     */
    public static PolicyAssignmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyAssignmentProperties deserializedPolicyAssignmentProperties = new PolicyAssignmentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("scope".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.scope = PolicyAssignmentPropertiesScope.fromJson(reader);
                } else if ("roleDefinition".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.roleDefinition
                        = PolicyAssignmentPropertiesRoleDefinition.fromJson(reader);
                } else if ("policy".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.policy = PolicyAssignmentPropertiesPolicy.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicyAssignmentProperties;
        });
    }
}
