// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * onenoteEntityBaseModel.
 */
@Fluent
public class MicrosoftGraphOnenoteEntityBaseModel extends MicrosoftGraphEntity {
    /*
     * The endpoint where you can get details about the page. Read-only.
     */
    private String self;

    /*
     * onenoteEntityBaseModel
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphOnenoteEntityBaseModel class.
     */
    public MicrosoftGraphOnenoteEntityBaseModel() {
    }

    /**
     * Get the self property: The endpoint where you can get details about the page. Read-only.
     * 
     * @return the self value.
     */
    public String self() {
        return this.self;
    }

    /**
     * Set the self property: The endpoint where you can get details about the page. Read-only.
     * 
     * @param self the self value to set.
     * @return the MicrosoftGraphOnenoteEntityBaseModel object itself.
     */
    public MicrosoftGraphOnenoteEntityBaseModel withSelf(String self) {
        this.self = self;
        return this;
    }

    /**
     * Get the additionalProperties property: onenoteEntityBaseModel.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: onenoteEntityBaseModel.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOnenoteEntityBaseModel object itself.
     */
    public MicrosoftGraphOnenoteEntityBaseModel withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphOnenoteEntityBaseModel withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("self", this.self);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphOnenoteEntityBaseModel from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphOnenoteEntityBaseModel if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphOnenoteEntityBaseModel.
     */
    public static MicrosoftGraphOnenoteEntityBaseModel fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphOnenoteEntityBaseModel deserializedMicrosoftGraphOnenoteEntityBaseModel
                = new MicrosoftGraphOnenoteEntityBaseModel();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteEntityBaseModel.withId(reader.getString());
                } else if ("self".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteEntityBaseModel.self = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphOnenoteEntityBaseModel.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphOnenoteEntityBaseModel;
        });
    }
}
