// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * video.
 */
@Fluent
public final class MicrosoftGraphVideo implements JsonSerializable<MicrosoftGraphVideo> {
    /*
     * Number of audio bits per sample.
     */
    private Integer audioBitsPerSample;

    /*
     * Number of audio channels.
     */
    private Integer audioChannels;

    /*
     * Name of the audio format (AAC, MP3, etc.).
     */
    private String audioFormat;

    /*
     * Number of audio samples per second.
     */
    private Integer audioSamplesPerSecond;

    /*
     * Bit rate of the video in bits per second.
     */
    private Integer bitrate;

    /*
     * Duration of the file in milliseconds.
     */
    private Long duration;

    /*
     * 'Four character code' name of the video format.
     */
    private String fourCC;

    /*
     * Frame rate of the video.
     */
    private Double frameRate;

    /*
     * Height of the video, in pixels.
     */
    private Integer height;

    /*
     * Width of the video, in pixels.
     */
    private Integer width;

    /*
     * video
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphVideo class.
     */
    public MicrosoftGraphVideo() {
    }

    /**
     * Get the audioBitsPerSample property: Number of audio bits per sample.
     * 
     * @return the audioBitsPerSample value.
     */
    public Integer audioBitsPerSample() {
        return this.audioBitsPerSample;
    }

    /**
     * Set the audioBitsPerSample property: Number of audio bits per sample.
     * 
     * @param audioBitsPerSample the audioBitsPerSample value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withAudioBitsPerSample(Integer audioBitsPerSample) {
        this.audioBitsPerSample = audioBitsPerSample;
        return this;
    }

    /**
     * Get the audioChannels property: Number of audio channels.
     * 
     * @return the audioChannels value.
     */
    public Integer audioChannels() {
        return this.audioChannels;
    }

    /**
     * Set the audioChannels property: Number of audio channels.
     * 
     * @param audioChannels the audioChannels value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withAudioChannels(Integer audioChannels) {
        this.audioChannels = audioChannels;
        return this;
    }

    /**
     * Get the audioFormat property: Name of the audio format (AAC, MP3, etc.).
     * 
     * @return the audioFormat value.
     */
    public String audioFormat() {
        return this.audioFormat;
    }

    /**
     * Set the audioFormat property: Name of the audio format (AAC, MP3, etc.).
     * 
     * @param audioFormat the audioFormat value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withAudioFormat(String audioFormat) {
        this.audioFormat = audioFormat;
        return this;
    }

    /**
     * Get the audioSamplesPerSecond property: Number of audio samples per second.
     * 
     * @return the audioSamplesPerSecond value.
     */
    public Integer audioSamplesPerSecond() {
        return this.audioSamplesPerSecond;
    }

    /**
     * Set the audioSamplesPerSecond property: Number of audio samples per second.
     * 
     * @param audioSamplesPerSecond the audioSamplesPerSecond value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withAudioSamplesPerSecond(Integer audioSamplesPerSecond) {
        this.audioSamplesPerSecond = audioSamplesPerSecond;
        return this;
    }

    /**
     * Get the bitrate property: Bit rate of the video in bits per second.
     * 
     * @return the bitrate value.
     */
    public Integer bitrate() {
        return this.bitrate;
    }

    /**
     * Set the bitrate property: Bit rate of the video in bits per second.
     * 
     * @param bitrate the bitrate value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withBitrate(Integer bitrate) {
        this.bitrate = bitrate;
        return this;
    }

    /**
     * Get the duration property: Duration of the file in milliseconds.
     * 
     * @return the duration value.
     */
    public Long duration() {
        return this.duration;
    }

    /**
     * Set the duration property: Duration of the file in milliseconds.
     * 
     * @param duration the duration value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withDuration(Long duration) {
        this.duration = duration;
        return this;
    }

    /**
     * Get the fourCC property: 'Four character code' name of the video format.
     * 
     * @return the fourCC value.
     */
    public String fourCC() {
        return this.fourCC;
    }

    /**
     * Set the fourCC property: 'Four character code' name of the video format.
     * 
     * @param fourCC the fourCC value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withFourCC(String fourCC) {
        this.fourCC = fourCC;
        return this;
    }

    /**
     * Get the frameRate property: Frame rate of the video.
     * 
     * @return the frameRate value.
     */
    public Double frameRate() {
        return this.frameRate;
    }

    /**
     * Set the frameRate property: Frame rate of the video.
     * 
     * @param frameRate the frameRate value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withFrameRate(Double frameRate) {
        this.frameRate = frameRate;
        return this;
    }

    /**
     * Get the height property: Height of the video, in pixels.
     * 
     * @return the height value.
     */
    public Integer height() {
        return this.height;
    }

    /**
     * Set the height property: Height of the video, in pixels.
     * 
     * @param height the height value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withHeight(Integer height) {
        this.height = height;
        return this;
    }

    /**
     * Get the width property: Width of the video, in pixels.
     * 
     * @return the width value.
     */
    public Integer width() {
        return this.width;
    }

    /**
     * Set the width property: Width of the video, in pixels.
     * 
     * @param width the width value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withWidth(Integer width) {
        this.width = width;
        return this;
    }

    /**
     * Get the additionalProperties property: video.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: video.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphVideo object itself.
     */
    public MicrosoftGraphVideo withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("audioBitsPerSample", this.audioBitsPerSample);
        jsonWriter.writeNumberField("audioChannels", this.audioChannels);
        jsonWriter.writeStringField("audioFormat", this.audioFormat);
        jsonWriter.writeNumberField("audioSamplesPerSecond", this.audioSamplesPerSecond);
        jsonWriter.writeNumberField("bitrate", this.bitrate);
        jsonWriter.writeNumberField("duration", this.duration);
        jsonWriter.writeStringField("fourCC", this.fourCC);
        jsonWriter.writeNumberField("frameRate", this.frameRate);
        jsonWriter.writeNumberField("height", this.height);
        jsonWriter.writeNumberField("width", this.width);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphVideo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphVideo if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphVideo.
     */
    public static MicrosoftGraphVideo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphVideo deserializedMicrosoftGraphVideo = new MicrosoftGraphVideo();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("audioBitsPerSample".equals(fieldName)) {
                    deserializedMicrosoftGraphVideo.audioBitsPerSample = reader.getNullable(JsonReader::getInt);
                } else if ("audioChannels".equals(fieldName)) {
                    deserializedMicrosoftGraphVideo.audioChannels = reader.getNullable(JsonReader::getInt);
                } else if ("audioFormat".equals(fieldName)) {
                    deserializedMicrosoftGraphVideo.audioFormat = reader.getString();
                } else if ("audioSamplesPerSecond".equals(fieldName)) {
                    deserializedMicrosoftGraphVideo.audioSamplesPerSecond = reader.getNullable(JsonReader::getInt);
                } else if ("bitrate".equals(fieldName)) {
                    deserializedMicrosoftGraphVideo.bitrate = reader.getNullable(JsonReader::getInt);
                } else if ("duration".equals(fieldName)) {
                    deserializedMicrosoftGraphVideo.duration = reader.getNullable(JsonReader::getLong);
                } else if ("fourCC".equals(fieldName)) {
                    deserializedMicrosoftGraphVideo.fourCC = reader.getString();
                } else if ("frameRate".equals(fieldName)) {
                    deserializedMicrosoftGraphVideo.frameRate = reader.getNullable(JsonReader::getDouble);
                } else if ("height".equals(fieldName)) {
                    deserializedMicrosoftGraphVideo.height = reader.getNullable(JsonReader::getInt);
                } else if ("width".equals(fieldName)) {
                    deserializedMicrosoftGraphVideo.width = reader.getNullable(JsonReader::getInt);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphVideo.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphVideo;
        });
    }
}
