// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * workbookChartSeriesFormat.
 */
@Fluent
public final class MicrosoftGraphWorkbookChartSeriesFormat extends MicrosoftGraphEntity {
    /*
     * workbookChartFill
     */
    private MicrosoftGraphWorkbookChartFill fill;

    /*
     * workbookChartLineFormat
     */
    private MicrosoftGraphWorkbookChartLineFormat line;

    /*
     * workbookChartSeriesFormat
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookChartSeriesFormat class.
     */
    public MicrosoftGraphWorkbookChartSeriesFormat() {
    }

    /**
     * Get the fill property: workbookChartFill.
     * 
     * @return the fill value.
     */
    public MicrosoftGraphWorkbookChartFill fill() {
        return this.fill;
    }

    /**
     * Set the fill property: workbookChartFill.
     * 
     * @param fill the fill value to set.
     * @return the MicrosoftGraphWorkbookChartSeriesFormat object itself.
     */
    public MicrosoftGraphWorkbookChartSeriesFormat withFill(MicrosoftGraphWorkbookChartFill fill) {
        this.fill = fill;
        return this;
    }

    /**
     * Get the line property: workbookChartLineFormat.
     * 
     * @return the line value.
     */
    public MicrosoftGraphWorkbookChartLineFormat line() {
        return this.line;
    }

    /**
     * Set the line property: workbookChartLineFormat.
     * 
     * @param line the line value to set.
     * @return the MicrosoftGraphWorkbookChartSeriesFormat object itself.
     */
    public MicrosoftGraphWorkbookChartSeriesFormat withLine(MicrosoftGraphWorkbookChartLineFormat line) {
        this.line = line;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookChartSeriesFormat.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookChartSeriesFormat.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookChartSeriesFormat object itself.
     */
    public MicrosoftGraphWorkbookChartSeriesFormat withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphWorkbookChartSeriesFormat withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (fill() != null) {
            fill().validate();
        }
        if (line() != null) {
            line().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("fill", this.fill);
        jsonWriter.writeJsonField("line", this.line);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookChartSeriesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookChartSeriesFormat if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookChartSeriesFormat.
     */
    public static MicrosoftGraphWorkbookChartSeriesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookChartSeriesFormat deserializedMicrosoftGraphWorkbookChartSeriesFormat
                = new MicrosoftGraphWorkbookChartSeriesFormat();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartSeriesFormat.withId(reader.getString());
                } else if ("fill".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartSeriesFormat.fill
                        = MicrosoftGraphWorkbookChartFill.fromJson(reader);
                } else if ("line".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartSeriesFormat.line
                        = MicrosoftGraphWorkbookChartLineFormat.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookChartSeriesFormat.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookChartSeriesFormat;
        });
    }
}
