/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphMessage;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphMessageRule;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphMultiValueLegacyExtendedProperty;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSingleValueLegacyExtendedProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphMailFolder
extends MicrosoftGraphEntity {
    private Integer childFolderCount;
    private String displayName;
    private String parentFolderId;
    private Integer totalItemCount;
    private Integer unreadItemCount;
    private List<MicrosoftGraphMailFolder> childFolders;
    private List<MicrosoftGraphMessageRule> messageRules;
    private List<MicrosoftGraphMessage> messages;
    private List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties;
    private List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties;
    private Map<String, Object> additionalProperties;

    public Integer childFolderCount() {
        return this.childFolderCount;
    }

    public MicrosoftGraphMailFolder withChildFolderCount(Integer childFolderCount) {
        this.childFolderCount = childFolderCount;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphMailFolder withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String parentFolderId() {
        return this.parentFolderId;
    }

    public MicrosoftGraphMailFolder withParentFolderId(String parentFolderId) {
        this.parentFolderId = parentFolderId;
        return this;
    }

    public Integer totalItemCount() {
        return this.totalItemCount;
    }

    public MicrosoftGraphMailFolder withTotalItemCount(Integer totalItemCount) {
        this.totalItemCount = totalItemCount;
        return this;
    }

    public Integer unreadItemCount() {
        return this.unreadItemCount;
    }

    public MicrosoftGraphMailFolder withUnreadItemCount(Integer unreadItemCount) {
        this.unreadItemCount = unreadItemCount;
        return this;
    }

    public List<MicrosoftGraphMailFolder> childFolders() {
        return this.childFolders;
    }

    public MicrosoftGraphMailFolder withChildFolders(List<MicrosoftGraphMailFolder> childFolders) {
        this.childFolders = childFolders;
        return this;
    }

    public List<MicrosoftGraphMessageRule> messageRules() {
        return this.messageRules;
    }

    public MicrosoftGraphMailFolder withMessageRules(List<MicrosoftGraphMessageRule> messageRules) {
        this.messageRules = messageRules;
        return this;
    }

    public List<MicrosoftGraphMessage> messages() {
        return this.messages;
    }

    public MicrosoftGraphMailFolder withMessages(List<MicrosoftGraphMessage> messages) {
        this.messages = messages;
        return this;
    }

    public List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties() {
        return this.multiValueExtendedProperties;
    }

    public MicrosoftGraphMailFolder withMultiValueExtendedProperties(List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
        this.multiValueExtendedProperties = multiValueExtendedProperties;
        return this;
    }

    public List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties() {
        return this.singleValueExtendedProperties;
    }

    public MicrosoftGraphMailFolder withSingleValueExtendedProperties(List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
        this.singleValueExtendedProperties = singleValueExtendedProperties;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphMailFolder withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphMailFolder withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.childFolders() != null) {
            this.childFolders().forEach(e -> e.validate());
        }
        if (this.messageRules() != null) {
            this.messageRules().forEach(e -> e.validate());
        }
        if (this.messages() != null) {
            this.messages().forEach(e -> e.validate());
        }
        if (this.multiValueExtendedProperties() != null) {
            this.multiValueExtendedProperties().forEach(e -> e.validate());
        }
        if (this.singleValueExtendedProperties() != null) {
            this.singleValueExtendedProperties().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeNumberField("childFolderCount", (Number)this.childFolderCount);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("parentFolderId", this.parentFolderId);
        jsonWriter.writeNumberField("totalItemCount", (Number)this.totalItemCount);
        jsonWriter.writeNumberField("unreadItemCount", (Number)this.unreadItemCount);
        jsonWriter.writeArrayField("childFolders", this.childFolders, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("messageRules", this.messageRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("messages", this.messages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("multiValueExtendedProperties", this.multiValueExtendedProperties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("singleValueExtendedProperties", this.singleValueExtendedProperties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphMailFolder fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphMailFolder)jsonReader.readObject(reader -> {
            MicrosoftGraphMailFolder deserializedMicrosoftGraphMailFolder = new MicrosoftGraphMailFolder();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphMailFolder.withId(reader.getString());
                    continue;
                }
                if ("childFolderCount".equals(fieldName)) {
                    deserializedMicrosoftGraphMailFolder.childFolderCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphMailFolder.displayName = reader.getString();
                    continue;
                }
                if ("parentFolderId".equals(fieldName)) {
                    deserializedMicrosoftGraphMailFolder.parentFolderId = reader.getString();
                    continue;
                }
                if ("totalItemCount".equals(fieldName)) {
                    deserializedMicrosoftGraphMailFolder.totalItemCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("unreadItemCount".equals(fieldName)) {
                    deserializedMicrosoftGraphMailFolder.unreadItemCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("childFolders".equals(fieldName)) {
                    List childFolders;
                    deserializedMicrosoftGraphMailFolder.childFolders = childFolders = reader.readArray(reader1 -> MicrosoftGraphMailFolder.fromJson(reader1));
                    continue;
                }
                if ("messageRules".equals(fieldName)) {
                    List messageRules;
                    deserializedMicrosoftGraphMailFolder.messageRules = messageRules = reader.readArray(reader1 -> MicrosoftGraphMessageRule.fromJson(reader1));
                    continue;
                }
                if ("messages".equals(fieldName)) {
                    List messages;
                    deserializedMicrosoftGraphMailFolder.messages = messages = reader.readArray(reader1 -> MicrosoftGraphMessage.fromJson(reader1));
                    continue;
                }
                if ("multiValueExtendedProperties".equals(fieldName)) {
                    List multiValueExtendedProperties;
                    deserializedMicrosoftGraphMailFolder.multiValueExtendedProperties = multiValueExtendedProperties = reader.readArray(reader1 -> MicrosoftGraphMultiValueLegacyExtendedProperty.fromJson(reader1));
                    continue;
                }
                if ("singleValueExtendedProperties".equals(fieldName)) {
                    List singleValueExtendedProperties;
                    deserializedMicrosoftGraphMailFolder.singleValueExtendedProperties = singleValueExtendedProperties = reader.readArray(reader1 -> MicrosoftGraphSingleValueLegacyExtendedProperty.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphMailFolder.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphMailFolder;
        });
    }
}

