/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.UsersOutlooksClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfOutlookCategory;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOutlookCategoryInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.fluent.models.UsersOutlookOrderby;
import com.azure.resourcemanager.authorization.fluent.models.UsersOutlookSelect;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class UsersOutlooksClientImpl
implements UsersOutlooksClient {
    private final ClientLogger logger = new ClientLogger(UsersOutlooksClientImpl.class);
    private final UsersOutlooksService service;
    private final MicrosoftGraphClientImpl client;

    UsersOutlooksClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (UsersOutlooksService)RestProxy.create(UsersOutlooksService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOutlookCategoryInner>> listMasterCategoriesSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOutlookOrderby> orderby, List<UsersOutlookSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listMasterCategories(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOutlookCategory)res.getValue()).value(), ((CollectionOfOutlookCategory)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOutlookCategoryInner>> listMasterCategoriesSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOutlookOrderby> orderby, List<UsersOutlookSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listMasterCategories(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOutlookCategory)res.getValue()).value(), ((CollectionOfOutlookCategory)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphOutlookCategoryInner> listMasterCategoriesAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOutlookOrderby> orderby, List<UsersOutlookSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listMasterCategoriesSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphOutlookCategoryInner> listMasterCategoriesAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listMasterCategoriesSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphOutlookCategoryInner> listMasterCategoriesAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOutlookOrderby> orderby, List<UsersOutlookSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listMasterCategoriesSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphOutlookCategoryInner> listMasterCategories(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOutlookOrderby> orderby = null;
        List<UsersOutlookSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listMasterCategoriesAsync(userId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphOutlookCategoryInner> listMasterCategories(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOutlookOrderby> orderby, List<UsersOutlookSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listMasterCategoriesAsync(userId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphOutlookCategoryInner>> createMasterCategoriesWithResponseAsync(String userId, MicrosoftGraphOutlookCategoryInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createMasterCategories(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphOutlookCategoryInner>> createMasterCategoriesWithResponseAsync(String userId, MicrosoftGraphOutlookCategoryInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createMasterCategories(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphOutlookCategoryInner> createMasterCategoriesAsync(String userId, MicrosoftGraphOutlookCategoryInner body) {
        return this.createMasterCategoriesWithResponseAsync(userId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphOutlookCategoryInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphOutlookCategoryInner createMasterCategories(String userId, MicrosoftGraphOutlookCategoryInner body) {
        return (MicrosoftGraphOutlookCategoryInner)this.createMasterCategoriesAsync(userId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphOutlookCategoryInner> createMasterCategoriesWithResponse(String userId, MicrosoftGraphOutlookCategoryInner body, Context context) {
        return (Response)this.createMasterCategoriesWithResponseAsync(userId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphOutlookCategoryInner>> getMasterCategoriesWithResponseAsync(String userId, String outlookCategoryId, List<UsersOutlookSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (outlookCategoryId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter outlookCategoryId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getMasterCategories(this.client.getEndpoint(), userId, outlookCategoryId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphOutlookCategoryInner>> getMasterCategoriesWithResponseAsync(String userId, String outlookCategoryId, List<UsersOutlookSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (outlookCategoryId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter outlookCategoryId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getMasterCategories(this.client.getEndpoint(), userId, outlookCategoryId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphOutlookCategoryInner> getMasterCategoriesAsync(String userId, String outlookCategoryId, List<UsersOutlookSelect> select, List<String> expand) {
        return this.getMasterCategoriesWithResponseAsync(userId, outlookCategoryId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphOutlookCategoryInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphOutlookCategoryInner> getMasterCategoriesAsync(String userId, String outlookCategoryId) {
        List<UsersOutlookSelect> select = null;
        List<String> expand = null;
        return this.getMasterCategoriesWithResponseAsync(userId, outlookCategoryId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphOutlookCategoryInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphOutlookCategoryInner getMasterCategories(String userId, String outlookCategoryId) {
        List<UsersOutlookSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphOutlookCategoryInner)this.getMasterCategoriesAsync(userId, outlookCategoryId, select, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphOutlookCategoryInner> getMasterCategoriesWithResponse(String userId, String outlookCategoryId, List<UsersOutlookSelect> select, List<String> expand, Context context) {
        return (Response)this.getMasterCategoriesWithResponseAsync(userId, outlookCategoryId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateMasterCategoriesWithResponseAsync(String userId, String outlookCategoryId, MicrosoftGraphOutlookCategoryInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (outlookCategoryId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter outlookCategoryId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateMasterCategories(this.client.getEndpoint(), userId, outlookCategoryId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateMasterCategoriesWithResponseAsync(String userId, String outlookCategoryId, MicrosoftGraphOutlookCategoryInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (outlookCategoryId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter outlookCategoryId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateMasterCategories(this.client.getEndpoint(), userId, outlookCategoryId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateMasterCategoriesAsync(String userId, String outlookCategoryId, MicrosoftGraphOutlookCategoryInner body) {
        return this.updateMasterCategoriesWithResponseAsync(userId, outlookCategoryId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateMasterCategories(String userId, String outlookCategoryId, MicrosoftGraphOutlookCategoryInner body) {
        this.updateMasterCategoriesAsync(userId, outlookCategoryId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateMasterCategoriesWithResponse(String userId, String outlookCategoryId, MicrosoftGraphOutlookCategoryInner body, Context context) {
        return (Response)this.updateMasterCategoriesWithResponseAsync(userId, outlookCategoryId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteMasterCategoriesWithResponseAsync(String userId, String outlookCategoryId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (outlookCategoryId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter outlookCategoryId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteMasterCategories(this.client.getEndpoint(), userId, outlookCategoryId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteMasterCategoriesWithResponseAsync(String userId, String outlookCategoryId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (outlookCategoryId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter outlookCategoryId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteMasterCategories(this.client.getEndpoint(), userId, outlookCategoryId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteMasterCategoriesAsync(String userId, String outlookCategoryId, String ifMatch) {
        return this.deleteMasterCategoriesWithResponseAsync(userId, outlookCategoryId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteMasterCategoriesAsync(String userId, String outlookCategoryId) {
        String ifMatch = null;
        return this.deleteMasterCategoriesWithResponseAsync(userId, outlookCategoryId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteMasterCategories(String userId, String outlookCategoryId) {
        String ifMatch = null;
        this.deleteMasterCategoriesAsync(userId, outlookCategoryId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteMasterCategoriesWithResponse(String userId, String outlookCategoryId, String ifMatch, Context context) {
        return (Response)this.deleteMasterCategoriesWithResponseAsync(userId, outlookCategoryId, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOutlookCategoryInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOutlookCategory)res.getValue()).value(), ((CollectionOfOutlookCategory)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOutlookCategoryInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOutlookCategory)res.getValue()).value(), ((CollectionOfOutlookCategory)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface UsersOutlooksService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/outlook/masterCategories")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfOutlookCategory>> listMasterCategories(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/users/{user-id}/outlook/masterCategories")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphOutlookCategoryInner>> createMasterCategories(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") MicrosoftGraphOutlookCategoryInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/outlook/masterCategories/{outlookCategory-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphOutlookCategoryInner>> getMasterCategories(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="outlookCategory-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/users/{user-id}/outlook/masterCategories/{outlookCategory-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateMasterCategories(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="outlookCategory-id") String var3, @BodyParam(value="application/json") MicrosoftGraphOutlookCategoryInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/users/{user-id}/outlook/masterCategories/{outlookCategory-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteMasterCategories(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="outlookCategory-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfOutlookCategory>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

