// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for DirectorySelect. */
public final class DirectorySelect extends ExpandableStringEnum<DirectorySelect> {
    /** Static value id for DirectorySelect. */
    public static final DirectorySelect ID = fromString("id");

    /** Static value deletedDateTime for DirectorySelect. */
    public static final DirectorySelect DELETED_DATE_TIME = fromString("deletedDateTime");

    /** Static value description for DirectorySelect. */
    public static final DirectorySelect DESCRIPTION = fromString("description");

    /** Static value displayName for DirectorySelect. */
    public static final DirectorySelect DISPLAY_NAME = fromString("displayName");

    /** Static value visibility for DirectorySelect. */
    public static final DirectorySelect VISIBILITY = fromString("visibility");

    /** Static value members for DirectorySelect. */
    public static final DirectorySelect MEMBERS = fromString("members");

    /** Static value scopedRoleMembers for DirectorySelect. */
    public static final DirectorySelect SCOPED_ROLE_MEMBERS = fromString("scopedRoleMembers");

    /** Static value extensions for DirectorySelect. */
    public static final DirectorySelect EXTENSIONS = fromString("extensions");

    /**
     * Creates or finds a DirectorySelect from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding DirectorySelect.
     */
    @JsonCreator
    public static DirectorySelect fromString(String name) {
        return fromString(name, DirectorySelect.class);
    }

    /** @return known DirectorySelect values. */
    public static Collection<DirectorySelect> values() {
        return values(DirectorySelect.class);
    }
}
