// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** identitySet. */
@Fluent
public final class MicrosoftGraphIdentitySet {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphIdentitySet.class);

    /*
     * identity
     */
    @JsonProperty(value = "application")
    private MicrosoftGraphIdentity application;

    /*
     * identity
     */
    @JsonProperty(value = "device")
    private MicrosoftGraphIdentity device;

    /*
     * identity
     */
    @JsonProperty(value = "user")
    private MicrosoftGraphIdentity user;

    /*
     * identitySet
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the application property: identity.
     *
     * @return the application value.
     */
    public MicrosoftGraphIdentity application() {
        return this.application;
    }

    /**
     * Set the application property: identity.
     *
     * @param application the application value to set.
     * @return the MicrosoftGraphIdentitySet object itself.
     */
    public MicrosoftGraphIdentitySet withApplication(MicrosoftGraphIdentity application) {
        this.application = application;
        return this;
    }

    /**
     * Get the device property: identity.
     *
     * @return the device value.
     */
    public MicrosoftGraphIdentity device() {
        return this.device;
    }

    /**
     * Set the device property: identity.
     *
     * @param device the device value to set.
     * @return the MicrosoftGraphIdentitySet object itself.
     */
    public MicrosoftGraphIdentitySet withDevice(MicrosoftGraphIdentity device) {
        this.device = device;
        return this;
    }

    /**
     * Get the user property: identity.
     *
     * @return the user value.
     */
    public MicrosoftGraphIdentity user() {
        return this.user;
    }

    /**
     * Set the user property: identity.
     *
     * @param user the user value to set.
     * @return the MicrosoftGraphIdentitySet object itself.
     */
    public MicrosoftGraphIdentitySet withUser(MicrosoftGraphIdentity user) {
        this.user = user;
        return this;
    }

    /**
     * Get the additionalProperties property: identitySet.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: identitySet.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphIdentitySet object itself.
     */
    public MicrosoftGraphIdentitySet withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (application() != null) {
            application().validate();
        }
        if (device() != null) {
            device().validate();
        }
        if (user() != null) {
            user().validate();
        }
    }
}
